static char rcsid[] = "$Id: afntyschd034.c,v 1.2 2002/04/03 11:51:52 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* 
 * afinity scheduling 034
 * offset ꤷơcyclic mapping  expr mapping 
 * ꤷưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


#ifndef __OMNI_SCASH__
main ()
{
  printf ("affinity scheduling is supported at OMNI_SCASH only.\n");
  exit (0);
}
#else


#define SIZE		(2*3*4)

#define OFFSET1		(1)
#define OFFSET2		(2)
#define OFFSET3		(100)
#define OFFSET4		(-1)
#define OFFSET5		(-2)
#define OFFSET6		(-100)

#define CHUNK1		(1)
#define CHUNK2		(2)
#define CHUNK51		(51)


int base1[SIZE];
int base2[SIZE];
int base3[SIZE];
int base4[SIZE];

#pragma omni mapping (base1[cyclic])
#pragma omni mapping (base2[cyclic(1)])
#pragma omni mapping (base3[cyclic(2)])
#pragma omni mapping (base4[cyclic(51)])


int array111[SIZE];
int array112[SIZE];
int array113[SIZE];
int array114[SIZE];
int array115[SIZE];
int array116[SIZE];

int array121[SIZE];
int array122[SIZE];
int array123[SIZE];
int array124[SIZE];
int array125[SIZE];
int array126[SIZE];

int array131[SIZE];
int array132[SIZE];
int array133[SIZE];
int array134[SIZE];
int array135[SIZE];
int array136[SIZE];

int array141[SIZE];
int array142[SIZE];
int array143[SIZE];
int array144[SIZE];
int array145[SIZE];
int array146[SIZE];

#pragma omni mapping(array111[i]:base1[i+1])
#pragma omni mapping(array112[i]:base1[i+2])
#pragma omni mapping(array113[i]:base1[i+100])
#pragma omni mapping(array114[i]:base1[i-1])
#pragma omni mapping(array115[i]:base1[i-2])
#pragma omni mapping(array116[i]:base1[i-100])

#pragma omni mapping(array121[i]:base2[i+1])
#pragma omni mapping(array122[i]:base2[i+2])
#pragma omni mapping(array123[i]:base2[i+100])
#pragma omni mapping(array124[i]:base2[i-1])
#pragma omni mapping(array125[i]:base2[i-2])
#pragma omni mapping(array126[i]:base2[i-100])

#pragma omni mapping(array131[i]:base3[i+1])
#pragma omni mapping(array132[i]:base3[i+2])
#pragma omni mapping(array133[i]:base3[i+100])
#pragma omni mapping(array134[i]:base3[i-1])
#pragma omni mapping(array135[i]:base3[i-2])
#pragma omni mapping(array136[i]:base3[i-100])

#pragma omni mapping(array141[i]:base4[i+1])
#pragma omni mapping(array142[i]:base4[i+2])
#pragma omni mapping(array143[i]:base4[i+100])
#pragma omni mapping(array144[i]:base4[i-1])
#pragma omni mapping(array145[i]:base4[i-2])
#pragma omni mapping(array146[i]:base4[i-100])


int array211[SIZE][SIZE];
int array212[SIZE][SIZE];
int array213[SIZE][SIZE];
int array214[SIZE][SIZE];
int array215[SIZE][SIZE];
int array216[SIZE][SIZE];

int array221[SIZE][SIZE];
int array222[SIZE][SIZE];
int array223[SIZE][SIZE];
int array224[SIZE][SIZE];
int array225[SIZE][SIZE];
int array226[SIZE][SIZE];

int array231[SIZE][SIZE];
int array232[SIZE][SIZE];
int array233[SIZE][SIZE];
int array234[SIZE][SIZE];
int array235[SIZE][SIZE];
int array236[SIZE][SIZE];

int array241[SIZE][SIZE];
int array242[SIZE][SIZE];
int array243[SIZE][SIZE];
int array244[SIZE][SIZE];
int array245[SIZE][SIZE];
int array246[SIZE][SIZE];

#pragma omni mapping(array211[*][i]:base1[i+1])
#pragma omni mapping(array212[*][i]:base1[i+2])
#pragma omni mapping(array213[*][i]:base1[i+100])
#pragma omni mapping(array214[*][i]:base1[i-1])
#pragma omni mapping(array215[*][i]:base1[i-2])
#pragma omni mapping(array216[*][i]:base1[i-100])

#pragma omni mapping(array221[*][i]:base2[i+1])
#pragma omni mapping(array222[*][i]:base2[i+2])
#pragma omni mapping(array223[*][i]:base2[i+100])
#pragma omni mapping(array224[*][i]:base2[i-1])
#pragma omni mapping(array225[*][i]:base2[i-2])
#pragma omni mapping(array226[*][i]:base2[i-100])

#pragma omni mapping(array231[*][i]:base3[i+1])
#pragma omni mapping(array232[*][i]:base3[i+2])
#pragma omni mapping(array233[*][i]:base3[i+100])
#pragma omni mapping(array234[*][i]:base3[i-1])
#pragma omni mapping(array235[*][i]:base3[i-2])
#pragma omni mapping(array236[*][i]:base3[i-100])

#pragma omni mapping(array241[*][i]:base4[i+1])
#pragma omni mapping(array242[*][i]:base4[i+2])
#pragma omni mapping(array243[*][i]:base4[i+100])
#pragma omni mapping(array244[*][i]:base4[i-1])
#pragma omni mapping(array245[*][i]:base4[i-2])
#pragma omni mapping(array246[*][i]:base4[i-100])


int array311[SIZE][SIZE];
int array312[SIZE][SIZE];
int array313[SIZE][SIZE];
int array314[SIZE][SIZE];
int array315[SIZE][SIZE];
int array316[SIZE][SIZE];

int array321[SIZE][SIZE];
int array322[SIZE][SIZE];
int array323[SIZE][SIZE];
int array324[SIZE][SIZE];
int array325[SIZE][SIZE];
int array326[SIZE][SIZE];

int array331[SIZE][SIZE];
int array332[SIZE][SIZE];
int array333[SIZE][SIZE];
int array334[SIZE][SIZE];
int array335[SIZE][SIZE];
int array336[SIZE][SIZE];

int array341[SIZE][SIZE];
int array342[SIZE][SIZE];
int array343[SIZE][SIZE];
int array344[SIZE][SIZE];
int array345[SIZE][SIZE];
int array346[SIZE][SIZE];

#pragma omni mapping(array311[i][*]:base1[i+1])
#pragma omni mapping(array312[i][*]:base1[i+2])
#pragma omni mapping(array313[i][*]:base1[i+100])
#pragma omni mapping(array314[i][*]:base1[i-1])
#pragma omni mapping(array315[i][*]:base1[i-2])
#pragma omni mapping(array316[i][*]:base1[i-100])

#pragma omni mapping(array321[i][*]:base2[i+1])
#pragma omni mapping(array322[i][*]:base2[i+2])
#pragma omni mapping(array323[i][*]:base2[i+100])
#pragma omni mapping(array324[i][*]:base2[i-1])
#pragma omni mapping(array325[i][*]:base2[i-2])
#pragma omni mapping(array326[i][*]:base2[i-100])

#pragma omni mapping(array331[i][*]:base3[i+1])
#pragma omni mapping(array332[i][*]:base3[i+2])
#pragma omni mapping(array333[i][*]:base3[i+100])
#pragma omni mapping(array334[i][*]:base3[i-1])
#pragma omni mapping(array335[i][*]:base3[i-2])
#pragma omni mapping(array336[i][*]:base3[i-100])

#pragma omni mapping(array341[i][*]:base4[i+1])
#pragma omni mapping(array342[i][*]:base4[i+2])
#pragma omni mapping(array343[i][*]:base4[i+100])
#pragma omni mapping(array344[i][*]:base4[i-1])
#pragma omni mapping(array345[i][*]:base4[i-2])
#pragma omni mapping(array346[i][*]:base4[i-100])


int errors = 0;
int p, s;


check (int thds, int *array, int chunksz, int size, int start, int end,
       int stride, int offset, int boffset)
{
  int chunk, i, v, next, tmp;

  chunk = chunksz;

  for (i = 0; i < size; i++) {
    if (i < start) {
      if (*(array + offset * i) != 0) {
	errors += 1;
      }

    } else if (i >=end) {
      if (*(array + offset * i) != 0) {
	errors += 1;
      }

    } else {
      tmp = i + boffset;
      while (tmp < 0) {
	tmp += chunk * thds;
      }
      v = (tmp/chunk) % thds + 1;

      if (i == start) {
	if (*(array + offset * i) != v) {
	  errors += 1;
	}
	next = i + stride;
      } else if (i == next) {
	if (*(array + offset * i) != v) {
	  errors += 1;
	}
	next += stride;
      } else {
	if (*(array + offset * i) != 0) {
	  errors += 1;
	}
      }
    }
  }
}


main ()
{
  int	thds, i;


  thds = omp_get_max_threads();
  if (thds == 1) {
    printf ("shuld be run this program on multi threads\n");
    exit (0);
  }


  for (p=0; p<SIZE; p++) {
    for (s=1; s<SIZE; s++) {
      memset (array111, 0, sizeof(array111));
      #pragma omp parallel for schedule(affinity, array111[i])
      for (i=p; i<SIZE; i+=s) {
	array111[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array111, CHUNK1, SIZE, p, SIZE, s, 1, OFFSET1);

      memset (array111, 0, sizeof(array111));
      #pragma omp parallel for schedule(affinity, array111[i])
      for (i=0; i<SIZE-p; i+=s) {
	array111[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array111, CHUNK1, SIZE, 0, SIZE-p, s, 1, OFFSET1);

      memset (array112, 0, sizeof(array112));
      #pragma omp parallel for schedule(affinity, array112[i])
      for (i=p; i<SIZE; i+=s) {
	array112[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array112, CHUNK1, SIZE, p, SIZE, s, 1, OFFSET2);

      memset (array112, 0, sizeof(array112));
      #pragma omp parallel for schedule(affinity, array112[i])
      for (i=0; i<SIZE-p; i+=s) {
	array112[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array112, CHUNK1, SIZE, 0, SIZE-p, s, 1, OFFSET2);

      memset (array113, 0, sizeof(array113));
      #pragma omp parallel for schedule(affinity, array113[i])
      for (i=p; i<SIZE; i+=s) {
	array113[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array113, CHUNK1, SIZE, p, SIZE, s, 1, OFFSET3);

      memset (array113, 0, sizeof(array113));
      #pragma omp parallel for schedule(affinity, array113[i])
      for (i=0; i<SIZE-p; i+=s) {
	array113[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array113, CHUNK1, SIZE, 0, SIZE-p, s, 1, OFFSET3);

      memset (array114, 0, sizeof(array114));
      #pragma omp parallel for schedule(affinity, array114[i])
      for (i=p; i<SIZE; i+=s) {
	array114[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array114, CHUNK1, SIZE, p, SIZE, s, 1, OFFSET4);

      memset (array114, 0, sizeof(array114));
      #pragma omp parallel for schedule(affinity, array114[i])
      for (i=0; i<SIZE-p; i+=s) {
	array114[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array114, CHUNK1, SIZE, 0, SIZE-p, s, 1, OFFSET4);

      memset (array115, 0, sizeof(array115));
      #pragma omp parallel for schedule(affinity, array115[i])
      for (i=p; i<SIZE; i+=s) {
	array115[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array115, CHUNK1, SIZE, p, SIZE, s, 1, OFFSET5);

      memset (array115, 0, sizeof(array115));
      #pragma omp parallel for schedule(affinity, array115[i])
      for (i=0; i<SIZE-p; i+=s) {
	array115[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array115, CHUNK1, SIZE, 0, SIZE-p, s, 1, OFFSET5);

      memset (array116, 0, sizeof(array116));
      #pragma omp parallel for schedule(affinity, array116[i])
      for (i=p; i<SIZE; i+=s) {
	array116[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array116, CHUNK1, SIZE, p, SIZE, s, 1, OFFSET6);

      memset (array116, 0, sizeof(array116));
      #pragma omp parallel for schedule(affinity, array116[i])
      for (i=0; i<SIZE-p; i+=s) {
	array116[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array116, CHUNK1, SIZE, 0, SIZE-p, s, 1, OFFSET6);


      memset (array121, 0, sizeof(array121));
      #pragma omp parallel for schedule(affinity, array121[i])
      for (i=p; i<SIZE; i+=s) {
	array121[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array121, CHUNK1, SIZE, p, SIZE, s, 1, OFFSET1);

      memset (array121, 0, sizeof(array121));
      #pragma omp parallel for schedule(affinity, array121[i])
      for (i=0; i<SIZE-p; i+=s) {
	array121[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array121, CHUNK1, SIZE, 0, SIZE-p, s, 1, OFFSET1);

      memset (array122, 0, sizeof(array122));
      #pragma omp parallel for schedule(affinity, array122[i])
      for (i=p; i<SIZE; i+=s) {
	array122[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array122, CHUNK1, SIZE, p, SIZE, s, 1, OFFSET2);

      memset (array122, 0, sizeof(array122));
      #pragma omp parallel for schedule(affinity, array122[i])
      for (i=0; i<SIZE-p; i+=s) {
	array122[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array122, CHUNK1, SIZE, 0, SIZE-p, s, 1, OFFSET2);

      memset (array123, 0, sizeof(array123));
      #pragma omp parallel for schedule(affinity, array123[i])
      for (i=p; i<SIZE; i+=s) {
	array123[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array123, CHUNK1, SIZE, p, SIZE, s, 1, OFFSET3);

      memset (array123, 0, sizeof(array123));
      #pragma omp parallel for schedule(affinity, array123[i])
      for (i=0; i<SIZE-p; i+=s) {
	array123[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array123, CHUNK1, SIZE, 0, SIZE-p, s, 1, OFFSET3);

      memset (array124, 0, sizeof(array124));
      #pragma omp parallel for schedule(affinity, array124[i])
      for (i=p; i<SIZE; i+=s) {
	array124[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array124, CHUNK1, SIZE, p, SIZE, s, 1, OFFSET4);

      memset (array124, 0, sizeof(array124));
      #pragma omp parallel for schedule(affinity, array124[i])
      for (i=0; i<SIZE-p; i+=s) {
	array124[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array124, CHUNK1, SIZE, 0, SIZE-p, s, 1, OFFSET4);

      memset (array125, 0, sizeof(array125));
      #pragma omp parallel for schedule(affinity, array125[i])
      for (i=p; i<SIZE; i+=s) {
	array125[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array125, CHUNK1, SIZE, p, SIZE, s, 1, OFFSET5);

      memset (array125, 0, sizeof(array125));
      #pragma omp parallel for schedule(affinity, array125[i])
      for (i=0; i<SIZE-p; i+=s) {
	array125[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array125, CHUNK1, SIZE, 0, SIZE-p, s, 1, OFFSET5);

      memset (array126, 0, sizeof(array126));
      #pragma omp parallel for schedule(affinity, array126[i])
      for (i=p; i<SIZE; i+=s) {
	array126[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array126, CHUNK1, SIZE, p, SIZE, s, 1, OFFSET6);

      memset (array126, 0, sizeof(array126));
      #pragma omp parallel for schedule(affinity, array126[i])
      for (i=0; i<SIZE-p; i+=s) {
	array126[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array126, CHUNK1, SIZE, 0, SIZE-p, s, 1, OFFSET6);


      memset (array131, 0, sizeof(array131));
      #pragma omp parallel for schedule(affinity, array131[i])
      for (i=p; i<SIZE; i+=s) {
	array131[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array131, CHUNK2, SIZE, p, SIZE, s, 1, OFFSET1);

      memset (array131, 0, sizeof(array131));
      #pragma omp parallel for schedule(affinity, array131[i])
      for (i=0; i<SIZE-p; i+=s) {
	array131[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array131, CHUNK2, SIZE, 0, SIZE-p, s, 1, OFFSET1);

      memset (array132, 0, sizeof(array132));
      #pragma omp parallel for schedule(affinity, array132[i])
      for (i=p; i<SIZE; i+=s) {
	array132[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array132, CHUNK2, SIZE, p, SIZE, s, 1, OFFSET2);

      memset (array132, 0, sizeof(array132));
      #pragma omp parallel for schedule(affinity, array132[i])
      for (i=0; i<SIZE-p; i+=s) {
	array132[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array132, CHUNK2, SIZE, 0, SIZE-p, s, 1, OFFSET2);

      memset (array133, 0, sizeof(array133));
      #pragma omp parallel for schedule(affinity, array133[i])
      for (i=p; i<SIZE; i+=s) {
	array133[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array133, CHUNK2, SIZE, p, SIZE, s, 1, OFFSET3);

      memset (array133, 0, sizeof(array133));
      #pragma omp parallel for schedule(affinity, array133[i])
      for (i=0; i<SIZE-p; i+=s) {
	array133[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array133, CHUNK2, SIZE, 0, SIZE-p, s, 1, OFFSET3);

      memset (array134, 0, sizeof(array134));
      #pragma omp parallel for schedule(affinity, array134[i])
      for (i=p; i<SIZE; i+=s) {
	array134[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array134, CHUNK2, SIZE, p, SIZE, s, 1, OFFSET4);

      memset (array134, 0, sizeof(array134));
      #pragma omp parallel for schedule(affinity, array134[i])
      for (i=0; i<SIZE-p; i+=s) {
	array134[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array134, CHUNK2, SIZE, 0, SIZE-p, s, 1, OFFSET4);

      memset (array135, 0, sizeof(array135));
      #pragma omp parallel for schedule(affinity, array135[i])
      for (i=p; i<SIZE; i+=s) {
	array135[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array135, CHUNK2, SIZE, p, SIZE, s, 1, OFFSET5);

      memset (array135, 0, sizeof(array135));
      #pragma omp parallel for schedule(affinity, array135[i])
      for (i=0; i<SIZE-p; i+=s) {
	array135[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array135, CHUNK2, SIZE, 0, SIZE-p, s, 1, OFFSET5);

      memset (array136, 0, sizeof(array136));
      #pragma omp parallel for schedule(affinity, array136[i])
      for (i=p; i<SIZE; i+=s) {
	array136[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array136, CHUNK2, SIZE, p, SIZE, s, 1, OFFSET6);

      memset (array136, 0, sizeof(array136));
      #pragma omp parallel for schedule(affinity, array136[i])
      for (i=0; i<SIZE-p; i+=s) {
	array136[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array136, CHUNK2, SIZE, 0, SIZE-p, s, 1, OFFSET6);


      memset (array141, 0, sizeof(array141));
      #pragma omp parallel for schedule(affinity, array141[i])
      for (i=p; i<SIZE; i+=s) {
	array141[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array141, CHUNK51, SIZE, p, SIZE, s, 1, OFFSET1);

      memset (array141, 0, sizeof(array141));
      #pragma omp parallel for schedule(affinity, array141[i])
      for (i=0; i<SIZE-p; i+=s) {
	array141[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array141, CHUNK51, SIZE, 0, SIZE-p, s, 1, OFFSET1);

      memset (array142, 0, sizeof(array142));
      #pragma omp parallel for schedule(affinity, array142[i])
      for (i=p; i<SIZE; i+=s) {
	array142[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array142, CHUNK51, SIZE, p, SIZE, s, 1, OFFSET2);

      memset (array142, 0, sizeof(array142));
      #pragma omp parallel for schedule(affinity, array142[i])
      for (i=0; i<SIZE-p; i+=s) {
	array142[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array142, CHUNK51, SIZE, 0, SIZE-p, s, 1, OFFSET2);

      memset (array143, 0, sizeof(array143));
      #pragma omp parallel for schedule(affinity, array143[i])
      for (i=p; i<SIZE; i+=s) {
	array143[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array143, CHUNK51, SIZE, p, SIZE, s, 1, OFFSET3);

      memset (array143, 0, sizeof(array143));
      #pragma omp parallel for schedule(affinity, array143[i])
      for (i=0; i<SIZE-p; i+=s) {
	array143[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array143, CHUNK51, SIZE, 0, SIZE-p, s, 1, OFFSET3);

      memset (array144, 0, sizeof(array144));
      #pragma omp parallel for schedule(affinity, array144[i])
      for (i=p; i<SIZE; i+=s) {
	array144[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array144, CHUNK51, SIZE, p, SIZE, s, 1, OFFSET4);

      memset (array144, 0, sizeof(array144));
      #pragma omp parallel for schedule(affinity, array144[i])
      for (i=0; i<SIZE-p; i+=s) {
	array144[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array144, CHUNK51, SIZE, 0, SIZE-p, s, 1, OFFSET4);

      memset (array145, 0, sizeof(array145));
      #pragma omp parallel for schedule(affinity, array145[i])
      for (i=p; i<SIZE; i+=s) {
	array145[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array145, CHUNK51, SIZE, p, SIZE, s, 1, OFFSET5);

      memset (array145, 0, sizeof(array145));
      #pragma omp parallel for schedule(affinity, array145[i])
      for (i=0; i<SIZE-p; i+=s) {
	array145[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array145, CHUNK51, SIZE, 0, SIZE-p, s, 1, OFFSET5);

      memset (array146, 0, sizeof(array146));
      #pragma omp parallel for schedule(affinity, array146[i])
      for (i=p; i<SIZE; i+=s) {
	array146[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array146, CHUNK51, SIZE, p, SIZE, s, 1, OFFSET6);

      memset (array146, 0, sizeof(array146));
      #pragma omp parallel for schedule(affinity, array146[i])
      for (i=0; i<SIZE-p; i+=s) {
	array146[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array146, CHUNK51, SIZE, 0, SIZE-p, s, 1, OFFSET6);


      memset (array211, 0, sizeof(array211));
      #pragma omp parallel for schedule(affinity, array211[*][i])
      for (i=p; i<SIZE; i+=s) {
	array211[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array211, CHUNK1, SIZE, p, SIZE, s, 1, OFFSET1);

      memset (array211, 0, sizeof(array211));
      #pragma omp parallel for schedule(affinity, array211[*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array211[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array211, CHUNK1, SIZE, 0, SIZE-p, s, 1, OFFSET1);

      memset (array212, 0, sizeof(array212));
      #pragma omp parallel for schedule(affinity, array212[*][i])
      for (i=p; i<SIZE; i+=s) {
	array212[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array212, CHUNK1, SIZE, p, SIZE, s, 1, OFFSET2);

      memset (array212, 0, sizeof(array212));
      #pragma omp parallel for schedule(affinity, array212[*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array212[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array212, CHUNK1, SIZE, 0, SIZE-p, s, 1, OFFSET2);

      memset (array213, 0, sizeof(array213));
      #pragma omp parallel for schedule(affinity, array213[*][i])
      for (i=p; i<SIZE; i+=s) {
	array213[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array213, CHUNK1, SIZE, p, SIZE, s, 1, OFFSET3);

      memset (array213, 0, sizeof(array213));
      #pragma omp parallel for schedule(affinity, array213[*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array213[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array213, CHUNK1, SIZE, 0, SIZE-p, s, 1, OFFSET3);

      memset (array214, 0, sizeof(array214));
      #pragma omp parallel for schedule(affinity, array214[*][i])
      for (i=p; i<SIZE; i+=s) {
	array214[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array214, CHUNK1, SIZE, p, SIZE, s, 1, OFFSET4);

      memset (array214, 0, sizeof(array214));
      #pragma omp parallel for schedule(affinity, array214[*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array214[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array214, CHUNK1, SIZE, 0, SIZE-p, s, 1, OFFSET4);

      memset (array215, 0, sizeof(array215));
      #pragma omp parallel for schedule(affinity, array215[*][i])
      for (i=p; i<SIZE; i+=s) {
	array215[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array215, CHUNK1, SIZE, p, SIZE, s, 1, OFFSET5);

      memset (array215, 0, sizeof(array215));
      #pragma omp parallel for schedule(affinity, array215[*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array215[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array215, CHUNK1, SIZE, 0, SIZE-p, s, 1, OFFSET5);

      memset (array216, 0, sizeof(array216));
      #pragma omp parallel for schedule(affinity, array216[*][i])
      for (i=p; i<SIZE; i+=s) {
	array216[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array216, CHUNK1, SIZE, p, SIZE, s, 1, OFFSET6);

      memset (array216, 0, sizeof(array216));
      #pragma omp parallel for schedule(affinity, array216[*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array216[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array216, CHUNK1, SIZE, 0, SIZE-p, s, 1, OFFSET6);


      memset (array221, 0, sizeof(array221));
      #pragma omp parallel for schedule(affinity, array221[*][i])
      for (i=p; i<SIZE; i+=s) {
	array221[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array221, CHUNK1, SIZE, p, SIZE, s, 1, OFFSET1);

      memset (array221, 0, sizeof(array221));
      #pragma omp parallel for schedule(affinity, array221[*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array221[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array221, CHUNK1, SIZE, 0, SIZE-p, s, 1, OFFSET1);

      memset (array222, 0, sizeof(array222));
      #pragma omp parallel for schedule(affinity, array222[*][i])
      for (i=p; i<SIZE; i+=s) {
	array222[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array222, CHUNK1, SIZE, p, SIZE, s, 1, OFFSET2);

      memset (array222, 0, sizeof(array222));
      #pragma omp parallel for schedule(affinity, array222[*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array222[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array222, CHUNK1, SIZE, 0, SIZE-p, s, 1, OFFSET2);

      memset (array223, 0, sizeof(array223));
      #pragma omp parallel for schedule(affinity, array223[*][i])
      for (i=p; i<SIZE; i+=s) {
	array223[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array223, CHUNK1, SIZE, p, SIZE, s, 1, OFFSET3);

      memset (array223, 0, sizeof(array223));
      #pragma omp parallel for schedule(affinity, array223[*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array223[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array223, CHUNK1, SIZE, 0, SIZE-p, s, 1, OFFSET3);

      memset (array224, 0, sizeof(array224));
      #pragma omp parallel for schedule(affinity, array224[*][i])
      for (i=p; i<SIZE; i+=s) {
	array224[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array224, CHUNK1, SIZE, p, SIZE, s, 1, OFFSET4);

      memset (array224, 0, sizeof(array224));
      #pragma omp parallel for schedule(affinity, array224[*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array224[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array224, CHUNK1, SIZE, 0, SIZE-p, s, 1, OFFSET4);

      memset (array225, 0, sizeof(array225));
      #pragma omp parallel for schedule(affinity, array225[*][i])
      for (i=p; i<SIZE; i+=s) {
	array225[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array225, CHUNK1, SIZE, p, SIZE, s, 1, OFFSET5);

      memset (array225, 0, sizeof(array225));
      #pragma omp parallel for schedule(affinity, array225[*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array225[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array225, CHUNK1, SIZE, 0, SIZE-p, s, 1, OFFSET5);

      memset (array226, 0, sizeof(array226));
      #pragma omp parallel for schedule(affinity, array226[*][i])
      for (i=p; i<SIZE; i+=s) {
	array226[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array226, CHUNK1, SIZE, p, SIZE, s, 1, OFFSET6);

      memset (array226, 0, sizeof(array226));
      #pragma omp parallel for schedule(affinity, array226[*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array226[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array226, CHUNK1, SIZE, 0, SIZE-p, s, 1, OFFSET6);


      memset (array231, 0, sizeof(array231));
      #pragma omp parallel for schedule(affinity, array231[*][i])
      for (i=p; i<SIZE; i+=s) {
	array231[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array231, CHUNK2, SIZE, p, SIZE, s, 1, OFFSET1);

      memset (array231, 0, sizeof(array231));
      #pragma omp parallel for schedule(affinity, array231[*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array231[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array231, CHUNK2, SIZE, 0, SIZE-p, s, 1, OFFSET1);

      memset (array232, 0, sizeof(array232));
      #pragma omp parallel for schedule(affinity, array232[*][i])
      for (i=p; i<SIZE; i+=s) {
	array232[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array232, CHUNK2, SIZE, p, SIZE, s, 1, OFFSET2);

      memset (array232, 0, sizeof(array232));
      #pragma omp parallel for schedule(affinity, array232[*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array232[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array232, CHUNK2, SIZE, 0, SIZE-p, s, 1, OFFSET2);

      memset (array233, 0, sizeof(array233));
      #pragma omp parallel for schedule(affinity, array233[*][i])
      for (i=p; i<SIZE; i+=s) {
	array233[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array233, CHUNK2, SIZE, p, SIZE, s, 1, OFFSET3);

      memset (array233, 0, sizeof(array233));
      #pragma omp parallel for schedule(affinity, array233[*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array233[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array233, CHUNK2, SIZE, 0, SIZE-p, s, 1, OFFSET3);

      memset (array234, 0, sizeof(array234));
      #pragma omp parallel for schedule(affinity, array234[*][i])
      for (i=p; i<SIZE; i+=s) {
	array234[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array234, CHUNK2, SIZE, p, SIZE, s, 1, OFFSET4);

      memset (array234, 0, sizeof(array234));
      #pragma omp parallel for schedule(affinity, array234[*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array234[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array234, CHUNK2, SIZE, 0, SIZE-p, s, 1, OFFSET4);

      memset (array235, 0, sizeof(array235));
      #pragma omp parallel for schedule(affinity, array235[*][i])
      for (i=p; i<SIZE; i+=s) {
	array235[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array235, CHUNK2, SIZE, p, SIZE, s, 1, OFFSET5);

      memset (array235, 0, sizeof(array235));
      #pragma omp parallel for schedule(affinity, array235[*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array235[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array235, CHUNK2, SIZE, 0, SIZE-p, s, 1, OFFSET5);

      memset (array236, 0, sizeof(array236));
      #pragma omp parallel for schedule(affinity, array236[*][i])
      for (i=p; i<SIZE; i+=s) {
	array236[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array236, CHUNK2, SIZE, p, SIZE, s, 1, OFFSET6);

      memset (array236, 0, sizeof(array236));
      #pragma omp parallel for schedule(affinity, array236[*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array236[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array236, CHUNK2, SIZE, 0, SIZE-p, s, 1, OFFSET6);


      memset (array241, 0, sizeof(array241));
      #pragma omp parallel for schedule(affinity, array241[*][i])
      for (i=p; i<SIZE; i+=s) {
	array241[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array241, CHUNK51, SIZE, p, SIZE, s, 1, OFFSET1);

      memset (array241, 0, sizeof(array241));
      #pragma omp parallel for schedule(affinity, array241[*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array241[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array241, CHUNK51, SIZE, 0, SIZE-p, s, 1, OFFSET1);

      memset (array242, 0, sizeof(array242));
      #pragma omp parallel for schedule(affinity, array242[*][i])
      for (i=p; i<SIZE; i+=s) {
	array242[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array242, CHUNK51, SIZE, p, SIZE, s, 1, OFFSET2);

      memset (array242, 0, sizeof(array242));
      #pragma omp parallel for schedule(affinity, array242[*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array242[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array242, CHUNK51, SIZE, 0, SIZE-p, s, 1, OFFSET2);

      memset (array243, 0, sizeof(array243));
      #pragma omp parallel for schedule(affinity, array243[*][i])
      for (i=p; i<SIZE; i+=s) {
	array243[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array243, CHUNK51, SIZE, p, SIZE, s, 1, OFFSET3);

      memset (array243, 0, sizeof(array243));
      #pragma omp parallel for schedule(affinity, array243[*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array243[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array243, CHUNK51, SIZE, 0, SIZE-p, s, 1, OFFSET3);

      memset (array244, 0, sizeof(array244));
      #pragma omp parallel for schedule(affinity, array244[*][i])
      for (i=p; i<SIZE; i+=s) {
	array244[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array244, CHUNK51, SIZE, p, SIZE, s, 1, OFFSET4);

      memset (array244, 0, sizeof(array244));
      #pragma omp parallel for schedule(affinity, array244[*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array244[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array244, CHUNK51, SIZE, 0, SIZE-p, s, 1, OFFSET4);

      memset (array245, 0, sizeof(array245));
      #pragma omp parallel for schedule(affinity, array245[*][i])
      for (i=p; i<SIZE; i+=s) {
	array245[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array245, CHUNK51, SIZE, p, SIZE, s, 1, OFFSET5);

      memset (array245, 0, sizeof(array245));
      #pragma omp parallel for schedule(affinity, array245[*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array245[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array245, CHUNK51, SIZE, 0, SIZE-p, s, 1, OFFSET5);

      memset (array246, 0, sizeof(array246));
      #pragma omp parallel for schedule(affinity, array246[*][i])
      for (i=p; i<SIZE; i+=s) {
	array246[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array246, CHUNK51, SIZE, p, SIZE, s, 1, OFFSET6);

      memset (array246, 0, sizeof(array246));
      #pragma omp parallel for schedule(affinity, array246[*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array246[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array246, CHUNK51, SIZE, 0, SIZE-p, s, 1, OFFSET6);


      memset (array311, 0, sizeof(array311));
      #pragma omp parallel for schedule(affinity, array311[i][*])
      for (i=p; i<SIZE; i+=s) {
	array311[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array311, CHUNK1, SIZE, p, SIZE, s, SIZE, OFFSET1);

      memset (array311, 0, sizeof(array311));
      #pragma omp parallel for schedule(affinity, array311[i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array311[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array311, CHUNK1, SIZE, 0, SIZE-p, s, SIZE, OFFSET1);

      memset (array312, 0, sizeof(array312));
      #pragma omp parallel for schedule(affinity, array312[i][*])
      for (i=p; i<SIZE; i+=s) {
	array312[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array312, CHUNK1, SIZE, p, SIZE, s, SIZE, OFFSET2);

      memset (array312, 0, sizeof(array312));
      #pragma omp parallel for schedule(affinity, array312[i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array312[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array312, CHUNK1, SIZE, 0, SIZE-p, s, SIZE, OFFSET2);

      memset (array313, 0, sizeof(array313));
      #pragma omp parallel for schedule(affinity, array313[i][*])
      for (i=p; i<SIZE; i+=s) {
	array313[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array313, CHUNK1, SIZE, p, SIZE, s, SIZE, OFFSET3);

      memset (array313, 0, sizeof(array313));
      #pragma omp parallel for schedule(affinity, array313[i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array313[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array313, CHUNK1, SIZE, 0, SIZE-p, s, SIZE, OFFSET3);

      memset (array314, 0, sizeof(array314));
      #pragma omp parallel for schedule(affinity, array314[i][*])
      for (i=p; i<SIZE; i+=s) {
	array314[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array314, CHUNK1, SIZE, p, SIZE, s, SIZE, OFFSET4);

      memset (array314, 0, sizeof(array314));
      #pragma omp parallel for schedule(affinity, array314[i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array314[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array314, CHUNK1, SIZE, 0, SIZE-p, s, SIZE, OFFSET4);

      memset (array315, 0, sizeof(array315));
      #pragma omp parallel for schedule(affinity, array315[i][*])
      for (i=p; i<SIZE; i+=s) {
	array315[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array315, CHUNK1, SIZE, p, SIZE, s, SIZE, OFFSET5);

      memset (array315, 0, sizeof(array315));
      #pragma omp parallel for schedule(affinity, array315[i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array315[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array315, CHUNK1, SIZE, 0, SIZE-p, s, SIZE, OFFSET5);

      memset (array316, 0, sizeof(array316));
      #pragma omp parallel for schedule(affinity, array316[i][*])
      for (i=p; i<SIZE; i+=s) {
	array316[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array316, CHUNK1, SIZE, p, SIZE, s, SIZE, OFFSET6);

      memset (array316, 0, sizeof(array316));
      #pragma omp parallel for schedule(affinity, array316[i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array316[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array316, CHUNK1, SIZE, 0, SIZE-p, s, SIZE, OFFSET6);


      memset (array321, 0, sizeof(array321));
      #pragma omp parallel for schedule(affinity, array321[i][*])
      for (i=p; i<SIZE; i+=s) {
	array321[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array321, CHUNK1, SIZE, p, SIZE, s, SIZE, OFFSET1);

      memset (array321, 0, sizeof(array321));
      #pragma omp parallel for schedule(affinity, array321[i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array321[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array321, CHUNK1, SIZE, 0, SIZE-p, s, SIZE, OFFSET1);

      memset (array322, 0, sizeof(array322));
      #pragma omp parallel for schedule(affinity, array322[i][*])
      for (i=p; i<SIZE; i+=s) {
	array322[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array322, CHUNK1, SIZE, p, SIZE, s, SIZE, OFFSET2);

      memset (array322, 0, sizeof(array322));
      #pragma omp parallel for schedule(affinity, array322[i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array322[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array322, CHUNK1, SIZE, 0, SIZE-p, s, SIZE, OFFSET2);

      memset (array323, 0, sizeof(array323));
      #pragma omp parallel for schedule(affinity, array323[i][*])
      for (i=p; i<SIZE; i+=s) {
	array323[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array323, CHUNK1, SIZE, p, SIZE, s, SIZE, OFFSET3);

      memset (array323, 0, sizeof(array323));
      #pragma omp parallel for schedule(affinity, array323[i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array323[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array323, CHUNK1, SIZE, 0, SIZE-p, s, SIZE, OFFSET3);

      memset (array324, 0, sizeof(array324));
      #pragma omp parallel for schedule(affinity, array324[i][*])
      for (i=p; i<SIZE; i+=s) {
	array324[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array324, CHUNK1, SIZE, p, SIZE, s, SIZE, OFFSET4);

      memset (array324, 0, sizeof(array324));
      #pragma omp parallel for schedule(affinity, array324[i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array324[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array324, CHUNK1, SIZE, 0, SIZE-p, s, SIZE, OFFSET4);

      memset (array325, 0, sizeof(array325));
      #pragma omp parallel for schedule(affinity, array325[i][*])
      for (i=p; i<SIZE; i+=s) {
	array325[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array325, CHUNK1, SIZE, p, SIZE, s, SIZE, OFFSET5);

      memset (array325, 0, sizeof(array325));
      #pragma omp parallel for schedule(affinity, array325[i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array325[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array325, CHUNK1, SIZE, 0, SIZE-p, s, SIZE, OFFSET5);

      memset (array326, 0, sizeof(array326));
      #pragma omp parallel for schedule(affinity, array326[i][*])
      for (i=p; i<SIZE; i+=s) {
	array326[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array326, CHUNK1, SIZE, p, SIZE, s, SIZE, OFFSET6);

      memset (array326, 0, sizeof(array326));
      #pragma omp parallel for schedule(affinity, array326[i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array326[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array326, CHUNK1, SIZE, 0, SIZE-p, s, SIZE, OFFSET6);


      memset (array331, 0, sizeof(array331));
      #pragma omp parallel for schedule(affinity, array331[i][*])
      for (i=p; i<SIZE; i+=s) {
	array331[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array331, CHUNK2, SIZE, p, SIZE, s, SIZE, OFFSET1);

      memset (array331, 0, sizeof(array331));
      #pragma omp parallel for schedule(affinity, array331[i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array331[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array331, CHUNK2, SIZE, 0, SIZE-p, s, SIZE, OFFSET1);

      memset (array332, 0, sizeof(array332));
      #pragma omp parallel for schedule(affinity, array332[i][*])
      for (i=p; i<SIZE; i+=s) {
	array332[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array332, CHUNK2, SIZE, p, SIZE, s, SIZE, OFFSET2);

      memset (array332, 0, sizeof(array332));
      #pragma omp parallel for schedule(affinity, array332[i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array332[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array332, CHUNK2, SIZE, 0, SIZE-p, s, SIZE, OFFSET2);

      memset (array333, 0, sizeof(array333));
      #pragma omp parallel for schedule(affinity, array333[i][*])
      for (i=p; i<SIZE; i+=s) {
	array333[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array333, CHUNK2, SIZE, p, SIZE, s, SIZE, OFFSET3);

      memset (array333, 0, sizeof(array333));
      #pragma omp parallel for schedule(affinity, array333[i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array333[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array333, CHUNK2, SIZE, 0, SIZE-p, s, SIZE, OFFSET3);

      memset (array334, 0, sizeof(array334));
      #pragma omp parallel for schedule(affinity, array334[i][*])
      for (i=p; i<SIZE; i+=s) {
	array334[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array334, CHUNK2, SIZE, p, SIZE, s, SIZE, OFFSET4);

      memset (array334, 0, sizeof(array334));
      #pragma omp parallel for schedule(affinity, array334[i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array334[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array334, CHUNK2, SIZE, 0, SIZE-p, s, SIZE, OFFSET4);

      memset (array335, 0, sizeof(array335));
      #pragma omp parallel for schedule(affinity, array335[i][*])
      for (i=p; i<SIZE; i+=s) {
	array335[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array335, CHUNK2, SIZE, p, SIZE, s, SIZE, OFFSET5);

      memset (array335, 0, sizeof(array335));
      #pragma omp parallel for schedule(affinity, array335[i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array335[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array335, CHUNK2, SIZE, 0, SIZE-p, s, SIZE, OFFSET5);

      memset (array336, 0, sizeof(array336));
      #pragma omp parallel for schedule(affinity, array336[i][*])
      for (i=p; i<SIZE; i+=s) {
	array336[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array336, CHUNK2, SIZE, p, SIZE, s, SIZE, OFFSET6);

      memset (array336, 0, sizeof(array336));
      #pragma omp parallel for schedule(affinity, array336[i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array336[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array336, CHUNK2, SIZE, 0, SIZE-p, s, SIZE, OFFSET6);


      memset (array341, 0, sizeof(array341));
      #pragma omp parallel for schedule(affinity, array341[i][*])
      for (i=p; i<SIZE; i+=s) {
	array341[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array341, CHUNK51, SIZE, p, SIZE, s, SIZE, OFFSET1);

      memset (array341, 0, sizeof(array341));
      #pragma omp parallel for schedule(affinity, array341[i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array341[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array341, CHUNK51, SIZE, 0, SIZE-p, s, SIZE, OFFSET1);

      memset (array342, 0, sizeof(array342));
      #pragma omp parallel for schedule(affinity, array342[i][*])
      for (i=p; i<SIZE; i+=s) {
	array342[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array342, CHUNK51, SIZE, p, SIZE, s, SIZE, OFFSET2);

      memset (array342, 0, sizeof(array342));
      #pragma omp parallel for schedule(affinity, array342[i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array342[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array342, CHUNK51, SIZE, 0, SIZE-p, s, SIZE, OFFSET2);

      memset (array343, 0, sizeof(array343));
      #pragma omp parallel for schedule(affinity, array343[i][*])
      for (i=p; i<SIZE; i+=s) {
	array343[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array343, CHUNK51, SIZE, p, SIZE, s, SIZE, OFFSET3);

      memset (array343, 0, sizeof(array343));
      #pragma omp parallel for schedule(affinity, array343[i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array343[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array343, CHUNK51, SIZE, 0, SIZE-p, s, SIZE, OFFSET3);

      memset (array344, 0, sizeof(array344));
      #pragma omp parallel for schedule(affinity, array344[i][*])
      for (i=p; i<SIZE; i+=s) {
	array344[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array344, CHUNK51, SIZE, p, SIZE, s, SIZE, OFFSET4);

      memset (array344, 0, sizeof(array344));
      #pragma omp parallel for schedule(affinity, array344[i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array344[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array344, CHUNK51, SIZE, 0, SIZE-p, s, SIZE, OFFSET4);

      memset (array345, 0, sizeof(array345));
      #pragma omp parallel for schedule(affinity, array345[i][*])
      for (i=p; i<SIZE; i+=s) {
	array345[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array345, CHUNK51, SIZE, p, SIZE, s, SIZE, OFFSET5);

      memset (array345, 0, sizeof(array345));
      #pragma omp parallel for schedule(affinity, array345[i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array345[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array345, CHUNK51, SIZE, 0, SIZE-p, s, SIZE, OFFSET5);

      memset (array346, 0, sizeof(array346));
      #pragma omp parallel for schedule(affinity, array346[i][*])
      for (i=p; i<SIZE; i+=s) {
	array346[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array346, CHUNK51, SIZE, p, SIZE, s, SIZE, OFFSET6);

      memset (array346, 0, sizeof(array346));
      #pragma omp parallel for schedule(affinity, array346[i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array346[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array346, CHUNK51, SIZE, 0, SIZE-p, s, SIZE, OFFSET6);
    }
  }


  if (errors == 0) {
    printf ("affinity scheduling 034 : SUCCESS\n");
    return 0;
  } else {
    printf ("affinity scheduling 034 : FAILED\n");
    return 1;
  }
}


#endif
