static char rcsid[] = "$Id: afntyschd037.c,v 1.2 2002/04/03 11:51:52 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* 
 * afinity scheduling 037
 * offset ꤷơۤʤ󥵥֤ǡcyclic scheduling 
 * expr mapping ꤷ affinity scheduling ưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


#ifndef __OMNI_SCASH__
main ()
{
  printf ("affinity scheduling is supported at OMNI_SCASH only.\n");
  exit (0);
}
#else


#define BSIZE		(2*3*4)
#define SIZEBIG		(2*3*4*2 + 1)
#define SIZESMALL	(2*3*4/2 + 1)

#define CHUNK1	1
#define CHUNK2	2
#define CHUNK51	51

#define OFFSET1	(1)
#define OFFSET2	(2)
#define OFFSET3	(100)
#define OFFSET4	(-1)
#define OFFSET5	(-2)
#define OFFSET6	(-100)


int base1[BSIZE];
int base2[BSIZE];
int base3[BSIZE];
int base3[BSIZE];

#pragma omni mapping(base1[cyclic])
#pragma omni mapping(base2[cyclic(1)])
#pragma omni mapping(base3[cyclic(2)])
#pragma omni mapping(base4[cyclic(51)])


int array111[SIZEBIG];
int array112[SIZEBIG];
int array113[SIZEBIG];
int array114[SIZEBIG];
int array115[SIZEBIG];
int array116[SIZEBIG];
int array121[SIZEBIG];
int array122[SIZEBIG];
int array123[SIZEBIG];
int array124[SIZEBIG];
int array125[SIZEBIG];
int array126[SIZEBIG];
int array131[SIZEBIG];
int array132[SIZEBIG];
int array133[SIZEBIG];
int array134[SIZEBIG];
int array135[SIZEBIG];
int array136[SIZEBIG];
int array141[SIZEBIG];
int array142[SIZEBIG];
int array143[SIZEBIG];
int array144[SIZEBIG];
int array145[SIZEBIG];
int array146[SIZEBIG];

#pragma omni mapping (array111[i]:base1[i+1])
#pragma omni mapping (array112[i]:base1[i+2])
#pragma omni mapping (array113[i]:base1[i+100])
#pragma omni mapping (array114[i]:base1[i-1])
#pragma omni mapping (array115[i]:base1[i-2])
#pragma omni mapping (array116[i]:base1[i-100])
#pragma omni mapping (array121[i]:base2[i+1])
#pragma omni mapping (array122[i]:base2[i+2])
#pragma omni mapping (array123[i]:base2[i+100])
#pragma omni mapping (array124[i]:base2[i-1])
#pragma omni mapping (array125[i]:base2[i-2])
#pragma omni mapping (array126[i]:base2[i-100])
#pragma omni mapping (array131[i]:base3[i+1])
#pragma omni mapping (array132[i]:base3[i+2])
#pragma omni mapping (array133[i]:base3[i+100])
#pragma omni mapping (array134[i]:base3[i-1])
#pragma omni mapping (array135[i]:base3[i-2])
#pragma omni mapping (array136[i]:base3[i-100])
#pragma omni mapping (array141[i]:base4[i+1])
#pragma omni mapping (array142[i]:base4[i+2])
#pragma omni mapping (array143[i]:base4[i+100])
#pragma omni mapping (array144[i]:base4[i-1])
#pragma omni mapping (array145[i]:base4[i-2])
#pragma omni mapping (array146[i]:base4[i-100])


int array211[SIZEBIG][BSIZE];
int array212[SIZEBIG][BSIZE];
int array213[SIZEBIG][BSIZE];
int array214[SIZEBIG][BSIZE];
int array215[SIZEBIG][BSIZE];
int array216[SIZEBIG][BSIZE];
int array221[SIZEBIG][BSIZE];
int array222[SIZEBIG][BSIZE];
int array223[SIZEBIG][BSIZE];
int array224[SIZEBIG][BSIZE];
int array225[SIZEBIG][BSIZE];
int array226[SIZEBIG][BSIZE];
int array231[SIZEBIG][BSIZE];
int array232[SIZEBIG][BSIZE];
int array233[SIZEBIG][BSIZE];
int array234[SIZEBIG][BSIZE];
int array235[SIZEBIG][BSIZE];
int array236[SIZEBIG][BSIZE];
int array241[SIZEBIG][BSIZE];
int array242[SIZEBIG][BSIZE];
int array243[SIZEBIG][BSIZE];
int array244[SIZEBIG][BSIZE];
int array245[SIZEBIG][BSIZE];
int array246[SIZEBIG][BSIZE];

#pragma omni mapping (array211[i][*]:base1[i+1])
#pragma omni mapping (array212[i][*]:base1[i+2])
#pragma omni mapping (array213[i][*]:base1[i+100])
#pragma omni mapping (array214[i][*]:base1[i-1])
#pragma omni mapping (array215[i][*]:base1[i-2])
#pragma omni mapping (array216[i][*]:base1[i-100])
#pragma omni mapping (array221[i][*]:base2[i+1])
#pragma omni mapping (array222[i][*]:base2[i+2])
#pragma omni mapping (array223[i][*]:base2[i+100])
#pragma omni mapping (array224[i][*]:base2[i-1])
#pragma omni mapping (array225[i][*]:base2[i-2])
#pragma omni mapping (array226[i][*]:base2[i-100])
#pragma omni mapping (array231[i][*]:base3[i+1])
#pragma omni mapping (array232[i][*]:base3[i+2])
#pragma omni mapping (array233[i][*]:base3[i+100])
#pragma omni mapping (array234[i][*]:base3[i-1])
#pragma omni mapping (array235[i][*]:base3[i-2])
#pragma omni mapping (array236[i][*]:base3[i-100])
#pragma omni mapping (array241[i][*]:base4[i+1])
#pragma omni mapping (array242[i][*]:base4[i+2])
#pragma omni mapping (array243[i][*]:base4[i+100])
#pragma omni mapping (array244[i][*]:base4[i-1])
#pragma omni mapping (array245[i][*]:base4[i-2])
#pragma omni mapping (array246[i][*]:base4[i-100])

int array311[BSIZE][SIZEBIG];
int array312[BSIZE][SIZEBIG];
int array313[BSIZE][SIZEBIG];
int array314[BSIZE][SIZEBIG];
int array315[BSIZE][SIZEBIG];
int array316[BSIZE][SIZEBIG];
int array321[BSIZE][SIZEBIG];
int array322[BSIZE][SIZEBIG];
int array323[BSIZE][SIZEBIG];
int array324[BSIZE][SIZEBIG];
int array325[BSIZE][SIZEBIG];
int array326[BSIZE][SIZEBIG];
int array331[BSIZE][SIZEBIG];
int array332[BSIZE][SIZEBIG];
int array333[BSIZE][SIZEBIG];
int array334[BSIZE][SIZEBIG];
int array335[BSIZE][SIZEBIG];
int array336[BSIZE][SIZEBIG];
int array341[BSIZE][SIZEBIG];
int array342[BSIZE][SIZEBIG];
int array343[BSIZE][SIZEBIG];
int array344[BSIZE][SIZEBIG];
int array345[BSIZE][SIZEBIG];
int array346[BSIZE][SIZEBIG];

#pragma omni mapping (array311[*][i]:base1[i+1])
#pragma omni mapping (array312[*][i]:base1[i+2])
#pragma omni mapping (array313[*][i]:base1[i+100])
#pragma omni mapping (array314[*][i]:base1[i-1])
#pragma omni mapping (array315[*][i]:base1[i-2])
#pragma omni mapping (array316[*][i]:base1[i-100])
#pragma omni mapping (array321[*][i]:base2[i+1])
#pragma omni mapping (array322[*][i]:base2[i+2])
#pragma omni mapping (array323[*][i]:base2[i+100])
#pragma omni mapping (array324[*][i]:base2[i-1])
#pragma omni mapping (array325[*][i]:base2[i-2])
#pragma omni mapping (array326[*][i]:base2[i-100])
#pragma omni mapping (array331[*][i]:base3[i+1])
#pragma omni mapping (array332[*][i]:base3[i+2])
#pragma omni mapping (array333[*][i]:base3[i+100])
#pragma omni mapping (array334[*][i]:base3[i-1])
#pragma omni mapping (array335[*][i]:base3[i-2])
#pragma omni mapping (array336[*][i]:base3[i-100])
#pragma omni mapping (array341[*][i]:base4[i+1])
#pragma omni mapping (array342[*][i]:base4[i+2])
#pragma omni mapping (array343[*][i]:base4[i+100])
#pragma omni mapping (array344[*][i]:base4[i-1])
#pragma omni mapping (array345[*][i]:base4[i-2])
#pragma omni mapping (array346[*][i]:base4[i-100])


int array411[SIZESMALL];
int array412[SIZESMALL];
int array413[SIZESMALL];
int array414[SIZESMALL];
int array415[SIZESMALL];
int array416[SIZESMALL];
int array421[SIZESMALL];
int array422[SIZESMALL];
int array423[SIZESMALL];
int array424[SIZESMALL];
int array425[SIZESMALL];
int array426[SIZESMALL];
int array431[SIZESMALL];
int array432[SIZESMALL];
int array433[SIZESMALL];
int array434[SIZESMALL];
int array435[SIZESMALL];
int array436[SIZESMALL];
int array441[SIZESMALL];
int array442[SIZESMALL];
int array443[SIZESMALL];
int array444[SIZESMALL];
int array445[SIZESMALL];
int array446[SIZESMALL];

#pragma omni mapping (array411[i]:base1[i+1])
#pragma omni mapping (array412[i]:base1[i+2])
#pragma omni mapping (array413[i]:base1[i+100])
#pragma omni mapping (array414[i]:base1[i-1])
#pragma omni mapping (array415[i]:base1[i-2])
#pragma omni mapping (array416[i]:base1[i-100])
#pragma omni mapping (array421[i]:base2[i+1])
#pragma omni mapping (array422[i]:base2[i+2])
#pragma omni mapping (array423[i]:base2[i+100])
#pragma omni mapping (array424[i]:base2[i-1])
#pragma omni mapping (array425[i]:base2[i-2])
#pragma omni mapping (array426[i]:base2[i-100])
#pragma omni mapping (array431[i]:base3[i+1])
#pragma omni mapping (array432[i]:base3[i+2])
#pragma omni mapping (array433[i]:base3[i+100])
#pragma omni mapping (array434[i]:base3[i-1])
#pragma omni mapping (array435[i]:base3[i-2])
#pragma omni mapping (array436[i]:base3[i-100])
#pragma omni mapping (array441[i]:base4[i+1])
#pragma omni mapping (array442[i]:base4[i+2])
#pragma omni mapping (array443[i]:base4[i+100])
#pragma omni mapping (array444[i]:base4[i-1])
#pragma omni mapping (array445[i]:base4[i-2])
#pragma omni mapping (array446[i]:base4[i-100])


int array511[SIZESMALL][BSIZE];
int array512[SIZESMALL][BSIZE];
int array513[SIZESMALL][BSIZE];
int array514[SIZESMALL][BSIZE];
int array515[SIZESMALL][BSIZE];
int array516[SIZESMALL][BSIZE];
int array521[SIZESMALL][BSIZE];
int array522[SIZESMALL][BSIZE];
int array523[SIZESMALL][BSIZE];
int array524[SIZESMALL][BSIZE];
int array525[SIZESMALL][BSIZE];
int array526[SIZESMALL][BSIZE];
int array531[SIZESMALL][BSIZE];
int array532[SIZESMALL][BSIZE];
int array533[SIZESMALL][BSIZE];
int array534[SIZESMALL][BSIZE];
int array535[SIZESMALL][BSIZE];
int array536[SIZESMALL][BSIZE];
int array541[SIZESMALL][BSIZE];
int array542[SIZESMALL][BSIZE];
int array543[SIZESMALL][BSIZE];
int array544[SIZESMALL][BSIZE];
int array545[SIZESMALL][BSIZE];
int array546[SIZESMALL][BSIZE];

#pragma omni mapping (array511[i][*]:base1[i+1])
#pragma omni mapping (array512[i][*]:base1[i+2])
#pragma omni mapping (array513[i][*]:base1[i+100])
#pragma omni mapping (array514[i][*]:base1[i-1])
#pragma omni mapping (array515[i][*]:base1[i-2])
#pragma omni mapping (array516[i][*]:base1[i-100])
#pragma omni mapping (array521[i][*]:base2[i+1])
#pragma omni mapping (array522[i][*]:base2[i+2])
#pragma omni mapping (array523[i][*]:base2[i+100])
#pragma omni mapping (array524[i][*]:base2[i-1])
#pragma omni mapping (array525[i][*]:base2[i-2])
#pragma omni mapping (array526[i][*]:base2[i-100])
#pragma omni mapping (array531[i][*]:base3[i+1])
#pragma omni mapping (array532[i][*]:base3[i+2])
#pragma omni mapping (array533[i][*]:base3[i+100])
#pragma omni mapping (array534[i][*]:base3[i-1])
#pragma omni mapping (array535[i][*]:base3[i-2])
#pragma omni mapping (array536[i][*]:base3[i-100])
#pragma omni mapping (array541[i][*]:base4[i+1])
#pragma omni mapping (array542[i][*]:base4[i+2])
#pragma omni mapping (array543[i][*]:base4[i+100])
#pragma omni mapping (array544[i][*]:base4[i-1])
#pragma omni mapping (array545[i][*]:base4[i-2])
#pragma omni mapping (array546[i][*]:base4[i-100])

int array611[BSIZE][SIZESMALL];
int array612[BSIZE][SIZESMALL];
int array613[BSIZE][SIZESMALL];
int array614[BSIZE][SIZESMALL];
int array615[BSIZE][SIZESMALL];
int array616[BSIZE][SIZESMALL];
int array621[BSIZE][SIZESMALL];
int array622[BSIZE][SIZESMALL];
int array623[BSIZE][SIZESMALL];
int array624[BSIZE][SIZESMALL];
int array625[BSIZE][SIZESMALL];
int array626[BSIZE][SIZESMALL];
int array631[BSIZE][SIZESMALL];
int array632[BSIZE][SIZESMALL];
int array633[BSIZE][SIZESMALL];
int array634[BSIZE][SIZESMALL];
int array635[BSIZE][SIZESMALL];
int array636[BSIZE][SIZESMALL];
int array641[BSIZE][SIZESMALL];
int array642[BSIZE][SIZESMALL];
int array643[BSIZE][SIZESMALL];
int array644[BSIZE][SIZESMALL];
int array645[BSIZE][SIZESMALL];
int array646[BSIZE][SIZESMALL];

#pragma omni mapping (array611[*][i]:base1[i+1])
#pragma omni mapping (array612[*][i]:base1[i+2])
#pragma omni mapping (array613[*][i]:base1[i+100])
#pragma omni mapping (array614[*][i]:base1[i-1])
#pragma omni mapping (array615[*][i]:base1[i-2])
#pragma omni mapping (array616[*][i]:base1[i-100])
#pragma omni mapping (array621[*][i]:base2[i+1])
#pragma omni mapping (array622[*][i]:base2[i+2])
#pragma omni mapping (array623[*][i]:base2[i+100])
#pragma omni mapping (array624[*][i]:base2[i-1])
#pragma omni mapping (array625[*][i]:base2[i-2])
#pragma omni mapping (array626[*][i]:base2[i-100])
#pragma omni mapping (array631[*][i]:base3[i+1])
#pragma omni mapping (array632[*][i]:base3[i+2])
#pragma omni mapping (array633[*][i]:base3[i+100])
#pragma omni mapping (array634[*][i]:base3[i-1])
#pragma omni mapping (array635[*][i]:base3[i-2])
#pragma omni mapping (array636[*][i]:base3[i-100])
#pragma omni mapping (array641[*][i]:base4[i+1])
#pragma omni mapping (array642[*][i]:base4[i+2])
#pragma omni mapping (array643[*][i]:base4[i+100])
#pragma omni mapping (array644[*][i]:base4[i-1])
#pragma omni mapping (array645[*][i]:base4[i-2])
#pragma omni mapping (array646[*][i]:base4[i-100])


int errors = 0;
int p, s;


check (int thds, int *array, int chunksz, int size, int start, int end,
       int stride, int offset, int boffset)
{
  int chunk, i, v, next, tmp;

  chunk = chunksz;

  for (i = 0; i < size; i++) {
    if (i < start) {
      if (*(array + offset * i) != 0) {
	errors += 1;
      }

    } else if (i >=end) {
      if (*(array + offset * i) != 0) {
	errors += 1;
      }

    } else {
      tmp = i + boffset;
      while (tmp < 0) {
	tmp += chunk * thds;
      }
      v = (tmp/chunk) % thds + 1;

      if (i == start) {
	if (*(array + offset * i) != v) {
	  errors += 1;
	}
	next = i + stride;
      } else if (i == next) {
	if (*(array + offset * i) != v) {
	  errors += 1;
	}
	next += stride;
      } else {
	if (*(array + offset * i) != 0) {
	  errors += 1;
	}
      }
    }
  }
}


main ()
{
  int	thds, i;


  thds = omp_get_max_threads();
  if (thds == 1) {
    printf ("shuld be run this program on multi threads\n");
    exit (0);
  }

  for (p=0; p<SIZEBIG; p++) {
    for (s=1; s<SIZEBIG; s++) {
      memset (array111, 0, sizeof(array111));
      #pragma omp parallel for schedule(affinity, array111[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array111[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array111, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1, OFFSET1);

      memset (array111, 0, sizeof(array111));
      #pragma omp parallel for schedule(affinity, array111[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array111[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array111, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET1);

      memset (array112, 0, sizeof(array112));
      #pragma omp parallel for schedule(affinity, array112[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array112[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array112, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1, OFFSET2);

      memset (array112, 0, sizeof(array112));
      #pragma omp parallel for schedule(affinity, array112[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array112[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array112, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET2);

      memset (array113, 0, sizeof(array113));
      #pragma omp parallel for schedule(affinity, array113[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array113[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array113, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1, OFFSET3);

      memset (array113, 0, sizeof(array113));
      #pragma omp parallel for schedule(affinity, array113[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array113[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array113, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET3);

      memset (array114, 0, sizeof(array114));
      #pragma omp parallel for schedule(affinity, array114[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array114[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array114, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1, OFFSET4);

      memset (array114, 0, sizeof(array114));
      #pragma omp parallel for schedule(affinity, array114[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array114[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array114, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET4);

      memset (array115, 0, sizeof(array115));
      #pragma omp parallel for schedule(affinity, array115[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array115[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array115, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1, OFFSET5);

      memset (array115, 0, sizeof(array115));
      #pragma omp parallel for schedule(affinity, array115[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array115[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array115, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET5);

      memset (array116, 0, sizeof(array116));
      #pragma omp parallel for schedule(affinity, array116[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array116[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array116, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1, OFFSET6);

      memset (array116, 0, sizeof(array116));
      #pragma omp parallel for schedule(affinity, array116[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array116[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array116, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET6);


      memset (array121, 0, sizeof(array121));
      #pragma omp parallel for schedule(affinity, array121[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array121[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array121, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1, OFFSET1);

      memset (array121, 0, sizeof(array121));
      #pragma omp parallel for schedule(affinity, array121[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array121[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array121, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET1);

      memset (array122, 0, sizeof(array122));
      #pragma omp parallel for schedule(affinity, array122[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array122[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array122, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1, OFFSET2);

      memset (array122, 0, sizeof(array122));
      #pragma omp parallel for schedule(affinity, array122[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array122[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array122, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET2);

      memset (array123, 0, sizeof(array123));
      #pragma omp parallel for schedule(affinity, array123[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array123[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array123, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1, OFFSET3);

      memset (array123, 0, sizeof(array123));
      #pragma omp parallel for schedule(affinity, array123[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array123[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array123, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET3);

      memset (array124, 0, sizeof(array124));
      #pragma omp parallel for schedule(affinity, array124[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array124[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array124, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1, OFFSET4);

      memset (array124, 0, sizeof(array124));
      #pragma omp parallel for schedule(affinity, array124[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array124[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array124, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET4);

      memset (array125, 0, sizeof(array125));
      #pragma omp parallel for schedule(affinity, array125[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array125[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array125, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1, OFFSET5);

      memset (array125, 0, sizeof(array125));
      #pragma omp parallel for schedule(affinity, array125[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array125[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array125, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET5);

      memset (array126, 0, sizeof(array126));
      #pragma omp parallel for schedule(affinity, array126[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array126[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array126, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1, OFFSET6);

      memset (array126, 0, sizeof(array126));
      #pragma omp parallel for schedule(affinity, array126[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array126[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array126, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET6);


      memset (array131, 0, sizeof(array131));
      #pragma omp parallel for schedule(affinity, array131[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array131[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array131, CHUNK2, SIZEBIG, p, SIZEBIG, s, 1, OFFSET1);

      memset (array131, 0, sizeof(array131));
      #pragma omp parallel for schedule(affinity, array131[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array131[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array131, CHUNK2, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET1);

      memset (array132, 0, sizeof(array132));
      #pragma omp parallel for schedule(affinity, array132[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array132[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array132, CHUNK2, SIZEBIG, p, SIZEBIG, s, 1, OFFSET2);

      memset (array132, 0, sizeof(array132));
      #pragma omp parallel for schedule(affinity, array132[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array132[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array132, CHUNK2, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET2);

      memset (array133, 0, sizeof(array133));
      #pragma omp parallel for schedule(affinity, array133[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array133[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array133, CHUNK2, SIZEBIG, p, SIZEBIG, s, 1, OFFSET3);

      memset (array133, 0, sizeof(array133));
      #pragma omp parallel for schedule(affinity, array133[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array133[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array133, CHUNK2, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET3);

      memset (array134, 0, sizeof(array134));
      #pragma omp parallel for schedule(affinity, array134[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array134[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array134, CHUNK2, SIZEBIG, p, SIZEBIG, s, 1, OFFSET4);

      memset (array134, 0, sizeof(array134));
      #pragma omp parallel for schedule(affinity, array134[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array134[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array134, CHUNK2, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET4);

      memset (array135, 0, sizeof(array135));
      #pragma omp parallel for schedule(affinity, array135[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array135[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array135, CHUNK2, SIZEBIG, p, SIZEBIG, s, 1, OFFSET5);

      memset (array135, 0, sizeof(array135));
      #pragma omp parallel for schedule(affinity, array135[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array135[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array135, CHUNK2, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET5);

      memset (array136, 0, sizeof(array136));
      #pragma omp parallel for schedule(affinity, array136[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array136[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array136, CHUNK2, SIZEBIG, p, SIZEBIG, s, 1, OFFSET6);

      memset (array136, 0, sizeof(array136));
      #pragma omp parallel for schedule(affinity, array136[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array136[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array136, CHUNK2, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET6);


      memset (array141, 0, sizeof(array141));
      #pragma omp parallel for schedule(affinity, array141[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array141[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array141, CHUNK51, SIZEBIG, p, SIZEBIG, s, 1, OFFSET1);

      memset (array141, 0, sizeof(array141));
      #pragma omp parallel for schedule(affinity, array141[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array141[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array141, CHUNK51, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET1);

      memset (array142, 0, sizeof(array142));
      #pragma omp parallel for schedule(affinity, array142[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array142[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array142, CHUNK51, SIZEBIG, p, SIZEBIG, s, 1, OFFSET2);

      memset (array142, 0, sizeof(array142));
      #pragma omp parallel for schedule(affinity, array142[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array142[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array142, CHUNK51, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET2);

      memset (array143, 0, sizeof(array143));
      #pragma omp parallel for schedule(affinity, array143[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array143[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array143, CHUNK51, SIZEBIG, p, SIZEBIG, s, 1, OFFSET3);

      memset (array143, 0, sizeof(array143));
      #pragma omp parallel for schedule(affinity, array143[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array143[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array143, CHUNK51, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET3);

      memset (array144, 0, sizeof(array144));
      #pragma omp parallel for schedule(affinity, array144[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array144[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array144, CHUNK51, SIZEBIG, p, SIZEBIG, s, 1, OFFSET4);

      memset (array144, 0, sizeof(array144));
      #pragma omp parallel for schedule(affinity, array144[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array144[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array144, CHUNK51, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET4);

      memset (array145, 0, sizeof(array145));
      #pragma omp parallel for schedule(affinity, array145[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array145[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array145, CHUNK51, SIZEBIG, p, SIZEBIG, s, 1, OFFSET5);

      memset (array145, 0, sizeof(array145));
      #pragma omp parallel for schedule(affinity, array145[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array145[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array145, CHUNK51, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET5);

      memset (array146, 0, sizeof(array146));
      #pragma omp parallel for schedule(affinity, array146[i])
      for (i=p; i<SIZEBIG; i+=s) {
	array146[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array146, CHUNK51, SIZEBIG, p, SIZEBIG, s, 1, OFFSET6);

      memset (array146, 0, sizeof(array146));
      #pragma omp parallel for schedule(affinity, array146[i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array146[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array146, CHUNK51, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET6);


      memset (array211, 0, sizeof(array211));
      #pragma omp parallel for schedule(affinity, array211[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array211[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array211, CHUNK1, SIZEBIG, p, SIZEBIG, s, BSIZE, OFFSET1);

      memset (array211, 0, sizeof(array211));
      #pragma omp parallel for schedule(affinity, array211[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array211[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array211, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, BSIZE, OFFSET1);

      memset (array212, 0, sizeof(array212));
      #pragma omp parallel for schedule(affinity, array212[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array212[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array212, CHUNK1, SIZEBIG, p, SIZEBIG, s, BSIZE, OFFSET2);

      memset (array212, 0, sizeof(array212));
      #pragma omp parallel for schedule(affinity, array212[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array212[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array212, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, BSIZE, OFFSET2);

      memset (array213, 0, sizeof(array213));
      #pragma omp parallel for schedule(affinity, array213[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array213[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array213, CHUNK1, SIZEBIG, p, SIZEBIG, s, BSIZE, OFFSET3);

      memset (array213, 0, sizeof(array213));
      #pragma omp parallel for schedule(affinity, array213[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array213[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array213, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, BSIZE, OFFSET3);

      memset (array214, 0, sizeof(array214));
      #pragma omp parallel for schedule(affinity, array214[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array214[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array214, CHUNK1, SIZEBIG, p, SIZEBIG, s, BSIZE, OFFSET4);

      memset (array214, 0, sizeof(array214));
      #pragma omp parallel for schedule(affinity, array214[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array214[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array214, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, BSIZE, OFFSET4);

      memset (array215, 0, sizeof(array215));
      #pragma omp parallel for schedule(affinity, array215[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array215[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array215, CHUNK1, SIZEBIG, p, SIZEBIG, s, BSIZE, OFFSET5);

      memset (array215, 0, sizeof(array215));
      #pragma omp parallel for schedule(affinity, array215[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array215[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array215, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, BSIZE, OFFSET5);

      memset (array216, 0, sizeof(array216));
      #pragma omp parallel for schedule(affinity, array216[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array216[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array216, CHUNK1, SIZEBIG, p, SIZEBIG, s, BSIZE, OFFSET6);

      memset (array216, 0, sizeof(array216));
      #pragma omp parallel for schedule(affinity, array216[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array216[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array216, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, BSIZE, OFFSET6);


      memset (array221, 0, sizeof(array221));
      #pragma omp parallel for schedule(affinity, array221[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array221[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array221, CHUNK1, SIZEBIG, p, SIZEBIG, s, BSIZE, OFFSET1);

      memset (array221, 0, sizeof(array221));
      #pragma omp parallel for schedule(affinity, array221[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array221[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array221, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, BSIZE, OFFSET1);

      memset (array222, 0, sizeof(array222));
      #pragma omp parallel for schedule(affinity, array222[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array222[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array222, CHUNK1, SIZEBIG, p, SIZEBIG, s, BSIZE, OFFSET2);

      memset (array222, 0, sizeof(array222));
      #pragma omp parallel for schedule(affinity, array222[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array222[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array222, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, BSIZE, OFFSET2);

      memset (array223, 0, sizeof(array223));
      #pragma omp parallel for schedule(affinity, array223[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array223[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array223, CHUNK1, SIZEBIG, p, SIZEBIG, s, BSIZE, OFFSET3);

      memset (array223, 0, sizeof(array223));
      #pragma omp parallel for schedule(affinity, array223[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array223[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array223, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, BSIZE, OFFSET3);

      memset (array224, 0, sizeof(array224));
      #pragma omp parallel for schedule(affinity, array224[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array224[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array224, CHUNK1, SIZEBIG, p, SIZEBIG, s, BSIZE, OFFSET4);

      memset (array224, 0, sizeof(array224));
      #pragma omp parallel for schedule(affinity, array224[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array224[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array224, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, BSIZE, OFFSET4);

      memset (array225, 0, sizeof(array225));
      #pragma omp parallel for schedule(affinity, array225[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array225[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array225, CHUNK1, SIZEBIG, p, SIZEBIG, s, BSIZE, OFFSET5);

      memset (array225, 0, sizeof(array225));
      #pragma omp parallel for schedule(affinity, array225[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array225[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array225, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, BSIZE, OFFSET5);

      memset (array226, 0, sizeof(array226));
      #pragma omp parallel for schedule(affinity, array226[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array226[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array226, CHUNK1, SIZEBIG, p, SIZEBIG, s, BSIZE, OFFSET6);

      memset (array226, 0, sizeof(array226));
      #pragma omp parallel for schedule(affinity, array226[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array226[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array226, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, BSIZE, OFFSET6);


      memset (array231, 0, sizeof(array231));
      #pragma omp parallel for schedule(affinity, array231[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array231[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array231, CHUNK2, SIZEBIG, p, SIZEBIG, s, BSIZE, OFFSET1);

      memset (array231, 0, sizeof(array231));
      #pragma omp parallel for schedule(affinity, array231[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array231[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array231, CHUNK2, SIZEBIG, 0, SIZEBIG-p, s, BSIZE, OFFSET1);

      memset (array232, 0, sizeof(array232));
      #pragma omp parallel for schedule(affinity, array232[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array232[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array232, CHUNK2, SIZEBIG, p, SIZEBIG, s, BSIZE, OFFSET2);

      memset (array232, 0, sizeof(array232));
      #pragma omp parallel for schedule(affinity, array232[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array232[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array232, CHUNK2, SIZEBIG, 0, SIZEBIG-p, s, BSIZE, OFFSET2);

      memset (array233, 0, sizeof(array233));
      #pragma omp parallel for schedule(affinity, array233[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array233[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array233, CHUNK2, SIZEBIG, p, SIZEBIG, s, BSIZE, OFFSET3);

      memset (array233, 0, sizeof(array233));
      #pragma omp parallel for schedule(affinity, array233[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array233[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array233, CHUNK2, SIZEBIG, 0, SIZEBIG-p, s, BSIZE, OFFSET3);

      memset (array234, 0, sizeof(array234));
      #pragma omp parallel for schedule(affinity, array234[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array234[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array234, CHUNK2, SIZEBIG, p, SIZEBIG, s, BSIZE, OFFSET4);

      memset (array234, 0, sizeof(array234));
      #pragma omp parallel for schedule(affinity, array234[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array234[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array234, CHUNK2, SIZEBIG, 0, SIZEBIG-p, s, BSIZE, OFFSET4);

      memset (array235, 0, sizeof(array235));
      #pragma omp parallel for schedule(affinity, array235[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array235[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array235, CHUNK2, SIZEBIG, p, SIZEBIG, s, BSIZE, OFFSET5);

      memset (array235, 0, sizeof(array235));
      #pragma omp parallel for schedule(affinity, array235[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array235[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array235, CHUNK2, SIZEBIG, 0, SIZEBIG-p, s, BSIZE, OFFSET5);

      memset (array236, 0, sizeof(array236));
      #pragma omp parallel for schedule(affinity, array236[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array236[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array236, CHUNK2, SIZEBIG, p, SIZEBIG, s, BSIZE, OFFSET6);

      memset (array236, 0, sizeof(array236));
      #pragma omp parallel for schedule(affinity, array236[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array236[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array236, CHUNK2, SIZEBIG, 0, SIZEBIG-p, s, BSIZE, OFFSET6);


      memset (array241, 0, sizeof(array241));
      #pragma omp parallel for schedule(affinity, array241[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array241[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array241, CHUNK51, SIZEBIG, p, SIZEBIG, s, BSIZE, OFFSET1);

      memset (array241, 0, sizeof(array241));
      #pragma omp parallel for schedule(affinity, array241[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array241[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array241, CHUNK51, SIZEBIG, 0, SIZEBIG-p, s, BSIZE, OFFSET1);

      memset (array242, 0, sizeof(array242));
      #pragma omp parallel for schedule(affinity, array242[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array242[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array242, CHUNK51, SIZEBIG, p, SIZEBIG, s, BSIZE, OFFSET2);

      memset (array242, 0, sizeof(array242));
      #pragma omp parallel for schedule(affinity, array242[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array242[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array242, CHUNK51, SIZEBIG, 0, SIZEBIG-p, s, BSIZE, OFFSET2);

      memset (array243, 0, sizeof(array243));
      #pragma omp parallel for schedule(affinity, array243[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array243[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array243, CHUNK51, SIZEBIG, p, SIZEBIG, s, BSIZE, OFFSET3);

      memset (array243, 0, sizeof(array243));
      #pragma omp parallel for schedule(affinity, array243[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array243[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array243, CHUNK51, SIZEBIG, 0, SIZEBIG-p, s, BSIZE, OFFSET3);

      memset (array244, 0, sizeof(array244));
      #pragma omp parallel for schedule(affinity, array244[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array244[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array244, CHUNK51, SIZEBIG, p, SIZEBIG, s, BSIZE, OFFSET4);

      memset (array244, 0, sizeof(array244));
      #pragma omp parallel for schedule(affinity, array244[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array244[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array244, CHUNK51, SIZEBIG, 0, SIZEBIG-p, s, BSIZE, OFFSET4);

      memset (array245, 0, sizeof(array245));
      #pragma omp parallel for schedule(affinity, array245[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array245[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array245, CHUNK51, SIZEBIG, p, SIZEBIG, s, BSIZE, OFFSET5);

      memset (array245, 0, sizeof(array245));
      #pragma omp parallel for schedule(affinity, array245[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array245[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array245, CHUNK51, SIZEBIG, 0, SIZEBIG-p, s, BSIZE, OFFSET5);

      memset (array246, 0, sizeof(array246));
      #pragma omp parallel for schedule(affinity, array246[i][*])
      for (i=p; i<SIZEBIG; i+=s) {
	array246[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array246, CHUNK51, SIZEBIG, p, SIZEBIG, s, BSIZE, OFFSET6);

      memset (array246, 0, sizeof(array246));
      #pragma omp parallel for schedule(affinity, array246[i][*])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array246[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array246, CHUNK51, SIZEBIG, 0, SIZEBIG-p, s, BSIZE, OFFSET6);

      memset (array311, 0, sizeof(array311));
      #pragma omp parallel for schedule(affinity, array311[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array311[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array311, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1, OFFSET1);

      memset (array311, 0, sizeof(array311));
      #pragma omp parallel for schedule(affinity, array311[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array311[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array311, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET1);

      memset (array312, 0, sizeof(array312));
      #pragma omp parallel for schedule(affinity, array312[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array312[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array312, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1, OFFSET2);

      memset (array312, 0, sizeof(array312));
      #pragma omp parallel for schedule(affinity, array312[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array312[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array312, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET2);

      memset (array313, 0, sizeof(array313));
      #pragma omp parallel for schedule(affinity, array313[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array313[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array313, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1, OFFSET3);

      memset (array313, 0, sizeof(array313));
      #pragma omp parallel for schedule(affinity, array313[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array313[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array313, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET3);

      memset (array314, 0, sizeof(array314));
      #pragma omp parallel for schedule(affinity, array314[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array314[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array314, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1, OFFSET4);

      memset (array314, 0, sizeof(array314));
      #pragma omp parallel for schedule(affinity, array314[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array314[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array314, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET4);

      memset (array315, 0, sizeof(array315));
      #pragma omp parallel for schedule(affinity, array315[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array315[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array315, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1, OFFSET5);

      memset (array315, 0, sizeof(array315));
      #pragma omp parallel for schedule(affinity, array315[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array315[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array315, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET5);

      memset (array316, 0, sizeof(array316));
      #pragma omp parallel for schedule(affinity, array316[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array316[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array316, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1, OFFSET6);

      memset (array316, 0, sizeof(array316));
      #pragma omp parallel for schedule(affinity, array316[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array316[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array316, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET6);


      memset (array321, 0, sizeof(array321));
      #pragma omp parallel for schedule(affinity, array321[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array321[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array321, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1, OFFSET1);

      memset (array321, 0, sizeof(array321));
      #pragma omp parallel for schedule(affinity, array321[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array321[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array321, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET1);

      memset (array322, 0, sizeof(array322));
      #pragma omp parallel for schedule(affinity, array322[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array322[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array322, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1, OFFSET2);

      memset (array322, 0, sizeof(array322));
      #pragma omp parallel for schedule(affinity, array322[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array322[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array322, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET2);

      memset (array323, 0, sizeof(array323));
      #pragma omp parallel for schedule(affinity, array323[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array323[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array323, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1, OFFSET3);

      memset (array323, 0, sizeof(array323));
      #pragma omp parallel for schedule(affinity, array323[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array323[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array323, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET3);

      memset (array324, 0, sizeof(array324));
      #pragma omp parallel for schedule(affinity, array324[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array324[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array324, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1, OFFSET4);

      memset (array324, 0, sizeof(array324));
      #pragma omp parallel for schedule(affinity, array324[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array324[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array324, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET4);

      memset (array325, 0, sizeof(array325));
      #pragma omp parallel for schedule(affinity, array325[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array325[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array325, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1, OFFSET5);

      memset (array325, 0, sizeof(array325));
      #pragma omp parallel for schedule(affinity, array325[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array325[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array325, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET5);

      memset (array326, 0, sizeof(array326));
      #pragma omp parallel for schedule(affinity, array326[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array326[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array326, CHUNK1, SIZEBIG, p, SIZEBIG, s, 1, OFFSET6);

      memset (array326, 0, sizeof(array326));
      #pragma omp parallel for schedule(affinity, array326[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array326[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array326, CHUNK1, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET6);


      memset (array331, 0, sizeof(array331));
      #pragma omp parallel for schedule(affinity, array331[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array331[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array331, CHUNK2, SIZEBIG, p, SIZEBIG, s, 1, OFFSET1);

      memset (array331, 0, sizeof(array331));
      #pragma omp parallel for schedule(affinity, array331[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array331[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array331, CHUNK2, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET1);

      memset (array332, 0, sizeof(array332));
      #pragma omp parallel for schedule(affinity, array332[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array332[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array332, CHUNK2, SIZEBIG, p, SIZEBIG, s, 1, OFFSET2);

      memset (array332, 0, sizeof(array332));
      #pragma omp parallel for schedule(affinity, array332[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array332[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array332, CHUNK2, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET2);

      memset (array333, 0, sizeof(array333));
      #pragma omp parallel for schedule(affinity, array333[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array333[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array333, CHUNK2, SIZEBIG, p, SIZEBIG, s, 1, OFFSET3);

      memset (array333, 0, sizeof(array333));
      #pragma omp parallel for schedule(affinity, array333[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array333[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array333, CHUNK2, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET3);

      memset (array334, 0, sizeof(array334));
      #pragma omp parallel for schedule(affinity, array334[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array334[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array334, CHUNK2, SIZEBIG, p, SIZEBIG, s, 1, OFFSET4);

      memset (array334, 0, sizeof(array334));
      #pragma omp parallel for schedule(affinity, array334[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array334[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array334, CHUNK2, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET4);

      memset (array335, 0, sizeof(array335));
      #pragma omp parallel for schedule(affinity, array335[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array335[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array335, CHUNK2, SIZEBIG, p, SIZEBIG, s, 1, OFFSET5);

      memset (array335, 0, sizeof(array335));
      #pragma omp parallel for schedule(affinity, array335[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array335[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array335, CHUNK2, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET5);

      memset (array336, 0, sizeof(array336));
      #pragma omp parallel for schedule(affinity, array336[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array336[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array336, CHUNK2, SIZEBIG, p, SIZEBIG, s, 1, OFFSET6);

      memset (array336, 0, sizeof(array336));
      #pragma omp parallel for schedule(affinity, array336[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array336[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array336, CHUNK2, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET6);


      memset (array341, 0, sizeof(array341));
      #pragma omp parallel for schedule(affinity, array341[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array341[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array341, CHUNK51, SIZEBIG, p, SIZEBIG, s, 1, OFFSET1);

      memset (array341, 0, sizeof(array341));
      #pragma omp parallel for schedule(affinity, array341[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array341[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array341, CHUNK51, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET1);

      memset (array342, 0, sizeof(array342));
      #pragma omp parallel for schedule(affinity, array342[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array342[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array342, CHUNK51, SIZEBIG, p, SIZEBIG, s, 1, OFFSET2);

      memset (array342, 0, sizeof(array342));
      #pragma omp parallel for schedule(affinity, array342[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array342[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array342, CHUNK51, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET2);

      memset (array343, 0, sizeof(array343));
      #pragma omp parallel for schedule(affinity, array343[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array343[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array343, CHUNK51, SIZEBIG, p, SIZEBIG, s, 1, OFFSET3);

      memset (array343, 0, sizeof(array343));
      #pragma omp parallel for schedule(affinity, array343[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array343[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array343, CHUNK51, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET3);

      memset (array344, 0, sizeof(array344));
      #pragma omp parallel for schedule(affinity, array344[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array344[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array344, CHUNK51, SIZEBIG, p, SIZEBIG, s, 1, OFFSET4);

      memset (array344, 0, sizeof(array344));
      #pragma omp parallel for schedule(affinity, array344[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array344[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array344, CHUNK51, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET4);

      memset (array345, 0, sizeof(array345));
      #pragma omp parallel for schedule(affinity, array345[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array345[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array345, CHUNK51, SIZEBIG, p, SIZEBIG, s, 1, OFFSET5);

      memset (array345, 0, sizeof(array345));
      #pragma omp parallel for schedule(affinity, array345[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array345[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array345, CHUNK51, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET5);

      memset (array346, 0, sizeof(array346));
      #pragma omp parallel for schedule(affinity, array346[*][i])
      for (i=p; i<SIZEBIG; i+=s) {
	array346[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array346, CHUNK51, SIZEBIG, p, SIZEBIG, s, 1, OFFSET6);

      memset (array346, 0, sizeof(array346));
      #pragma omp parallel for schedule(affinity, array346[*][i])
      for (i=0; i<SIZEBIG-p; i+=s) {
	array346[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array346, CHUNK51, SIZEBIG, 0, SIZEBIG-p, s, 1, OFFSET6);

    }
  }


  for (p=0; p<SIZESMALL; p++) {
    for (s=1; s<SIZESMALL; s++) {
      memset (array411, 0, sizeof(array411));
      #pragma omp parallel for schedule(affinity, array411[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array411[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array411, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1, OFFSET1);

      memset (array411, 0, sizeof(array411));
      #pragma omp parallel for schedule(affinity, array411[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array411[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array411, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET1);

      memset (array412, 0, sizeof(array412));
      #pragma omp parallel for schedule(affinity, array412[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array412[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array412, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1, OFFSET2);

      memset (array412, 0, sizeof(array412));
      #pragma omp parallel for schedule(affinity, array412[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array412[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array412, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET2);

      memset (array413, 0, sizeof(array413));
      #pragma omp parallel for schedule(affinity, array413[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array413[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array413, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1, OFFSET3);

      memset (array413, 0, sizeof(array413));
      #pragma omp parallel for schedule(affinity, array413[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array413[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array413, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET3);

      memset (array414, 0, sizeof(array414));
      #pragma omp parallel for schedule(affinity, array414[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array414[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array414, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1, OFFSET4);

      memset (array414, 0, sizeof(array414));
      #pragma omp parallel for schedule(affinity, array414[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array414[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array414, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET4);

      memset (array415, 0, sizeof(array415));
      #pragma omp parallel for schedule(affinity, array415[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array415[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array415, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1, OFFSET5);

      memset (array415, 0, sizeof(array415));
      #pragma omp parallel for schedule(affinity, array415[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array415[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array415, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET5);

      memset (array416, 0, sizeof(array416));
      #pragma omp parallel for schedule(affinity, array416[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array416[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array416, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1, OFFSET6);

      memset (array416, 0, sizeof(array416));
      #pragma omp parallel for schedule(affinity, array416[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array416[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array416, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET6);


      memset (array421, 0, sizeof(array421));
      #pragma omp parallel for schedule(affinity, array421[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array421[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array421, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1, OFFSET1);

      memset (array421, 0, sizeof(array421));
      #pragma omp parallel for schedule(affinity, array421[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array421[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array421, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET1);

      memset (array422, 0, sizeof(array422));
      #pragma omp parallel for schedule(affinity, array422[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array422[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array422, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1, OFFSET2);

      memset (array422, 0, sizeof(array422));
      #pragma omp parallel for schedule(affinity, array422[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array422[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array422, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET2);

      memset (array423, 0, sizeof(array423));
      #pragma omp parallel for schedule(affinity, array423[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array423[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array423, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1, OFFSET3);

      memset (array423, 0, sizeof(array423));
      #pragma omp parallel for schedule(affinity, array423[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array423[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array423, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET3);

      memset (array424, 0, sizeof(array424));
      #pragma omp parallel for schedule(affinity, array424[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array424[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array424, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1, OFFSET4);

      memset (array424, 0, sizeof(array424));
      #pragma omp parallel for schedule(affinity, array424[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array424[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array424, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET4);

      memset (array425, 0, sizeof(array425));
      #pragma omp parallel for schedule(affinity, array425[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array425[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array425, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1, OFFSET5);

      memset (array425, 0, sizeof(array425));
      #pragma omp parallel for schedule(affinity, array425[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array425[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array425, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET5);

      memset (array426, 0, sizeof(array426));
      #pragma omp parallel for schedule(affinity, array426[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array426[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array426, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1, OFFSET6);

      memset (array426, 0, sizeof(array426));
      #pragma omp parallel for schedule(affinity, array426[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array426[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array426, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET6);


      memset (array431, 0, sizeof(array431));
      #pragma omp parallel for schedule(affinity, array431[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array431[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array431, CHUNK2, SIZESMALL, p, SIZESMALL, s, 1, OFFSET1);

      memset (array431, 0, sizeof(array431));
      #pragma omp parallel for schedule(affinity, array431[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array431[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array431, CHUNK2, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET1);

      memset (array432, 0, sizeof(array432));
      #pragma omp parallel for schedule(affinity, array432[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array432[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array432, CHUNK2, SIZESMALL, p, SIZESMALL, s, 1, OFFSET2);

      memset (array432, 0, sizeof(array432));
      #pragma omp parallel for schedule(affinity, array432[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array432[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array432, CHUNK2, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET2);

      memset (array433, 0, sizeof(array433));
      #pragma omp parallel for schedule(affinity, array433[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array433[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array433, CHUNK2, SIZESMALL, p, SIZESMALL, s, 1, OFFSET3);

      memset (array433, 0, sizeof(array433));
      #pragma omp parallel for schedule(affinity, array433[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array433[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array433, CHUNK2, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET3);

      memset (array434, 0, sizeof(array434));
      #pragma omp parallel for schedule(affinity, array434[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array434[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array434, CHUNK2, SIZESMALL, p, SIZESMALL, s, 1, OFFSET4);

      memset (array434, 0, sizeof(array434));
      #pragma omp parallel for schedule(affinity, array434[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array434[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array434, CHUNK2, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET4);

      memset (array435, 0, sizeof(array435));
      #pragma omp parallel for schedule(affinity, array435[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array435[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array435, CHUNK2, SIZESMALL, p, SIZESMALL, s, 1, OFFSET5);

      memset (array435, 0, sizeof(array435));
      #pragma omp parallel for schedule(affinity, array435[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array435[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array435, CHUNK2, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET5);

      memset (array436, 0, sizeof(array436));
      #pragma omp parallel for schedule(affinity, array436[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array436[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array436, CHUNK2, SIZESMALL, p, SIZESMALL, s, 1, OFFSET6);

      memset (array436, 0, sizeof(array436));
      #pragma omp parallel for schedule(affinity, array436[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array436[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array436, CHUNK2, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET6);


      memset (array441, 0, sizeof(array441));
      #pragma omp parallel for schedule(affinity, array441[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array441[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array441, CHUNK51, SIZESMALL, p, SIZESMALL, s, 1, OFFSET1);

      memset (array441, 0, sizeof(array441));
      #pragma omp parallel for schedule(affinity, array441[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array441[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array441, CHUNK51, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET1);

      memset (array442, 0, sizeof(array442));
      #pragma omp parallel for schedule(affinity, array442[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array442[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array442, CHUNK51, SIZESMALL, p, SIZESMALL, s, 1, OFFSET2);

      memset (array442, 0, sizeof(array442));
      #pragma omp parallel for schedule(affinity, array442[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array442[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array442, CHUNK51, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET2);

      memset (array443, 0, sizeof(array443));
      #pragma omp parallel for schedule(affinity, array443[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array443[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array443, CHUNK51, SIZESMALL, p, SIZESMALL, s, 1, OFFSET3);

      memset (array443, 0, sizeof(array443));
      #pragma omp parallel for schedule(affinity, array443[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array443[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array443, CHUNK51, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET3);

      memset (array444, 0, sizeof(array444));
      #pragma omp parallel for schedule(affinity, array444[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array444[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array444, CHUNK51, SIZESMALL, p, SIZESMALL, s, 1, OFFSET4);

      memset (array444, 0, sizeof(array444));
      #pragma omp parallel for schedule(affinity, array444[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array444[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array444, CHUNK51, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET4);

      memset (array445, 0, sizeof(array445));
      #pragma omp parallel for schedule(affinity, array445[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array445[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array445, CHUNK51, SIZESMALL, p, SIZESMALL, s, 1, OFFSET5);

      memset (array445, 0, sizeof(array445));
      #pragma omp parallel for schedule(affinity, array445[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array445[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array445, CHUNK51, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET5);

      memset (array446, 0, sizeof(array446));
      #pragma omp parallel for schedule(affinity, array446[i])
      for (i=p; i<SIZESMALL; i+=s) {
	array446[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array446, CHUNK51, SIZESMALL, p, SIZESMALL, s, 1, OFFSET6);

      memset (array446, 0, sizeof(array446));
      #pragma omp parallel for schedule(affinity, array446[i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array446[i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array446, CHUNK51, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET6);


      memset (array511, 0, sizeof(array511));
      #pragma omp parallel for schedule(affinity, array511[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array511[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array511, CHUNK1, SIZESMALL, p, SIZESMALL, s, BSIZE, OFFSET1);

      memset (array511, 0, sizeof(array511));
      #pragma omp parallel for schedule(affinity, array511[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array511[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array511, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, BSIZE, OFFSET1);

      memset (array512, 0, sizeof(array512));
      #pragma omp parallel for schedule(affinity, array512[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array512[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array512, CHUNK1, SIZESMALL, p, SIZESMALL, s, BSIZE, OFFSET2);

      memset (array512, 0, sizeof(array512));
      #pragma omp parallel for schedule(affinity, array512[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array512[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array512, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, BSIZE, OFFSET2);

      memset (array513, 0, sizeof(array513));
      #pragma omp parallel for schedule(affinity, array513[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array513[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array513, CHUNK1, SIZESMALL, p, SIZESMALL, s, BSIZE, OFFSET3);

      memset (array513, 0, sizeof(array513));
      #pragma omp parallel for schedule(affinity, array513[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array513[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array513, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, BSIZE, OFFSET3);

      memset (array514, 0, sizeof(array514));
      #pragma omp parallel for schedule(affinity, array514[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array514[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array514, CHUNK1, SIZESMALL, p, SIZESMALL, s, BSIZE, OFFSET4);

      memset (array514, 0, sizeof(array514));
      #pragma omp parallel for schedule(affinity, array514[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array514[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array514, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, BSIZE, OFFSET4);

      memset (array515, 0, sizeof(array515));
      #pragma omp parallel for schedule(affinity, array515[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array515[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array515, CHUNK1, SIZESMALL, p, SIZESMALL, s, BSIZE, OFFSET5);

      memset (array515, 0, sizeof(array515));
      #pragma omp parallel for schedule(affinity, array515[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array515[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array515, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, BSIZE, OFFSET5);

      memset (array516, 0, sizeof(array516));
      #pragma omp parallel for schedule(affinity, array516[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array516[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array516, CHUNK1, SIZESMALL, p, SIZESMALL, s, BSIZE, OFFSET6);

      memset (array516, 0, sizeof(array516));
      #pragma omp parallel for schedule(affinity, array516[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array516[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array516, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, BSIZE, OFFSET6);


      memset (array521, 0, sizeof(array521));
      #pragma omp parallel for schedule(affinity, array521[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array521[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array521, CHUNK1, SIZESMALL, p, SIZESMALL, s, BSIZE, OFFSET1);

      memset (array521, 0, sizeof(array521));
      #pragma omp parallel for schedule(affinity, array521[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array521[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array521, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, BSIZE, OFFSET1);

      memset (array522, 0, sizeof(array522));
      #pragma omp parallel for schedule(affinity, array522[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array522[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array522, CHUNK1, SIZESMALL, p, SIZESMALL, s, BSIZE, OFFSET2);

      memset (array522, 0, sizeof(array522));
      #pragma omp parallel for schedule(affinity, array522[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array522[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array522, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, BSIZE, OFFSET2);

      memset (array523, 0, sizeof(array523));
      #pragma omp parallel for schedule(affinity, array523[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array523[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array523, CHUNK1, SIZESMALL, p, SIZESMALL, s, BSIZE, OFFSET3);

      memset (array523, 0, sizeof(array523));
      #pragma omp parallel for schedule(affinity, array523[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array523[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array523, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, BSIZE, OFFSET3);

      memset (array524, 0, sizeof(array524));
      #pragma omp parallel for schedule(affinity, array524[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array524[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array524, CHUNK1, SIZESMALL, p, SIZESMALL, s, BSIZE, OFFSET4);

      memset (array524, 0, sizeof(array524));
      #pragma omp parallel for schedule(affinity, array524[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array524[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array524, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, BSIZE, OFFSET4);

      memset (array525, 0, sizeof(array525));
      #pragma omp parallel for schedule(affinity, array525[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array525[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array525, CHUNK1, SIZESMALL, p, SIZESMALL, s, BSIZE, OFFSET5);

      memset (array525, 0, sizeof(array525));
      #pragma omp parallel for schedule(affinity, array525[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array525[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array525, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, BSIZE, OFFSET5);

      memset (array526, 0, sizeof(array526));
      #pragma omp parallel for schedule(affinity, array526[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array526[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array526, CHUNK1, SIZESMALL, p, SIZESMALL, s, BSIZE, OFFSET6);

      memset (array526, 0, sizeof(array526));
      #pragma omp parallel for schedule(affinity, array526[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array526[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array526, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, BSIZE, OFFSET6);


      memset (array531, 0, sizeof(array531));
      #pragma omp parallel for schedule(affinity, array531[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array531[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array531, CHUNK2, SIZESMALL, p, SIZESMALL, s, BSIZE, OFFSET1);

      memset (array531, 0, sizeof(array531));
      #pragma omp parallel for schedule(affinity, array531[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array531[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array531, CHUNK2, SIZESMALL, 0, SIZESMALL-p, s, BSIZE, OFFSET1);

      memset (array532, 0, sizeof(array532));
      #pragma omp parallel for schedule(affinity, array532[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array532[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array532, CHUNK2, SIZESMALL, p, SIZESMALL, s, BSIZE, OFFSET2);

      memset (array532, 0, sizeof(array532));
      #pragma omp parallel for schedule(affinity, array532[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array532[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array532, CHUNK2, SIZESMALL, 0, SIZESMALL-p, s, BSIZE, OFFSET2);

      memset (array533, 0, sizeof(array533));
      #pragma omp parallel for schedule(affinity, array533[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array533[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array533, CHUNK2, SIZESMALL, p, SIZESMALL, s, BSIZE, OFFSET3);

      memset (array533, 0, sizeof(array533));
      #pragma omp parallel for schedule(affinity, array533[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array533[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array533, CHUNK2, SIZESMALL, 0, SIZESMALL-p, s, BSIZE, OFFSET3);

      memset (array534, 0, sizeof(array534));
      #pragma omp parallel for schedule(affinity, array534[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array534[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array534, CHUNK2, SIZESMALL, p, SIZESMALL, s, BSIZE, OFFSET4);

      memset (array534, 0, sizeof(array534));
      #pragma omp parallel for schedule(affinity, array534[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array534[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array534, CHUNK2, SIZESMALL, 0, SIZESMALL-p, s, BSIZE, OFFSET4);

      memset (array535, 0, sizeof(array535));
      #pragma omp parallel for schedule(affinity, array535[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array535[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array535, CHUNK2, SIZESMALL, p, SIZESMALL, s, BSIZE, OFFSET5);

      memset (array535, 0, sizeof(array535));
      #pragma omp parallel for schedule(affinity, array535[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array535[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array535, CHUNK2, SIZESMALL, 0, SIZESMALL-p, s, BSIZE, OFFSET5);

      memset (array536, 0, sizeof(array536));
      #pragma omp parallel for schedule(affinity, array536[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array536[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array536, CHUNK2, SIZESMALL, p, SIZESMALL, s, BSIZE, OFFSET6);

      memset (array536, 0, sizeof(array536));
      #pragma omp parallel for schedule(affinity, array536[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array536[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array536, CHUNK2, SIZESMALL, 0, SIZESMALL-p, s, BSIZE, OFFSET6);


      memset (array541, 0, sizeof(array541));
      #pragma omp parallel for schedule(affinity, array541[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array541[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array541, CHUNK51, SIZESMALL, p, SIZESMALL, s, BSIZE, OFFSET1);

      memset (array541, 0, sizeof(array541));
      #pragma omp parallel for schedule(affinity, array541[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array541[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array541, CHUNK51, SIZESMALL, 0, SIZESMALL-p, s, BSIZE, OFFSET1);

      memset (array542, 0, sizeof(array542));
      #pragma omp parallel for schedule(affinity, array542[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array542[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array542, CHUNK51, SIZESMALL, p, SIZESMALL, s, BSIZE, OFFSET2);

      memset (array542, 0, sizeof(array542));
      #pragma omp parallel for schedule(affinity, array542[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array542[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array542, CHUNK51, SIZESMALL, 0, SIZESMALL-p, s, BSIZE, OFFSET2);

      memset (array543, 0, sizeof(array543));
      #pragma omp parallel for schedule(affinity, array543[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array543[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array543, CHUNK51, SIZESMALL, p, SIZESMALL, s, BSIZE, OFFSET3);

      memset (array543, 0, sizeof(array543));
      #pragma omp parallel for schedule(affinity, array543[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array543[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array543, CHUNK51, SIZESMALL, 0, SIZESMALL-p, s, BSIZE, OFFSET3);

      memset (array544, 0, sizeof(array544));
      #pragma omp parallel for schedule(affinity, array544[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array544[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array544, CHUNK51, SIZESMALL, p, SIZESMALL, s, BSIZE, OFFSET4);

      memset (array544, 0, sizeof(array544));
      #pragma omp parallel for schedule(affinity, array544[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array544[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array544, CHUNK51, SIZESMALL, 0, SIZESMALL-p, s, BSIZE, OFFSET4);

      memset (array545, 0, sizeof(array545));
      #pragma omp parallel for schedule(affinity, array545[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array545[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array545, CHUNK51, SIZESMALL, p, SIZESMALL, s, BSIZE, OFFSET5);

      memset (array545, 0, sizeof(array545));
      #pragma omp parallel for schedule(affinity, array545[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array545[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array545, CHUNK51, SIZESMALL, 0, SIZESMALL-p, s, BSIZE, OFFSET5);

      memset (array546, 0, sizeof(array546));
      #pragma omp parallel for schedule(affinity, array546[i][*])
      for (i=p; i<SIZESMALL; i+=s) {
	array546[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array546, CHUNK51, SIZESMALL, p, SIZESMALL, s, BSIZE, OFFSET6);

      memset (array546, 0, sizeof(array546));
      #pragma omp parallel for schedule(affinity, array546[i][*])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array546[i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array546, CHUNK51, SIZESMALL, 0, SIZESMALL-p, s, BSIZE, OFFSET6);

      memset (array611, 0, sizeof(array611));
      #pragma omp parallel for schedule(affinity, array611[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array611[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array611, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1, OFFSET1);

      memset (array611, 0, sizeof(array611));
      #pragma omp parallel for schedule(affinity, array611[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array611[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array611, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET1);

      memset (array612, 0, sizeof(array612));
      #pragma omp parallel for schedule(affinity, array612[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array612[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array612, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1, OFFSET2);

      memset (array612, 0, sizeof(array612));
      #pragma omp parallel for schedule(affinity, array612[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array612[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array612, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET2);

      memset (array613, 0, sizeof(array613));
      #pragma omp parallel for schedule(affinity, array613[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array613[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array613, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1, OFFSET3);

      memset (array613, 0, sizeof(array613));
      #pragma omp parallel for schedule(affinity, array613[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array613[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array613, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET3);

      memset (array614, 0, sizeof(array614));
      #pragma omp parallel for schedule(affinity, array614[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array614[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array614, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1, OFFSET4);

      memset (array614, 0, sizeof(array614));
      #pragma omp parallel for schedule(affinity, array614[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array614[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array614, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET4);

      memset (array615, 0, sizeof(array615));
      #pragma omp parallel for schedule(affinity, array615[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array615[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array615, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1, OFFSET5);

      memset (array615, 0, sizeof(array615));
      #pragma omp parallel for schedule(affinity, array615[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array615[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array615, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET5);

      memset (array616, 0, sizeof(array616));
      #pragma omp parallel for schedule(affinity, array616[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array616[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array616, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1, OFFSET6);

      memset (array616, 0, sizeof(array616));
      #pragma omp parallel for schedule(affinity, array616[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array616[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array616, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET6);


      memset (array621, 0, sizeof(array621));
      #pragma omp parallel for schedule(affinity, array621[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array621[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array621, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1, OFFSET1);

      memset (array621, 0, sizeof(array621));
      #pragma omp parallel for schedule(affinity, array621[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array621[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array621, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET1);

      memset (array622, 0, sizeof(array622));
      #pragma omp parallel for schedule(affinity, array622[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array622[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array622, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1, OFFSET2);

      memset (array622, 0, sizeof(array622));
      #pragma omp parallel for schedule(affinity, array622[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array622[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array622, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET2);

      memset (array623, 0, sizeof(array623));
      #pragma omp parallel for schedule(affinity, array623[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array623[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array623, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1, OFFSET3);

      memset (array623, 0, sizeof(array623));
      #pragma omp parallel for schedule(affinity, array623[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array623[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array623, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET3);

      memset (array624, 0, sizeof(array624));
      #pragma omp parallel for schedule(affinity, array624[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array624[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array624, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1, OFFSET4);

      memset (array624, 0, sizeof(array624));
      #pragma omp parallel for schedule(affinity, array624[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array624[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array624, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET4);

      memset (array625, 0, sizeof(array625));
      #pragma omp parallel for schedule(affinity, array625[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array625[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array625, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1, OFFSET5);

      memset (array625, 0, sizeof(array625));
      #pragma omp parallel for schedule(affinity, array625[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array625[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array625, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET5);

      memset (array626, 0, sizeof(array626));
      #pragma omp parallel for schedule(affinity, array626[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array626[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array626, CHUNK1, SIZESMALL, p, SIZESMALL, s, 1, OFFSET6);

      memset (array626, 0, sizeof(array626));
      #pragma omp parallel for schedule(affinity, array626[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array626[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array626, CHUNK1, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET6);


      memset (array631, 0, sizeof(array631));
      #pragma omp parallel for schedule(affinity, array631[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array631[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array631, CHUNK2, SIZESMALL, p, SIZESMALL, s, 1, OFFSET1);

      memset (array631, 0, sizeof(array631));
      #pragma omp parallel for schedule(affinity, array631[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array631[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array631, CHUNK2, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET1);

      memset (array632, 0, sizeof(array632));
      #pragma omp parallel for schedule(affinity, array632[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array632[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array632, CHUNK2, SIZESMALL, p, SIZESMALL, s, 1, OFFSET2);

      memset (array632, 0, sizeof(array632));
      #pragma omp parallel for schedule(affinity, array632[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array632[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array632, CHUNK2, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET2);

      memset (array633, 0, sizeof(array633));
      #pragma omp parallel for schedule(affinity, array633[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array633[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array633, CHUNK2, SIZESMALL, p, SIZESMALL, s, 1, OFFSET3);

      memset (array633, 0, sizeof(array633));
      #pragma omp parallel for schedule(affinity, array633[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array633[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array633, CHUNK2, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET3);

      memset (array634, 0, sizeof(array634));
      #pragma omp parallel for schedule(affinity, array634[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array634[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array634, CHUNK2, SIZESMALL, p, SIZESMALL, s, 1, OFFSET4);

      memset (array634, 0, sizeof(array634));
      #pragma omp parallel for schedule(affinity, array634[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array634[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array634, CHUNK2, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET4);

      memset (array635, 0, sizeof(array635));
      #pragma omp parallel for schedule(affinity, array635[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array635[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array635, CHUNK2, SIZESMALL, p, SIZESMALL, s, 1, OFFSET5);

      memset (array635, 0, sizeof(array635));
      #pragma omp parallel for schedule(affinity, array635[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array635[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array635, CHUNK2, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET5);

      memset (array636, 0, sizeof(array636));
      #pragma omp parallel for schedule(affinity, array636[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array636[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array636, CHUNK2, SIZESMALL, p, SIZESMALL, s, 1, OFFSET6);

      memset (array636, 0, sizeof(array636));
      #pragma omp parallel for schedule(affinity, array636[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array636[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array636, CHUNK2, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET6);


      memset (array641, 0, sizeof(array641));
      #pragma omp parallel for schedule(affinity, array641[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array641[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array641, CHUNK51, SIZESMALL, p, SIZESMALL, s, 1, OFFSET1);

      memset (array641, 0, sizeof(array641));
      #pragma omp parallel for schedule(affinity, array641[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array641[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array641, CHUNK51, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET1);

      memset (array642, 0, sizeof(array642));
      #pragma omp parallel for schedule(affinity, array642[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array642[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array642, CHUNK51, SIZESMALL, p, SIZESMALL, s, 1, OFFSET2);

      memset (array642, 0, sizeof(array642));
      #pragma omp parallel for schedule(affinity, array642[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array642[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array642, CHUNK51, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET2);

      memset (array643, 0, sizeof(array643));
      #pragma omp parallel for schedule(affinity, array643[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array643[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array643, CHUNK51, SIZESMALL, p, SIZESMALL, s, 1, OFFSET3);

      memset (array643, 0, sizeof(array643));
      #pragma omp parallel for schedule(affinity, array643[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array643[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array643, CHUNK51, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET3);

      memset (array644, 0, sizeof(array644));
      #pragma omp parallel for schedule(affinity, array644[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array644[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array644, CHUNK51, SIZESMALL, p, SIZESMALL, s, 1, OFFSET4);

      memset (array644, 0, sizeof(array644));
      #pragma omp parallel for schedule(affinity, array644[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array644[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array644, CHUNK51, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET4);

      memset (array645, 0, sizeof(array645));
      #pragma omp parallel for schedule(affinity, array645[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array645[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array645, CHUNK51, SIZESMALL, p, SIZESMALL, s, 1, OFFSET5);

      memset (array645, 0, sizeof(array645));
      #pragma omp parallel for schedule(affinity, array645[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array645[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array645, CHUNK51, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET5);

      memset (array646, 0, sizeof(array646));
      #pragma omp parallel for schedule(affinity, array646[*][i])
      for (i=p; i<SIZESMALL; i+=s) {
	array646[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array646, CHUNK51, SIZESMALL, p, SIZESMALL, s, 1, OFFSET6);

      memset (array646, 0, sizeof(array646));
      #pragma omp parallel for schedule(affinity, array646[*][i])
      for (i=0; i<SIZESMALL-p; i+=s) {
	array646[0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array646, CHUNK51, SIZESMALL, 0, SIZESMALL-p, s, 1, OFFSET6);

    }
  }

  if (errors == 0) {
    printf ("affinity scheduling 037 : SUCCESS\n");
    return 0;
  } else {
    printf ("affinity scheduling 037 : FAILED\n");
    return 1;
  }
}
#endif
