static char rcsid[] = "$Id: afntyschd039.c,v 1.2 2002/04/03 11:51:52 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* 
 * afinity scheduling 039
 * expr mapping  expr mapping ưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


#ifndef __OMNI_SCASH__
main ()
{
  printf ("affinity scheduling is supported at OMNI_SCASH only.\n");
  exit (0);
}
#else


#define SIZE		(2*3*4)


int baseb[SIZE];
int basec[SIZE];

#pragma omni mapping (baseb[block])
#pragma omni mapping (basec[cyclic])

int baseb1[SIZE][SIZE][SIZE];
int basec1[SIZE][SIZE][SIZE];

#pragma omni mapping (baseb1[*][i][*]:baseb[i+1])
#pragma omni mapping (basec1[*][i][*]:basec[i+1])


int array11[SIZE][SIZE][SIZE];
int array12[SIZE][SIZE][SIZE];
int array21[SIZE][SIZE][SIZE];
int array22[SIZE][SIZE][SIZE];
int array31[SIZE][SIZE][SIZE];
int array32[SIZE][SIZE][SIZE];

int array41[SIZE][SIZE][SIZE];
int array42[SIZE][SIZE][SIZE];
int array51[SIZE][SIZE][SIZE];
int array52[SIZE][SIZE][SIZE];
int array61[SIZE][SIZE][SIZE];
int array62[SIZE][SIZE][SIZE];

#pragma omni mapping (array11[i][*][*]:baseb1[*][i+2][*])
#pragma omni mapping (array12[i][*][*]:basec1[*][i+2][*])
#pragma omni mapping (array21[*][i][*]:baseb1[*][i+2][*])
#pragma omni mapping (array22[*][i][*]:basec1[*][i+2][*])
#pragma omni mapping (array31[*][*][i]:baseb1[*][i+2][*])
#pragma omni mapping (array32[*][*][i]:basec1[*][i+2][*])

#pragma omni mapping (array41[i][*][*]:array21[*][i+3][*])
#pragma omni mapping (array42[i][*][*]:array22[*][i+3][*])
#pragma omni mapping (array51[*][i][*]:array21[*][i+3][*])
#pragma omni mapping (array52[*][i][*]:array22[*][i+3][*])
#pragma omni mapping (array61[*][*][i]:array21[*][i+3][*])
#pragma omni mapping (array62[*][*][i]:array22[*][i+3][*])


int errors = 0;
int p, s;


check (int thds, int *array, int chunksz, int size, int start, int end,
       int stride, int offset, int boffset)
{
  int chunk, i, v, next, tmp;

  chunk = chunksz;

  for (i = 0; i < size; i++) {
    if (i < start) {
      if (*(array + offset * i) != 0) {
	errors += 1;
      }

    } else if (i >=end) {
      if (*(array + offset * i) != 0) {
	errors += 1;
      }

    } else {
      tmp = i + boffset;
      while (tmp < 0) {
	tmp += chunk * thds;
      }
      v = (tmp/chunk) % thds + 1;

      if (i == start) {
	if (*(array + offset * i) != v) {
	  errors += 1;
	}
	next = i + stride;
      } else if (i == next) {
	if (*(array + offset * i) != v) {
	  errors += 1;
	}
	next += stride;
      } else {
	if (*(array + offset * i) != 0) {
	  errors += 1;
	}
      }
    }
  }
}


main ()
{
  int	thds, i, chunksz;


  thds = omp_get_max_threads();
  if (thds == 1) {
    printf ("shuld be run this program on multi threads\n");
    exit (0);
  }

  chunksz = (SIZE + thds - 1) / thds;

  for (p=0; p<SIZE; p++) {
    for (s=1; s<SIZE; s++) {
      memset (array11, 0, sizeof(array11));
      #pragma omp parallel for schedule(affinity, array11[i][*][*])
      for (i=p; i<SIZE; i+=s) {
	array11[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array11, chunksz, SIZE, p, SIZE, s, SIZE*SIZE, 3);

      memset (array11, 0, sizeof(array11));
      #pragma omp parallel for schedule(affinity, array11[i][*][*])
      for (i=0; i<SIZE-p; i+=s) {
	array11[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array11, chunksz, SIZE, 0, SIZE-p, s, SIZE*SIZE, 3);

      memset (array12, 0, sizeof(array12));
      #pragma omp parallel for schedule(affinity, array12[i][*][*])
      for (i=p; i<SIZE; i+=s) {
	array12[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array12, 1, SIZE, p, SIZE, s, SIZE*SIZE, 3);

      memset (array12, 0, sizeof(array12));
      #pragma omp parallel for schedule(affinity, array12[i][*][*])
      for (i=0; i<SIZE-p; i+=s) {
	array12[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array12, 1, SIZE, 0, SIZE-p, s, SIZE*SIZE, 3);


      memset (array21, 0, sizeof(array21));
      #pragma omp parallel for schedule(affinity, array21[*][i][*])
      for (i=p; i<SIZE; i+=s) {
	array21[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array21, chunksz, SIZE, p, SIZE, s, SIZE, 3);

      memset (array21, 0, sizeof(array21));
      #pragma omp parallel for schedule(affinity, array21[*][i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array21[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array21, chunksz, SIZE, 0, SIZE-p, s, SIZE, 3);

      memset (array22, 0, sizeof(array22));
      #pragma omp parallel for schedule(affinity, array22[*][i][*])
      for (i=p; i<SIZE; i+=s) {
	array22[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array22, 1, SIZE, p, SIZE, s, SIZE, 3);

      memset (array22, 0, sizeof(array22));
      #pragma omp parallel for schedule(affinity, array22[*][i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array22[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array22, 1, SIZE, 0, SIZE-p, s, SIZE, 3);


      memset (array31, 0, sizeof(array31));
      #pragma omp parallel for schedule(affinity, array31[*][*][i])
      for (i=p; i<SIZE; i+=s) {
	array31[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array31, chunksz, SIZE, p, SIZE, s, 1, 3);

      memset (array31, 0, sizeof(array31));
      #pragma omp parallel for schedule(affinity, array31[*][*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array31[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array31, chunksz, SIZE, 0, SIZE-p, s, 1, 3);

      memset (array32, 0, sizeof(array32));
      #pragma omp parallel for schedule(affinity, array32[*][*][i])
      for (i=p; i<SIZE; i+=s) {
	array32[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array32, 1, SIZE, p, SIZE, s, 1, 3);

      memset (array32, 0, sizeof(array32));
      #pragma omp parallel for schedule(affinity, array32[*][*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array32[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array32, 1, SIZE, 0, SIZE-p, s, 1, 3);


      memset (array41, 0, sizeof(array41));
      #pragma omp parallel for schedule(affinity, array41[i][*][*])
      for (i=p; i<SIZE; i+=s) {
	array41[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array41, chunksz, SIZE, p, SIZE, s, SIZE*SIZE, 6);

      memset (array41, 0, sizeof(array41));
      #pragma omp parallel for schedule(affinity, array41[i][*][*])
      for (i=0; i<SIZE-p; i+=s) {
	array41[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array41, chunksz, SIZE, 0, SIZE-p, s, SIZE*SIZE, 6);

      memset (array42, 0, sizeof(array42));
      #pragma omp parallel for schedule(affinity, array42[i][*][*])
      for (i=p; i<SIZE; i+=s) {
	array42[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array42, 1, SIZE, p, SIZE, s, SIZE*SIZE, 6);

      memset (array42, 0, sizeof(array42));
      #pragma omp parallel for schedule(affinity, array42[i][*][*])
      for (i=0; i<SIZE-p; i+=s) {
	array42[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array42, 1, SIZE, 0, SIZE-p, s, SIZE*SIZE, 6);


      memset (array51, 0, sizeof(array51));
      #pragma omp parallel for schedule(affinity, array51[*][i][*])
      for (i=p; i<SIZE; i+=s) {
	array51[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array51, chunksz, SIZE, p, SIZE, s, SIZE, 6);

      memset (array51, 0, sizeof(array51));
      #pragma omp parallel for schedule(affinity, array51[*][i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array51[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array51, chunksz, SIZE, 0, SIZE-p, s, SIZE, 6);

      memset (array52, 0, sizeof(array52));
      #pragma omp parallel for schedule(affinity, array52[*][i][*])
      for (i=p; i<SIZE; i+=s) {
	array52[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array52, 1, SIZE, p, SIZE, s, SIZE, 6);

      memset (array52, 0, sizeof(array52));
      #pragma omp parallel for schedule(affinity, array52[*][i][*])
      for (i=0; i<SIZE-p; i+=s) {
	array52[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array52, 1, SIZE, 0, SIZE-p, s, SIZE, 6);


      memset (array61, 0, sizeof(array61));
      #pragma omp parallel for schedule(affinity, array61[*][*][i])
      for (i=p; i<SIZE; i+=s) {
	array61[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array61, chunksz, SIZE, p, SIZE, s, 1, 6);

      memset (array61, 0, sizeof(array61));
      #pragma omp parallel for schedule(affinity, array61[*][*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array61[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array61, chunksz, SIZE, 0, SIZE-p, s, 1, 6);

      memset (array62, 0, sizeof(array62));
      #pragma omp parallel for schedule(affinity, array62[*][*][i])
      for (i=p; i<SIZE; i+=s) {
	array62[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array62, 1, SIZE, p, SIZE, s, 1, 6);

      memset (array62, 0, sizeof(array62));
      #pragma omp parallel for schedule(affinity, array62[*][*][i])
      for (i=0; i<SIZE-p; i+=s) {
	array62[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array62, 1, SIZE, 0, SIZE-p, s, 1, 6);
    }
  }


  if (errors == 0) {
    printf ("affinity scheduling 039 : SUCCESS\n");
    return 0;
  } else {
    printf ("affinity scheduling 039 : FAILED\n");
    return 1;
  }
}

#endif
