static char rcsid[] = "$Id: afntyschd040.c,v 1.2 2002/04/03 11:51:52 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* 
 * afinity scheduling 040
 * scheduling ¦ offset ꤵƤ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


#ifndef __OMNI_SCASH__
main ()
{
  printf ("affinity scheduling is supported at OMNI_SCASH only.\n");
  exit (0);
}
#else


#define SIZE		(2*3*4)
#define OFFSET1		1
#define OFFSET2		2
#define OFFSET100	100


int array11[SIZE][SIZE][SIZE];
int array21[SIZE][SIZE][SIZE];
int array31[SIZE][SIZE][SIZE];

#pragma omni mapping (array11[block][*][*])
#pragma omni mapping (array21[*][block][*])
#pragma omni mapping (array31[*][*][block])



int errors = 0;
int p, s;


check (int thds, int *array, int chunksz, int size, int start, int end,
       int stride, int offset, int boffset)
{
  int chunk, i, v, next, tmp;

  chunk = chunksz;

  for (i = 0; i < size; i++) {
    if (i < start) {
      if (*(array + offset * i) != 0) {
	errors += 1;
      }

    } else if (i >=end) {
      if (*(array + offset * i) != 0) {
	errors += 1;
      }

    } else {
      tmp = i + boffset;
      while (tmp < 0) {
	tmp += chunk * thds;
      }
      v = (tmp/chunk) % thds + 1;

      if (i == start) {
	if (*(array + offset * i) != v) {
	  errors += 1;
	}
	next = i + stride;
      } else if (i == next) {
	if (*(array + offset * i) != v) {
	  errors += 1;
	}
	next += stride;
      } else {
	if (*(array + offset * i) != 0) {
	  errors += 1;
	}
      }
    }
  }
}


main ()
{
  int	thds, i, chunksz;


  thds = omp_get_max_threads();
  if (thds == 1) {
    printf ("shuld be run this program on multi threads\n");
    exit (0);
  }

  chunksz = (SIZE + thds - 1) / thds;

  for (p=0; p<SIZE; p++) {
    for (s=1; s<SIZE; s++) {
      memset (array11, 0, sizeof(array11));
      #pragma omp parallel for schedule(affinity, array11[i+1][*][*])
      for (i=p; i<SIZE; i+=s) {
	array11[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array11, chunksz, SIZE, p, SIZE, s, SIZE*SIZE, OFFSET1);

      memset (array11, 0, sizeof(array11));
      #pragma omp parallel for schedule(affinity, array11[i+1][*][*])
      for (i=0; i<SIZE-p; i+=s) {
	array11[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array11, chunksz, SIZE, 0, SIZE-p, s, SIZE*SIZE, OFFSET1);

      memset (array11, 0, sizeof(array11));
      #pragma omp parallel for schedule(affinity, array11[i+2][*][*])
      for (i=p; i<SIZE; i+=s) {
	array11[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array11, chunksz, SIZE, p, SIZE, s, SIZE*SIZE, OFFSET2);

      memset (array11, 0, sizeof(array11));
      #pragma omp parallel for schedule(affinity, array11[i+2][*][*])
      for (i=0; i<SIZE-p; i+=s) {
	array11[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array11, chunksz, SIZE, 0, SIZE-p, s, SIZE*SIZE, OFFSET2);

      memset (array11, 0, sizeof(array11));
      #pragma omp parallel for schedule(affinity, array11[i+100][*][*])
      for (i=p; i<SIZE; i+=s) {
	array11[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array11, chunksz, SIZE, p, SIZE, s, SIZE*SIZE, OFFSET100);

      memset (array11, 0, sizeof(array11));
      #pragma omp parallel for schedule(affinity, array11[i+100][*][*])
      for (i=0; i<SIZE-p; i+=s) {
	array11[i][0][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array11, chunksz, SIZE, 0, SIZE-p, s, SIZE*SIZE, OFFSET100);


      memset (array21, 0, sizeof(array21));
      #pragma omp parallel for schedule(affinity, array21[*][i+1][*])
      for (i=p; i<SIZE; i+=s) {
	array21[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array21, chunksz, SIZE, p, SIZE, s, SIZE, OFFSET1);

      memset (array21, 0, sizeof(array21));
      #pragma omp parallel for schedule(affinity, array21[*][i+1][*])
      for (i=0; i<SIZE-p; i+=s) {
	array21[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array21, chunksz, SIZE, 0, SIZE-p, s, SIZE, OFFSET1);

      memset (array21, 0, sizeof(array21));
      #pragma omp parallel for schedule(affinity, array21[*][i+2][*])
      for (i=p; i<SIZE; i+=s) {
	array21[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array21, chunksz, SIZE, p, SIZE, s, SIZE, OFFSET2);

      memset (array21, 0, sizeof(array21));
      #pragma omp parallel for schedule(affinity, array21[*][i+2][*])
      for (i=0; i<SIZE-p; i+=s) {
	array21[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array21, chunksz, SIZE, 0, SIZE-p, s, SIZE, OFFSET2);

      memset (array21, 0, sizeof(array21));
      #pragma omp parallel for schedule(affinity, array21[*][i+100][*])
      for (i=p; i<SIZE; i+=s) {
	array21[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array21, chunksz, SIZE, p, SIZE, s, SIZE, OFFSET100);

      memset (array21, 0, sizeof(array21));
      #pragma omp parallel for schedule(affinity, array21[*][i+100][*])
      for (i=0; i<SIZE-p; i+=s) {
	array21[0][i][0] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array21, chunksz, SIZE, 0, SIZE-p, s, SIZE, OFFSET100);


      memset (array31, 0, sizeof(array31));
      #pragma omp parallel for schedule(affinity, array31[*][*][i+1])
      for (i=p; i<SIZE; i+=s) {
	array31[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array31, chunksz, SIZE, p, SIZE, s, 1, OFFSET1);

      memset (array31, 0, sizeof(array31));
      #pragma omp parallel for schedule(affinity, array31[*][*][i+1])
      for (i=0; i<SIZE-p; i+=s) {
	array31[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array31, chunksz, SIZE, 0, SIZE-p, s, 1, OFFSET1);

      memset (array31, 0, sizeof(array31));
      #pragma omp parallel for schedule(affinity, array31[*][*][i+2])
      for (i=p; i<SIZE; i+=s) {
	array31[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array31, chunksz, SIZE, p, SIZE, s, 1, OFFSET2);

      memset (array31, 0, sizeof(array31));
      #pragma omp parallel for schedule(affinity, array31[*][*][i+2])
      for (i=0; i<SIZE-p; i+=s) {
	array31[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array31, chunksz, SIZE, 0, SIZE-p, s, 1, OFFSET2);

      memset (array31, 0, sizeof(array31));
      #pragma omp parallel for schedule(affinity, array31[*][*][i+100])
      for (i=p; i<SIZE; i+=s) {
	array31[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array31, chunksz, SIZE, p, SIZE, s, 1, OFFSET100);

      memset (array31, 0, sizeof(array31));
      #pragma omp parallel for schedule(affinity, array31[*][*][i+100])
      for (i=0; i<SIZE-p; i+=s) {
	array31[0][0][i] = omp_get_thread_num () + 1;
      }
      check (thds, (int *)array31, chunksz, SIZE, 0, SIZE-p, s, 1, OFFSET100);
    }
  }


  if (errors == 0) {
    printf ("affinity scheduling 040 : SUCCESS\n");
    return 0;
  } else {
    printf ("affinity scheduling 040 : FAILED\n");
    return 1;
  }
}

#endif
