static char rcsid[] = "";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
#include "omniConfig.h"
#include <stdlib.h>
#include <string.h>
#include <omp.h>
#include "omni.h"


extern char	*optarg;
extern int	optind;


#if defined(__OMNI_SCASH__) || defined(__OMNI_SHMEM__)
#pragma omp threadprivate(optind,optarg)
#endif


usage (name)
     char *name;
{
  char *cmd;

  cmd = strrchr (name, '/');
  if (cmd == NULL) {
    cmd = name;
  } else {
    cmd += 1;
  }

  printf ("%s : [options]\n", cmd);
  printf ("--------------\n");
  printf ("-i : set thread number, exit function called by this thread.\n");
  printf ("-c : set exit code\n");
  printf ("-h : this message.\n");

  exit (0);
}


int
main (argc, argv)
     int	argc;
     char	*argv[];
{

  int	eid = 0;
  int	ec  = 0;
  int	c;

  while ((c = getopt (argc, argv, "i:c:h")) != EOF) {
    switch (c) {
    case 'i':
      eid = atoi(optarg);
      break;
    case 'c':
      ec = atoi(optarg);
      break;
    case 'h':
    default:
      usage(argv[0]);
      break;
    }
  }

  #pragma omp parallel 
  {
    if (omp_get_thread_num () == eid) {
      exit (ec);
    }
  }

  return 0;
}
