static char rcsid[] = "$Id: get_nthrd003.c,v 1.5 2002/04/03 10:38:35 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* omp_get_num_threads : 003
 * parallel for  omp_get_num_threads ưǧ
 */

#include "omniConfig.h"
#include <string.h>
#include <omp.h>
#include "omni.h"


#define	LOOPNUM		(100*thds)


int
main ()
{
  int		thds, i, lc;
  int		errors = 0;


  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi thread.\n");
    exit (0);
  }
  omp_set_dynamic (0);


  #pragma omp parallel for schedule(static,1)
  for (i=0; i<LOOPNUM; i++) {
    if (omp_get_num_threads () != thds) {
      #pragma omp critical
      errors += 1;
    }
  }


#if defined(__OMNI_SCASH__) || defined(__OMNI_SHMEM__)
  /* Omni on SCASH do not support omp_set_num_threads.
   * and, some test 
   */
  printf ("skip some tests. because, Omni on SCASH/SHMEM do not support omp_set_num_threads, yet.\n");
#else
  for (i=1; i<=thds; i++) {

    omp_set_num_threads (i);
    #pragma omp parallel for schedule(static,1)
    for (lc=0; lc<LOOPNUM; lc++) {
      if(omp_get_num_threads () != i) {
	errors += 1;
      }
    }
  }
#endif


  if (errors == 0) {
    printf ("omp_get_num_threads 003 : SUCCESS\n");
    return 0;
  } else {
    printf ("omp_get_num_threads 003 : FAILED\n");
    return 1;
  }
}
