static char rcsid[] = "$Id: get_nthrd006.c,v 1.4 2000/07/30 13:10:38 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* omp_get_num_threads : 006
 * nested parallel region  enable ξ
 * omp_get_num_threads ưǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


int
main ()
{
  int	thds;
  int	errors = 0;


  /* initialize */
  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi thread.\n");
    exit (0);
  }
  omp_set_dynamic (0);
  omp_set_nested (1);
  if (omp_get_nested() == 0) {
    printf ("nested parallelism is not supported.\n");
    goto END;
  }

  omp_set_num_threads (1);

  #pragma omp parallel
  {
    if (omp_get_num_threads () != 1) {
      #pragma omp critical
      errors += 1;
    }

    omp_set_num_threads (thds);
    #pragma omp parallel
    {
      int n = omp_get_num_threads ();

      if (n == 1) {
	printf ("nested parallel is serialized\n");
      } else if (n != thds) {
	#pragma omp critical
	errors += 1;
      }
    }
  }


 END:
  if (errors == 0) {
    printf ("omp_get_num_threads 006 : SUCCESS\n");
    return 0;
  } else {
    printf ("omp_get_num_threads 006 : FAILED\n");
    return 1;
  }
}
