static char rcsid[] = "$Id: get_thrdn002.c,v 1.5 2002/04/03 10:38:36 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* omp_get_thread_num : 002
 * parallel region omp_get_thread_num ưǧ
 */

#include "omniConfig.h"
#include <string.h>
#include <omp.h>
#include "omni.h"


int
main ()
{
  int	thds, *buf, i, j;

  int	errors = 0;


  /* initialize */
  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");	
    exit (0);
  }
  buf = (int *) malloc ((thds + 1) * sizeof(int));
  if (buf == NULL) {
    printf ("can not allocate memory\n");
    exit (1);
  }
  omp_set_dynamic (0);


  memset (buf, 0, sizeof(int) * (thds+1));

  #pragma omp parallel
  {
    int id = omp_get_thread_num ();
      
    #pragma omp critical
    buf[id] += 1;
  }

  for (j=0; j<thds; j++) {
    if (buf[j] != 1) {
      errors += 1;
    }
  }
  if (buf[thds] != 0) {
    errors += 1;
  }


#if defined(__OMNI_SCASH__) || defined(__OMNI_SHMEM__)
  /* Omni on SCASH do not support omp_set_num_threads.
   * and, some test 
   */
  printf ("skip some tests. because, Omni on SCASH/SHMEM do not support omp_set_num_threads, yet.\n");
#else
  for (i=1; i<=thds; i++) {

    omp_set_num_threads (i);
    memset (buf, 0, sizeof(int) * (thds+1));

    #pragma omp parallel
    {
      int id = omp_get_thread_num ();
      
      #pragma omp critical
      buf[id] += 1;
    }

    for (j=0; j<i; j++) {
      if (buf[j] != 1) {
	errors += 1;
      }
    }
    if (buf[thds] != 0) {
      errors += 1;
    }
  }
#endif


  if (errors == 0) {
    printf ("omp_get_thread_num 002 : SUCCESS\n");
    return 0;
  } else {
    printf ("omp_get_thread_num 002 : FAILED\n");
    return 1;
  }
}
