static char rcsid[] = "$Id: set_nlck002.c,v 1.5 2002/06/22 18:09:07 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* omp_set_nest_lock 002:
 * lockƤѿФomp_set_nest_lock¹Ԥȡ
 * unlockޤǡԤǧ롣
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


main ()
{
  omp_nest_lock_t	lck;
  int			thds;
  volatile int	i;

  int		errors = 0;


  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi thread.\n");
    exit (0);
  }

  omp_init_nest_lock(&lck);
  i = 0;

  #pragma omp parallel
  {
    int	tmp;

    #pragma omp barrier

    omp_set_nest_lock (&lck);
    #pragma omp flush (i)	/* SCASH need flush, here */

    tmp = i;
    waittime (1);
    i = tmp + 1;

    #pragma omp flush (i)	/* SCASH need flush, here */
    omp_unset_nest_lock (&lck);
  }

  if (i != thds) {
    errors += 1;
  }


  if (errors == 0) {
    printf ("omp_set_nest_lock 002 : SUCCESS\n");
    return 0;
  } else {
    printf ("omp_set_nest_lock 002 : FAILED\n");
    return 1;
  }
}
