static char rcsid[] = "$Id: set_nlck004.c,v 1.4 2000/10/13 19:27:26 a-hasega Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */
/* omp_set_nest_lock 004:
 * lockѿˡ̤椬Ǥǧ
 */

#include "omniConfig.h"
#include <omp.h>
#include "omni.h"


void
barrier (int n)
{
  static int cnt[2] = { 0, 0 };
  static int cur = 0;

  int	c;

  #pragma omp critical
  {
    c = cur;
    if (cnt[c]+1 == n) {
      cur = (cur + 1) % 2;
      cnt[c] = 0;
    } else {
      cnt[c] += 1;
    }
  }

  while (cnt[c] != 0) {
    #pragma omp flush
  }
}


main ()
{
  omp_nest_lock_t	lck, lck2;
  int			thds;

  int			errors = 0;


  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi thread.\n");
    exit (0);
  }

  omp_init_nest_lock(&lck);
  omp_init_nest_lock(&lck2);

  #pragma omp parallel sections
  {
    #pragma omp section
    {
      barrier (2);

      omp_set_nest_lock (&lck);
      barrier (2);
      omp_unset_nest_lock (&lck);

      omp_set_nest_lock (&lck2);
      omp_set_nest_lock (&lck2);
      barrier (2);
      omp_unset_nest_lock (&lck2);
      omp_unset_nest_lock (&lck2);
    }

    #pragma omp section
    {
      barrier (2);

      omp_set_nest_lock (&lck2);
      barrier (2);
      omp_unset_nest_lock (&lck2);

      omp_set_nest_lock (&lck);
      omp_set_nest_lock (&lck);
      barrier (2);
      omp_unset_nest_lock (&lck);
      omp_unset_nest_lock (&lck);
    }
  }


  if (errors == 0) {
    printf ("omp_set_nest_lock 004 : SUCCESS\n");
    return 0;
  } else {
    printf ("omp_set_nest_lock 004 : FAILED\n");
    return 1;
  }
}
