#define NULL 0
/*----------------------*/ 
#ifdef USE_GETRUSAGE
#include <sys/resource.h>
#else
#include <sys/time.h>
#endif

double second()
{
#ifdef USE_GETRUSAGE
struct rusage ru;
double t ;

void getrusage();
 
getrusage(RUSAGE_SELF,&ru) ;
 
t = (double) (ru.ru_utime.tv_sec+ru.ru_stime.tv_sec) + 
    ((double) (ru.ru_utime.tv_usec+ru.ru_stime.tv_usec))/1.0e6 ;
#else
struct timeval tm;
double t ;

static int base_sec = 0,base_usec = 0;

gettimeofday(&tm,NULL);
if(base_sec == 0 && base_usec == 0)
  {
      base_sec = tm.tv_sec;
      base_usec = tm.tv_usec;
      t = 0.0;
  }
else
  {
      t = (double) (tm.tv_sec-base_sec) + 
	((double) (tm.tv_usec-base_usec))/1.0e6 ;
  }
#endif
return t ;
}
 
