C
C Laplace equation with explict method 
C
      program laplace
      implicit none
      integer X_SIZE,Y_SIZE,N_ITER
      parameter(X_SIZE=1000,Y_SIZE=1000,N_ITER=50)
      double precision PI
      parameter(PI=3.1415927)
      double precision u,uu
      dimension u(0:X_SIZE+1,0:Y_SIZE+1),uu(0:X_SIZE+1,0:Y_SIZE+1)
      integer xsize,ysize,niter
      integer i,j
      double precision omp_get_wtime,t1,t2
C
      xsize = X_SIZE
      ysize = Y_SIZE
      niter = N_ITER
      do j = 1,ysize
         do i = 1,xsize
            u(i,j) = sin(dble(i-1)/xsize*PI) + cos(dble(j-1)/ysize*PI)
         enddo
      enddo
      do i = 0,xsize+1
         u(i,0) = 0.0
         u(i,ysize+1) = 0.0
         uu(i,0) = 0.0
         uu(i,ysize+1) = 0.0
      enddo 
      do j = 0,ysize+1
         u(0,j) = 0.0
         u(xsize+1,j) = 0.0
         uu(0,j) = 0.0
         uu(xsize+1,j) = 0.0
      enddo 

!$    t1 = omp_get_wtime()
      call lap_main(u,uu,xsize,ysize,niter)
!$     t2 = omp_get_wtime()
!$    write(*,*) 'time=',t2-t1
      print *,'end..'
      end

      subroutine lap_main(u,uu,xsize,ysize,niter)
      implicit none
      integer xsize,ysize,niter
      double precision u,uu
      dimension u(0:xsize+1,0:ysize+1),uu(0:xsize+1,0:ysize+1)
      integer i,j,k
      double precision sum
c 	/* old <- new */
!$omp parallel private(k,i,j)
      do k = 1,niter
!$omp do 
         do j = 1,ysize
            do i = 1,xsize
               uu(i,j) = u(i,j)
            enddo 
         enddo 
!$omp enddo
c         /* update */
!$omp do
         do j = 1,ysize
            do i = 1,xsize
               u(i,j)=(uu(i-1,j)+uu(i+1,j)+uu(i,j-1)+uu(i,j+1))*0.25
            enddo 
         enddo 
!$omp enddo
      enddo 
c    /* check sum */
!$omp single
      sum = 0.0
!$omp end single
!$omp do reduction(+:sum)
      do j = 1,ysize
         do i = 1,xsize
            sum = sum + (uu(i,j)-u(i,j))
         enddo 
      enddo 
!$omp enddo
!$omp end parallel
      write(*,*) 'sum=',sum
      return
      end
