static char rcsid[] = "$Id: launcher.c,v 1.6 2002/02/20 07:53:34 m-hirano Exp $";
/* 
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */

#include "exc_platform.h"

#ifdef LANG_C
#define LANG_OPT	"-omnilang=C"
#else
#ifdef LANG_F77
#define LANG_OPT	"-omnilang=F77"
#else
#ifdef LANG_CXX
#define LANG_OPT	"-omnilang=C++"
#endif /* LANG_CXX */
#endif /* LANG_F77 */
#endif /* LANG_C */

char *progName = NULL;
static void
ProgName(name)
     char *name;
{
    progName = strrchr(name, '/');
    if (progName != NULL) {
        progName++;
    } else {
        progName = name;
    }
}


typedef struct {
    char *pat;
    int len;
    int care;
} optionRec;

static optionRec tbl[] = {
    { "-omniVersion", 12, 1 },
    { "-omnilang=", 10, 0 },
    { "-omniconfig=", 12, 1 },
    { "-omniVerbose", 12, 1 },
    { "-omnicc=", 8, 1 },
    { "-omnitmpl=", 10, 1 },
    { "-omniForceJavaBackend", 21, 1 },
    { "-omnipragma=", 12, 1},
#ifdef USE_OPENGR_PRAGMA
    { "-omniGridRPCFlavor=", 19, 1 },
#endif /* USE_OPENGR_PRAGMA */
    { NULL, 0 }
};


static char *
genDriverName()
{
    char *omniDir = getenv("OMNI_HOME");
    char *driver = DRIVER;
    char *ret = NULL;
    int dLen = 0;
    
    if (omniDir == NULL) {
	omniDir = OMNI_INSTALL_DIR;
    } else {
	char *tmp = NULL;
	dLen = strlen(omniDir) + strlen("/lib/openmp/libexec") + 1;
	tmp = (char *)malloc(sizeof(char) * dLen);
	if (tmp == NULL) {
	    fprintf(stderr, "%s: can't allocate memory.\n", progName);
	    exit(1);
	}
	sprintf(tmp, "%s/lib/openmp/libexec", omniDir);
	omniDir = tmp;
    }

    dLen = strlen(omniDir) + strlen(driver) + 2;
    ret = (char *)malloc(sizeof(char) * dLen);
    if (ret == NULL) {
	fprintf(stderr, "%s: can't allocate memory.\n", progName);
	exit(1);
    }
    sprintf(ret, "%s/%s", omniDir, driver);
    ret[dLen] = '\0';

    return ret;
}

    
int
main(argc, argv)
     int argc;
     char *argv[];
{
    char **opt = NULL;
#ifdef OGRCC
    int nOpt = 3;
#else
    int nOpt = 2;
#endif /* OGRCC */
    int i;
    char **start = &(argv[1]);
    int found = 0;

    ProgName(argv[0]);
    opt = (char **)malloc(sizeof(char *) * (argc + 4));
    if (opt == NULL) {
	fprintf(stderr, "%s: can't allocate memory.\n", progName);
	exit(1);
    }

    opt[0] = genDriverName();
    opt[1] = LANG_OPT;
#ifdef OGRCC
    opt[2] = "-omnipragma=openmp:opengr";
#endif /* OGRCC */

    while (*start != NULL) {
	for (i = 0; tbl[i].len != 0; i++) {
	    if (strncmp(*start, tbl[i].pat, tbl[i].len) == 0 &&
		tbl[i].care == 1) {
		opt[nOpt] = *start;
		nOpt++;
		break;
	    }
	}
	start++;
    }

    start = &(argv[1]);
    while (*start != NULL) {
	found = 0;
	for (i = 0; tbl[i].len != 0; i++) {
	    if (strncmp(*start, tbl[i].pat, tbl[i].len) == 0) {
		found = 1;
		break;
	    }
	}
	if (found == 0) {
	    opt[nOpt] = *start;
	    nOpt++;
	}
	start++;
    }

    opt[nOpt] = (char *)NULL;
#if 0
    for (i = 0; i < nOpt; i++) {
	fprintf(stderr, "debug:%5d\t'%s'\n", i, opt[i]);
    }
#endif

    errno = 0;
    if (execvp(opt[0], opt) < 0) {
	perror("execvp");
	fprintf(stderr, "%s: can't exec %s.\n", progName, opt[0]);
	return 1;
    } else {
	return 0;
    }
}
