/*
 * $Id: jexc_main.c,v 1.3 2000/09/05 15:08:57 m-hirano Exp $
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */

#include "jexc.h"
#include <sys/stat.h>

#define MAX_FILENAME_LEN  100
#define MAX_PATH 10

int debug_flag = FALSE;
int dump_flag = FALSE;

char *main_class_name;

char *find_class_file(char *file);

static int	file_exist(char *fliename);
static void	usage(char *prog);
static void	input_file_list(char *file);

char *class_path[MAX_PATH];
int n_class_path = 0;

int main(int argc, char *argv[])
{
    int ac;
    char *av;
    char *p;
    char *class_path_env;

    jexc_init();

    if((class_path_env = (char *)getenv("CLASSPATH")) != NULL){
	while((p = strrchr(class_path_env,':')) != NULL){
	    *p = '\0';
	    class_path[n_class_path++] = p+1;
	}
	class_path[n_class_path++] = class_path_env;
    }

    for(ac = 1; ac < argc; ac++){
	av = argv[ac];
	if(strcmp(av,"-h") == 0 || strcmp(av,"-help") == 0){
	    usage(argv[0]);
	} else if(strcmp(av,"-debug") == 0 || strcmp(av,"-d") == 0){
	    debug_flag = TRUE;
	} else if(strcmp(av,"-main") == 0){
	    ac++;
	    if(ac >= argc){
	      error("bad arg");
	      usage(argv[0]);
	    }
	    main_class_name = argv[ac];
	} else if(strcmp(av,"-package-list") == 0){
	    ac++;
	    if(ac >= argc){
	      error("bad arg");
	      usage(argv[0]);
	    }
	    input_file_list(argv[ac]);
	} else if(strcmp(av,"-class-path") == 0){
	    ac++;
	    if(ac >= argc) usage(argv[0]);
	    class_path[n_class_path++] = argv[ac];
	} else if(strcmp(av,"-dump") == 0){
	    dump_flag = TRUE;
	} else if(av[0] == '-'){
	    fprintf(stderr,"unknown flag: %s\n",av);
	    return 1;
	} else input_class_file(find_class_file(av));
    }

    if(dump_flag) return 0;

    jexc_translate(JEXC_TEMP_FILE_NAME);

    return 0;
}

char *find_class_file(char *filename)
{
    int i;
    char buf[128];

    for(i = n_class_path-1; i >= 0; i--){
	strcpy(buf,class_path[i]);
	strcat(buf,"/");
	strcat(buf,filename);
	if(file_exist(buf)) goto ret;
	strcat(buf,".class");
	if(file_exist(buf)) goto ret;
    }
    strcpy(buf,filename);
    if(file_exist(buf)) goto ret;
    strcat(buf,".class");
    if(file_exist(buf)) goto ret;
    /* not found */
    error("class file '%s' is not found",filename);
    return NULL;
 ret:
    return strdup(buf);
}

int file_exist(char *filename)
{
    struct stat buf;
    int r;
    r = stat(filename,&buf);
    return r == 0;
}

static void
input_file_list(char *file)
{
    FILE *fp;
    char filename[MAX_FILENAME_LEN];
    char *p,*q;

    if((fp = fopen(file,"r")) == NULL){
	fprintf(stderr,"cannot open '%s'\n",file);
	exit(1);
    }
    while(fgets(filename,MAX_FILENAME_LEN,fp) != NULL){
	for(p = filename;*p != 0; p++)
	    if(!isspace(*p)) break;
	if(*p == 0) continue;
	for(q = p; *q != 0; q++)
	    if(isspace(*q)) break;
	*q = 0;
	input_class_file(find_class_file(p));
    }
    fclose(fp);
}

static void
usage(char *prog)
{
    fprintf(stderr,"%s [-main main_class] [-package-list .lst] file.class \n",prog);
    exit(1);
}



