/*
 * $Id: jexc_mem.c,v 1.3 2000/09/05 15:08:57 m-hirano Exp $
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */

#include "jexc.h"

/*
 * memory management 
 */
struct name_entry {
    struct name_entry *next;
    char *name;
};

/* hash table size for symbol name */
#define SYMBOL_HASH_SIZE	0x400
#define SYMBOL_HASH_MASK	(SYMBOL_HASH_SIZE - 1)
struct name_entry *name_hash_table[SYMBOL_HASH_SIZE];

char *xmalloc(int size)
{
    char *p;
    if((p = malloc(size)) == NULL){
	fprintf(stderr,"cannot alloc memory");
	exit(1);
    }
    bzero(p,size);
    return p;
}

char *intern(char *name)
{
    struct name_entry *sp;
    int     hcode;
    char   *cp;

    /* hash code, bad ?? */
    hcode = 0;
    for( cp = name ; *cp != 0 ; cp++ )
	hcode = (hcode << 1) + *cp;
    hcode &= SYMBOL_HASH_MASK;
    
    for (sp = name_hash_table[hcode] ; sp != NULL ; sp = sp->next)
	if (strcmp(name, sp->name) == 0)
	    return (sp->name);

	/* not found, allocate symbol structure */
    sp = (struct name_entry *)xmalloc(sizeof(*sp));
    sp->name = strdup(name);

    /* link it (as top of the hash list) */
    sp->next = name_hash_table[hcode];
    name_hash_table[hcode] = sp;
    return (sp->name);
}
