/*
 * $Id: jexc_runtime.h,v 1.6 2000/09/29 09:59:56 msato Exp $
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */

#include "exc_platform.h"
#include <setjmp.h>

/*
 * jexc vm runtime data structure
 */
#define STACK_SIZE  8000
#define MAX_STR_LEN 1024

/* words have the size of pointer */
typedef struct _jexc_object *jexc_word;

typedef _omInt32_t jexc_int;
typedef _omUint32_t jexc_uint;
typedef char jexc_byte;
typedef _omInt16_t jexc_short;
typedef _omInt16_t jexc_char;
typedef double jexc_double;
typedef float jexc_float;
typedef _omInt64_t jexc_long;
typedef _omUint64_t jexc_ulong;

typedef union {
    struct {
#if (WORDS_BIGENDIAN == 1)
	jexc_int high,low;
#else
	jexc_int low,high;
#endif
    } HL;
    double d;
    jexc_long l;
    jexc_ulong ul;
    jexc_int i;
    jexc_uint ui;
    float f;
} jexc_any;

typedef void (*jexc_c_func)();

typedef struct _jexc_interf {
    struct _jexc_interf *link;
    int method_id;
    jexc_c_func f;
} jexc_interf;

typedef struct _jexc_class {
    struct _jexc_class *super;
    char *name;		/* this class name */
    int n_method;
    jexc_c_func *methods;
    jexc_interf *interfaces;

    int i_static,n_static;
    int i_var,n_var;
    int obj_size;

    char *i_static_base;	/* static integral variable */
    jexc_word n_static_base[1];	/* static object variable */
} jexc_class;

#define CVAR(p,i) ((p)->n_static_base[i])
#define ICVAR(t,p,off) *((t *)((p)->i_static_base+(off)))

/* common structure of jexc memory allocation */
typedef struct _jexc_mem {
    int size;
    struct _jexc_mem *next;  /* link */
} jexc_mem;

typedef struct _jexc_object {
    int size;
    jexc_class *class;
    char *i_var_base;		/* base address of integral variable */
    jexc_word n_var_base[1];	/* base of object variable */
} jexc_object;

#define VAR(p,i) ((p)->n_var_base[i])
#define VAR0(p)  ((p)->n_var_base[0])
#define VAR0_OPAQUE(t,p) ((t)(((struct _jexc_opaque *)VAR0(p))->base))
#define IVAR(t,p,off) *((t *)(p->i_var_base+(off)))
#define INTVAR(p,off) *((jexc_int *)(p->i_var_base+(off)))

#define OPAQUE_OBJECT ((jexc_class *)(0))
typedef struct _jexc_opaque {
    int size;
    jexc_class *class;  /* 0 */
    char base[1];
} jexc_opaque;

/* object array */
#define ARRAY_OBJECT ((jexc_class *)(1))
typedef struct _jexc_array {
    int size;
    jexc_class *class;  /* ARRAY_CLASS */
    int length;
    jexc_word elem[1];
} jexc_array;

/* integral array */
#define IARRAY_OBJECT ((jexc_class *)(2))
typedef struct _jexc_iarray {
    int size;
    jexc_class *class;  /* IARRAY_CLASS */
    int length;
    char base[1];
} jexc_iarray;

#define IARRAY_BOOLEAN 4
#define IARRAY_CHAR 5
#define IARRAY_FLOAT 6
#define IARRAY_DOUBLE 7
#define IARRAY_BYTE 8
#define IARRAY_SHORT 9
#define IARRAY_INT 10
#define IARRAY_LONG 11

/* root object */
extern jexc_class *jexc_object_class; 	

/* string object */
extern jexc_class *jexc_string_class;

typedef struct _jexc_string_opaque {
    int size;
    jexc_class *class; /* 0: opaque */
    int length;
    char str[1];
} jexc_string_opaque;

typedef struct _jexc_string {
    int size;
    jexc_class *class;		/* jexc_string_class */
    char *i_var_base;		/* not used */
    struct _jexc_string *link;	/* hash link for intern */
    jexc_string_opaque *op;
} jexc_string;

/*
 * throw & catch
 */
typedef struct _jexc_catch_info {
    struct _jexc_catch_info *link;
    jexc_word *top_save;
    jmp_buf env;
} jexc_catch_info;

extern jexc_catch_info *jexc_catch_p;
extern jexc_object *jexc_throw_object;

extern jexc_word *Top,*jexc_stack; /* stack top */

extern int n_class;
extern jexc_class **jexc_class_table;

extern int n_string_constant;
extern char *string_constants[];
extern jexc_string **jexc_string_table;

#define STR_HASH_SIZE 512
#define STR_HASH_MASK (STR_HASH_SIZE-1)
extern jexc_string *jexc_string_hash_table[];

extern jexc_class *jexc_integer_class;

#define MAX_SYS_PROP 10
extern char *system_property_names[MAX_SYS_PROP];
extern char *system_property_vals[MAX_SYS_PROP];
extern int  n_system_property;

jexc_class *jexc_define_class(char *name,int id,int super,int i_static,
			      int n_static,int i_var,int n_var,int n_method);
void jexc_add_interface(jexc_class *cp,int m_id,int disp);
jexc_c_func jexc_lookup_interface(jexc_object *p,int m_id);
jexc_class *jexc_find_class(char *name);

void jexc_checkcast(jexc_object *p,jexc_class *cp);
int jexc_instanceof(jexc_object *p,jexc_class *cp);

jexc_string *jexc_new_string(char *str);
jexc_string *jexc_new_string_n(char *str,int len);
jexc_string *jexc_intern_string(jexc_string *sp);
jexc_array *jexc_new_array(int len);
jexc_array *jexc_new_multiarray(int ndim, jexc_word *sp);
jexc_iarray *jexc_new_iarray(int len,int kind);

jexc_opaque *jexc_alloc_opaque(int size);
jexc_string_opaque *jexc_alloc_string_opaque(int l,char *str);

void jexc_runtime_init();
void jexc_run_main(int argc,char *argv[],int main_class_id,int method_disp);

char *xmalloc(int size);
jexc_mem *jexc_malloc(int size);
jexc_object *jexc_new_object(jexc_class *cp);
void  jexc_error EXC_VARARGS(char *, fmt);
int jexc_catch_match(int pc,int start,int end,int id);

void jexc_class_initialize(void);
void jexc_throw(jexc_object *p);
void jexc_init_Lang_class(void);

void jexc_GC(void);
void jexc_gc_on(void);
void jexc_gc_off(void);






