/*
 * $Id: jexc_sys_class.h,v 1.7 2002/03/29 20:16:00 m-hirano Exp $
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */

/*
 * For {DBL|FLT}_{MIN|MAX}
 */
#ifndef NO_FLOAT_H
#include <float.h>
#else
/*
 * IEEE 754 definition.
 */
#ifndef DBL_MAX
#define DBL_MAX		1.7976931348623157E+308
#endif /* !DBL_MAX */
#ifndef DBL_MIN
#define DBL_MIN		2.2250738585072014E-308
#endif /* !DBL_MIN */
#ifndef FLT_MAX
#define FLT_MAX		3.402823466E+38F
#endif /* !FLT_MAX */
#ifndef FLT_MIN
#define FLT_MIN		1.175494351E-38F
#endif /* !FLT_MIN */
#endif /* !NO_FLOAT_H */

#define DEFINE_C_METHOD(f)	void f(jexc_word **_spp)
#define DECL_C_METHOD_VAR     	jexc_word *fp = *_spp
#define RETURN_C_METHOD(v)	fp[0] = (v); *(_spp) += 1; return
#define RETURN_C_METHOD_INT(i)	*((jexc_int *)fp) = (i); *(_spp) += 1; return
#define RETURN_C_METHOD_THIS	*(_spp) += 1; return

#define GC_OFF	jexc_gc_off()
#define GC_ON   jexc_gc_on()

#define MAX_SYS_CP 4096

void abstractMethod();

#define JEXC_CLINIT_METHOD 0
#define JEXC_INIT_METHOD 1
#define JEXC_TOSTRING_METHOD 2
#define JEXC_EQUALS_METHOD 3

/* java/lang/Object */
#define Lang_Object_INIT_NAME "<init>"
#define Lang_Object_INIT_DESC "()V"
#define Lang_Object_INIT_CNAME "Lang_Object_INIT"
#define Lang_Object_CLINIT_NAME "<clinit>"
#define Lang_Object_CLINIT_DESC "()V"
#define Lang_Object_CLINIT_CNAME "Lang_Object_CLINIT"
#define Lang_Object_toString_NAME "toString"
#define Lang_Object_toString_DESC "()Ljava/lang/String;"
#define Lang_Object_toString_CNAME "Lang_Object_toString"
#define Lang_Object_equals_NAME "equals"
#define Lang_Object_equals_DESC "()Z"
#define Lang_Object_equals_CNAME "Lang_Object_equals"

void Lang_Object_CLINIT();
void Lang_Object_INIT();
void Lang_Object_toString();
void Lang_Object_equals();

void float_toString(char *buf,double d);

/* java/lang/String */
void Lang_String_INIT1();
void Lang_String_INIT2();
void Lang_String_INIT3();
void Lang_String_valueOf_AChar();
void Lang_String_intern();
void Lang_String_equals();
void Lang_String_valueOf_Object();
void Lang_String_charAt();
void Lang_String_compareTo();
void Lang_String_indexOf();
void Lang_String_lastIndexOf();
void Lang_String_length();
void Lang_String_substring();
void Lang_String_substring2();
void Lang_String_indexOf_0();
void Lang_String_lastIndexOf_0();
void Lang_String_endsWith();
void Lang_String_startsWith();
void Lang_String_concat();
void Lang_String_valueOf_I();
void Lang_String_valueOf_J();
void Lang_String_valueOf_C();
void Lang_String_valueOf_D();
void Lang_String_valueOf_F();
void Lang_String_toCharArray();

/* java/lang/Integer */
void Lang_Integer_INIT();
void Lang_Integer_toString();
void Lang_Integer_toString_I();
void Lang_Integer_toHexString();
void Lang_Integer_toOctalString();
void Lang_Integer_parseInt();
void Lang_Integer_intValue();
void Lang_Integer_equals();

/* java/lang/Double */
void Lang_Double_D2J();
void Lang_Double_J2D();
void Lang_Double_equals();

#define Lang_Double_MIN_VALUE 0
#define DOUBLE_MIN_VALUE	DBL_MIN
#define Lang_Double_MAX_VALUE 8
#define DOUBLE_MAX_VALUE	DBL_MAX

#define Lang_Float_MIN_VALUE 0
#define FLOAT_MIN_VALUE		FLT_MIN
#define Lang_Float_MAX_VALUE 4
#define FLOAT_MAX_VALUE		FLT_MAX

/* java/lang/Long */
void Lang_Long_toHexString();
void Lang_Long_equals();

/* java/lang/Thread */
void Lang_Thread_dumpStack();

/* java/lang/System */
#define Lang_System_out 0	/* static field */
#define Lang_System_err 1	/* static field */
#define Lang_System_in 2	/* static field */
void Lang_System_CLINIT();
void Lang_System_INIT();
void Lang_System_exit();
void Lang_System_getProperty();

/* java/lang/StringBuffer */
void Lang_StringBuffer_INIT();
void Lang_StringBuffer_INIT1();
void Lang_StringBuffer_append_I();
void Lang_StringBuffer_append_Lstring();
void Lang_StringBuffer_append_L();
void Lang_StringBuffer_toString();
void Lang_StringBuffer_append_C();
void Lang_StringBuffer_append_J();
void Lang_StringBuffer_append_D();
void Lang_StringBuffer_append_F();

/* Process & Runtime */
void Lang_Process_exitValue();
void Lang_Process_getErrorStream();
void Lang_Process_waitFor();
void Lang_Runtime_getRuntime();
void Lang_Runtime_exec();

void Io_Reader_close();
void Io_Reader_read();
void Io_Reader_read1();
void Io_Reader_readLine();

void Io_FileReader_INIT();
void Io_BufferedReader_INIT();
void Io_InputStreamReader_INIT();

void Io_PrintWriter_INIT1();
void Io_PrintWriter_INIT2();
void Io_PrintWriter_INIT3();
void Io_PrintWriter_INIT4();
void Io_PrintWriter_print_I();
void Io_PrintWriter_println_I();
void Io_PrintWriter_print_C();
void Io_PrintWriter_print_D();
void Io_PrintWriter_print_String();
void Io_PrintWriter_println_String();
void Io_PrintWriter_println_L();
void Io_PrintWriter_println();
void Io_PrintWriter_flush();
void Io_PrintWriter_write();

void Io_BufferedWriter_INIT();
void Io_Writer_close();
void Io_OutputStreamWriter_INIT();
void Io_FileWriter_INIT();

/* java/io/PrintStream */
void Io_PrintStream_INIT();

struct jexc_io_stream {
    FILE *fp;
};

void Io_FileInputStream_INIT();

void Io_File_INIT();
void Io_File_exist();

/* 
 * Utl
 */
void Utl_vectEnum_hasMoreElements();
void Utl_vectEnum_nextElement();

void Utl_Vector_INIT();
void Utl_Vector_addElement();
void Utl_Vector_elementAt();
void Utl_Vector_indexOf();
void Utl_Vector_removeElementAt();
void Utl_Vector_setElementAt();
void Utl_Vector_size();
void Utl_Vector_removeElement();
void Utl_Vector_elements();
void Utl_Vector_isEmpty();
void Utl_Vector_contains();

#define Utl_Vector_SIZE		0
#define Utl_Vector_cap_incr	4

void Utl_Stack_peek();
void Utl_Stack_pop();
void Utl_Stack_push();

void Utl_Hashtable_INIT();
void Utl_Hashtable_INIT1();
void Utl_Hashtable_get();
void Utl_Hashtable_put();
#define Utl_Hashtable_keys 	0
#define Utl_Hashtable_vals	1
#define Utl_Hashtable_num_keys  0
#define Utl_Hashtable_load_factor  4









