/*
 * $Id: mach-dep.c,v 1.3 2000/09/06 13:33:55 m-hirano Exp $
 * $RWC_Release: Omni-1.6 $
 * $RWC_Copyright:
 *  Omni Compiler Software Version 1.5-1.6
 *  Copyright (C) 2002 PC Cluster Consortium
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Omni Compiler Software Version 1.0-1.4
 *  Copyright (C) 1999, 2000, 2001.
 *   Tsukuba Research Center, Real World Computing Partnership, Japan.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  
 *  $
 */

#include "jexc.h"

#define SIZE_OF_OBJECT  SIZEOF_VOID_P
#define OBJECT_ALIGN	SIZEOF_VOID_P

int data_type_size(DATA_TYPE type)
{
    switch (type) {
    case UNDEF:
	return (0);
    case BYTE:
	return (1);
    case SHORT:
#ifdef HAS_INT16
	return sizeof(_omInt16_t);
#else
	return 2;
#endif /* HAS_INT16 */
    case INT:
#ifdef HAS_INT32
	return sizeof(_omInt32_t);
#else
	return 4;
#endif /* HAS_INT32 */
    case LONG:
#ifdef HAS_INT64
	return sizeof(_omInt64_t);
#else
	return 8;
#endif /* HAS_INT64 */
    case FLOAT:
	return 4;
    case DOUBLE:
	return 8;
    case OBJECT:
	return SIZE_OF_OBJECT;
    default:
	fatal("basic_type_size");
	return 0;
    }
}

int data_type_align(DATA_TYPE type)
{
    switch (type) {
    case UNDEF:
    case BYTE:
	/* nothing */
	return 1;
    case SHORT:
	return 2;
    case INT:
	return 4;
    case LONG:
	return 4;
    case FLOAT:
	return 4;
    case DOUBLE:
	return 8;
    case OBJECT:
	return OBJECT_ALIGN;
    default:
	fatal("basic_type_size");
	return 0;
    }
}


