#include <stdio.h>
#include <math.h>

/* square region */
#define XSIZE 100
#define YSIZE XSIZE

#define PI 3.1415927
#define NITER 10 /* 100 */


#ifdef not
double time1,time2;
double second();
#endif

/*
 * Laplace equation with explict method 
 *	(originally written by Taiskue Boku (taisuke@is.tsukuba.ac.jp))
 */

double u[XSIZE+2][YSIZE+2],uu[XSIZE+2][YSIZE+2];

main()
{
    int x,y;

    printf("lap start ...\n");
    /* initalize */
    for(x = 1; x <= XSIZE; x++)
      for(y = 1; y <= YSIZE; y++)
	u[x][y] = sin((double)(x-1)/XSIZE*PI) + cos((double)(y-1)/YSIZE*PI);

    for(x = 0; x < (XSIZE+2); x++){
	u[x][0] = 0.0;
	u[x][YSIZE+1] = 0.0;
	uu[x][0] = 0.0;
	uu[x][YSIZE+1] = 0.0;
    }

    for(y = 0; y < (YSIZE+2); y++){
	u[0][y] = 0.0;
	u[XSIZE+1][y] = 0.0;
	uu[0][y] = 0.0;
	uu[XSIZE+1][y] = 0.0;
    }


#ifdef not
    time1 = second();
#endif
    lap_main();
#ifdef not
    time2 = second();

    printf("time=%g\n",time2-time1);
#endif
    exit(0);
}

lap_main()
{
    int x,y,k;
    double sum;

    printf("lap_main ...\n");

#pragma omp parallel private(k,x,y)
{
    for(k = 0; k < NITER; k++){
#ifdef _OPENMP
	printf("k = %d, id=%d\n",k,omp_get_thread_num());
#endif
	/* old <- new */
#pragma omp for 
	for(x = 1; x <= XSIZE; x++)
	  for(y = 1; y <= YSIZE; y++)
	    uu[x][y] = u[x][y];
	/* update */
#pragma omp for
	for(x = 1; x <= XSIZE; x++)
	  for(y = 1; y <= YSIZE; y++)
	    u[x][y] = (uu[x-1][y] + uu[x+1][y] + uu[x][y-1] + uu[x][y+1])/4.0;
    }
}
    /* check sum */
    sum = 0.0;
#pragma omp parallel for private(y) reduction(+:sum)
    for(x = 1; x <= XSIZE; x++)
	for(y = 1; y <= YSIZE; y++)
	  sum += (uu[x][y]-u[x][y]);

    printf("sum = %g\n",sum);
}

