// $Id: ColorMapFrame.java,v 1.2 1999/11/09 07:53:57 m-hirano Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
import java.awt.*;
import java.util.*;
import java.awt.event.*;
import java.applet.Applet;

//
// Dialog for setting condition
//
class ColorMapFrame extends Frame implements ActionListener {
  Button hideButton;

  // constructor
  public ColorMapFrame(){
    setTitle("ColorMap");  // set title of this window 
    GridBagLayout layout = new GridBagLayout();
    setLayout(layout);
    
    GridBagConstraints c = new GridBagConstraints();
    c.gridwidth = GridBagConstraints.REMAINDER;
    c.anchor = GridBagConstraints.CENTER;
    
    Label label = new Label("Color Map for OpenMP tlog file  ...");
    layout.setConstraints(label,c);
    add(label);
    
    addLegend(layout,"parallel",Color.white,true);
    addLegend(layout,"barrier",Color.red,true);
    addLegend(layout,"critical",Color.yellow,true);
    addLegend(layout,"loopInit",Color.green,false);
    addLegend(layout,"loopNext",Color.cyan,false);
    addLegend(layout,"section",Color.magenta,false);
    addLegend(layout,"single",Color.blue,false);

    hideButton = new Button(" Hide ");
    layout.setConstraints(hideButton,c);
    hideButton.addActionListener(this);
    add(hideButton);
    pack();
  }
  
  void addLegend(GridBagLayout layout,String name,
		 Color color,boolean isRect){
    GridBagConstraints c = new GridBagConstraints();
    c.gridwidth = GridBagConstraints.RELATIVE;
    c.anchor = GridBagConstraints.WEST;
    c.ipadx = 5;
    c.ipady = 5;
    c.insets = new Insets(2,5,2,5);
    ColorLegend lg = new ColorLegend(color,isRect);
    layout.setConstraints(lg,c);
    add(lg);

    c.gridwidth = GridBagConstraints.REMAINDER;
    Label label = new Label(name);
    layout.setConstraints(label,c);
    add(label);
  }

  public void actionPerformed(ActionEvent e){
    if(e.getSource() == hideButton){
      dispose();
    }
  }
}

class ColorLegend extends Canvas {
  boolean isRect;
  Color color;

  final static int HEIGHT = 20;
  final static int WIDTH = 30;

  public ColorLegend(Color color,boolean isRect){
    this.color = color;
    this.isRect = isRect;
  }

  public Dimension getMinimumSize(){
    return new Dimension(WIDTH,HEIGHT);
  }

  public Dimension getPreferredSize() { 
    return getMinimumSize();
  }

  public Insets getInsets() {
    return new Insets(2,5,2,5);
  }
  
  public void paint(Graphics g){
    g.setColor(color);
    if(isRect)
      g.fillRect(0,0,WIDTH,HEIGHT);
    else
      g.drawLine(WIDTH/2,0,WIDTH/2,HEIGHT);
  }
}









