// $Id: tlogDataFile.java,v 1.4 2000/12/14 05:06:21 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $

import java.io.*;
import java.util.Vector;
import java.util.Stack;

public class tlogDataFile {
  static final int MAX_PE = 64;
  static final int TLOG_BLOCK_SIZE = 1024;
  int npe;
  Vector logData[];
  double min_time, max_time;
  int dispHint[];
  static final int MAX_DATA_BLOCK = 2000;

  public boolean Input(String filename){
    int i;
    min_time = Double.MAX_VALUE;
    max_time = Double.MIN_VALUE;
    logData = new Vector [MAX_PE];
    dispHint = new int [MAX_PE];
    
    for(i = 0; i < MAX_PE; i++) logData[i] = new Vector();
    byte [] block = new byte[TLOG_BLOCK_SIZE];
    FileInputStream inFile = null;
    int nbytes = 0;

    try {
      inFile = new FileInputStream(filename);
    } catch(FileNotFoundException e){
      System.err.println("cannot open logfile '"+filename+"'");
      System.exit(1);
    }
    if(inFile == null) return false;

    int n_blk = 0;
    try {
      while(true){
	nbytes = inFile.read(block);
	n_blk++;
	if(n_blk > MAX_DATA_BLOCK){
	  System.err.println("too big log file, truncated (Max Num. of Blocks ="+
			     MAX_DATA_BLOCK+")");
	  break;
	}
	if(nbytes == -1) break;
	if(nbytes != TLOG_BLOCK_SIZE){
	  System.err.println("bad log file");
	  System.exit(1);
	}
	DataInputStream in = 
	  new DataInputStream(new ByteArrayInputStream(block));
      
	try {
	  while(true){
	    byte type = in.readByte();
	    int id = (int)(in.readByte());
	    int arg1 = (int)(in.readShort());
	    int arg2 = in.readInt();
	    double time = in.readDouble();
	    if(min_time > time) min_time = time;
	    if(max_time < time) max_time = time;
	    tlogData d = new tlogData(type,id,arg1,arg2,time);
	    /* System.out.println("data="+d); */
	    if(id >= 0 && id < MAX_PE)
	      logData[id].addElement(d);
	    else {
	      System.err.println("warning: bad data was found, id("+
			       id+") out of range, ingored");
	    }
	  }
	} catch(EOFException e){ }
      }
    } catch(IOException e){
      System.err.println("bad log data file");
      System.exit(1);
    } 
    for(i = 0; i < MAX_PE; i++)
      if(logData[i].size() != 0) npe = i+1;
    // System.out.println("npe="+npe);

    for(i = 0; i < npe; i++)  tlogCheckNested(logData[i]);
    return true;
  }

  void tlogCheckNested(Vector logs){
    Stack nested_events = new Stack();
    for(int i = 0; i < logs.size(); i++){
      tlogData d = (tlogData) logs.elementAt(i);
      switch(d.type){
      case tlogData.EVENT_OUT:
      case tlogData.FUNC_OUT:
      case tlogData.BARRIER_OUT:
      case tlogData.CRITICAL_OUT:
      case tlogData.PARALLEL_OUT:
	nested_events.pop();  // pop up IN event.
      }
      if(!nested_events.empty())
	d.setNested((tlogData)nested_events.peek());
      switch(d.type){
      case tlogData.EVENT_IN:
      case tlogData.FUNC_IN:
      case tlogData.BARRIER_IN:
      case tlogData.CRITICAL_IN:
      case tlogData.PARALLEL_IN:
	nested_events.push(d);
	break;
      }
    }
  }
}





