// $Id: tlogDump.java,v 1.2 2000/12/14 05:04:48 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $
import java.io.*;

public class tlogDump {
  final static int TLOG_BLOCK_SIZE = 1024;

  public static void main(String args[]){
    byte [] block = new byte[TLOG_BLOCK_SIZE];
    FileInputStream inFile = null;
    int nbytes = 0;

    if(args.length != 1){
      System.err.println("dump file name required...");
      System.exit(1);
    }

    try {
      inFile = new FileInputStream(args[0]);
    } catch(FileNotFoundException e){
      System.out.println("cannot open logfile");
      System.exit(1);
    }

    while(true){
      try {
	nbytes = inFile.read(block);
      } catch(IOException e){
	System.out.println("I/O exception");
	System.exit(1);
      }
      if(nbytes == -1) break;
      if(nbytes != TLOG_BLOCK_SIZE){
	System.out.println("bad log file");
	System.exit(1);
      }
      DataInputStream in = 
	new DataInputStream(new ByteArrayInputStream(block));
      
      try {
	while(true){
	  try {
	    byte type = in.readByte();
	    int id = (int)(in.readByte());
	    int arg1 = (int)(in.readShort());
	    int arg2 = in.readInt();
	    double time = in.readDouble();
	    System.out.println("type="+type+",id="+id+
			       ",arg1="+arg1+",arg2="+arg2+
			       ",time="+time);
	  } catch(EOFException e){
	    break;
	  }
	}
      } catch(IOException e){
	System.out.println("bad data");
	System.exit(1);
      } 
    }
  }
}

