// $Id: tlogview.java,v 1.4 2000/12/14 05:06:21 msato Exp $
// $RWC_Release: Omni-1.6 $
// $RWC_Copyright:
//  Omni Compiler Software Version 1.5-1.6
//  Copyright (C) 2002 PC Cluster Consortium
//  
//  This software is free software; you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License version
//  2.1 published by the Free Software Foundation.
//  
//  Omni Compiler Software Version 1.0-1.4
//  Copyright (C) 1999, 2000, 2001.
//   Tsukuba Research Center, Real World Computing Partnership, Japan.
//  
//  Please check the Copyright and License information in the files named
//  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
//  Software release kit.
//  
//  
//  $

/*
 *  tlog viewer
 */

import java.awt.*;
import java.applet.*;
import java.io.*;

public class tlogview extends Applet {
  boolean isApplet = true;
  tlogPanel ep;
  Button zoomUp, zoomDown, ShowColorMap, Exit;
  TextField fname_f;
  tlogDataFile file;  
  ColorMapFrame ColorMap;

  public void init(){
    setLayout(new BorderLayout());
    Panel buttonPanel = new Panel(new FlowLayout(FlowLayout.LEFT));
    zoomUp = new Button("Zoom Up");
    zoomDown = new Button("Zoom Down");
    Exit = new Button("Exit");
    ShowColorMap = new Button("ShowColorMap");

    fname_f = new TextField(30);
    fname_f.setEditable(false);
    buttonPanel.add(Exit);
    buttonPanel.add(zoomUp);
    buttonPanel.add(zoomDown);
    buttonPanel.add(fname_f);
    buttonPanel.add(ShowColorMap);
    add(buttonPanel,"North");
    ep = new tlogPanel();
    add(ep,"Center");
  }

  void setLogFile(String filename){
    fname_f.setText(filename);
    file = new tlogDataFile();
    file.Input(filename);
    ep.displayLog(file);
  }

  public boolean action(Event evt,Object arg){
    if (evt.target == zoomUp){
      ep.zoomUp();
      return true;
    } else if (evt.target == zoomDown){
      ep.zoomDown();
      return true;
    } else if(evt.target ==  ShowColorMap){
      if(ColorMap == null) ColorMap = new ColorMapFrame();
      ColorMap.show();
      return true;
    } else if (evt.target == Exit){
      System.exit(0);
      return true;
    } else return false;
  }

  public static void main(String args[]) {
    if(args.length != 1){
      System.err.println("dump file name required...");
      System.exit(1);
    }
    Frame f = new Frame("tlogview");
    // f.resize(600, 500);
    tlogview app = new tlogview();
    app.isApplet = false;
    app.init();
    f.add("Center", app);
    f.pack();
    app.setLogFile(args[0]);
    f.show();
  }
}



