




/*  

*************************************************************
*                                                           *
*                   axy_manager.c                           *
*                                                           *
*                INTRODUCTORY PVM EXAMPLE                   *
*                                                           *
*                                                           *
*                                                           *
*************************************************************

*/


/* multiplies an nx1 vector X by an nxn matrix A, placing the result 
   in Y 
   
   the first command-line argument specifies how many workers there 
   will be, and the second specifies the matrix size */


#include "/root/PVM3/include/pvm3.h"
#include <stdio.h>


#define MAXROW 100
#define MAXWORKERS 100


/* message types */
#define REQUEST_ROW 0
#define REPORT_YR 1
#define PROVIDE_ROW 2
#define PROVIDE_NROWS_AND_X 3
#define ALL_DONE 4


int A[MAXROW][MAXROW],  /* the multiplier */
    X[MAXROW],  /* the multiplicand */
    Y[MAXROW],  /* the product */
    WorkerTID[MAXWORKERS],  /* PVM task IDs of the workers */
    NWorkers,  /* number of workers */
    NRows,  /* number of rows in A */
    NextRow = 0,  /* next row to be multiplied */
    NumYsDone,  /* number of elements of Y computed so far */
    MyTID,  /* TID for this process */
    BufID,  /* buffer ID */
    NBytes,MsgType,TID,Row,I,J,NComp,Tmp[2];


main(argc,argv)
   int argc; char **argv;

{  /* get arguments */
   NWorkers = atoi(argv[1]);
   NRows = atoi(argv[2]);

   /* initialize A and X; just as an example, we will set
      A[I][J] to I-J and X[I] to I */
   for (I = 0; I < NRows; I++)  {
      X[I] = I;
      for (J = 0; J < NRows; J++)
         A[I][J] = I - J;
   }

   /* get PVM operations started */
   MyTID = pvm_mytid();  /* enroll in PVM */
   /* spawn the PVM tasks; the program to be run will be "axy_worker";
      it takes no arguments (so the argument pointer to it is 0);
      there will be NWorkers tasks; there task IDs will be put
      into the array WorkerTID */
   NComp = pvm_spawn("axy_worker",(char **) 0,PvmTaskDefault,"",
                     NWorkers,WorkerTID);
   if (NComp < NWorkers)  {
      printf("worker setup failed\n");
      pvm_exit();
      exit();
   }

   /* send N and X to all workers */
   /* must call pvm_initsend() each time we prepare a message
      for sending */
   pvm_initsend(PvmDataDefault);  /* there are various improvements
                                     that could be made, but let's
				     take the default */
   /* one of various PVM packing routines must be used to get
      the data into the send-buffer (which is implicit, not
      visible to the programmer) */
   /* first pack NRows, which consists of 1 int (the third argument
      will be irrelevant) */
   pvm_pkint(&NRows,1,1);
   /* then pack X, which consists of N consecutive integers; the
      three arguments say to pack N int's starting at X, taking
      every "1-th" element, i.e. the int's we want are consecutive */
   pvm_pkint(X,NRows,1);
   /* now send to all workers, using "multicast"; the third parameter 
      is the message type */
   pvm_mcast(WorkerTID,NWorkers,PROVIDE_NROWS_AND_X);

   /* now enter processing loop */
   while (NumYsDone < NRows)  {
      /* receive a message from anyone, of any type */
      BufID = pvm_recv(-1,-1);
      /* now find out who it is from, and what it is */
      pvm_bufinfo(BufID,&NBytes,&MsgType,&TID);
      switch(MsgType)  {
         case REQUEST_ROW: Row = NextRow++;
	               pvm_initsend(PvmDataDefault);
		       pvm_pkint(&Row,1,1);
		       pvm_pkint(A[Row],NRows,1);
		       /* send the message to TID, type ROW */
		       pvm_send(TID,PROVIDE_ROW);
	               break;
         case REPORT_YR: /* unpack, placing 2 consecutive int's into Tmp */
	                 pvm_upkint(Tmp,2,1);
			 Y[Tmp[0]] = Tmp[1];
			 NumYsDone++;
	                 break;
      }
   }

   /* tell everyone to quit */
   pvm_initsend(PvmDataDefault); 
   pvm_mcast(WorkerTID,NWorkers,ALL_DONE);

   /* write out Y */
   for (I = 0; I < NRows; I++) printf("%d\n",Y[I]);

   /* quit */
   pvm_exit();
}

