#!/usr/bin/perl   

# example PerlDSM application; Quicksort

# note:  not intended to be efficient at all; just an example 

use DSMClnt;

package main;

# shared variables:
@Work;  # work queue; each element consists of the following, all
        # combined into one spaces-separated string:
        #
        # beginning subscript (place in final array)
        # ending subscript (place in final array)
        # array elements of this chunk
$NWork;  # number of elements in work queue
@Z;  # final sorted array
$NZ;  # number of elements of Z determined so far
@LOCK;  # $LOCK[0] guards @Work
        # $LOCK[1] guards $NZ
@COND;
$BARR;  # barrier

# global non-shared variables:
$NumNodes;  # total number of application nodes
$MyNode;  # number of this node
$SvrSkt;  # server socket ID for this node
$N;  # full array size
$IHaveChecked = 0;  # number of chunks this node has checked
$Dummy;

# check in with server
($SvrSkt,$NumNodes,$MyNode) = DSMClnt::DSMCheckIn();
print "total of ", $NumNodes, " nodes, of which I am number ",$MyNode, "\n";

$N = $ARGV[2];

DoTying();

if ($MyNode == 0)  {
   $NZ = 0;
   # initialize Work, to consist of one element which is the original array
   # (generated randomly)
   my @X;
   foreach $I (0..$N-1)  {
      $X[$I] = rand 1.0;
   }
   $Work[0] = join("B",0,$N-1,@X);
   $NWork = 1;
}

# barrier (wait for node 0 to finish initialization)
$Dummy = $BARR;  # left-hand side irrelevant

# here is where the work gets done; this node continues to loop, getting
# a work element (or discovering sort is finished), splitting it into
# "low" and "high" chunks, and adding them to the work queue
while (1)  {
   # get work element or leave if sort is done
   my $WorkElt = GetWork();
   if (substr($WorkElt,0,5) eq "done!")  {
      last;
   }
   $IHaveChecked++;
   # split the chunk from this work element to two smaller chunks in the
   # usual Quicksort style
   my ($FirstI,$LastI,@Chunk) = split("B",$WorkElt);  
   my @ChunkLo;
   my @ChunkHi;
   # use $Chunk[0] as the pivot
   foreach $ZI (@Chunk[1..scalar(@Chunk)-1])  {
      if ($ZI < $Chunk[0])  {
         push(@ChunkLo,$ZI);
      }
      elsif ($ZI > $Chunk[0])  {
         push(@ChunkHi,$ZI);
      }
   }
   # the pivot element can now be placed into @Z
   my $PivotIndx = $FirstI + scalar(@ChunkLo);
   PlaceInZ($PivotIndx,$Chunk[0]);
   # now add the two smaller chunks to the work queue, if they contain
   # at least two elements, or place them in @Z in the one-element case
   ProcessSmallChunk($FirstI,@ChunkLo);
   ProcessSmallChunk($PivotIndx+1,@ChunkHi);
}

# wait for everyone to finish, then write answer if I am node 0
$Dummy = $BARR;
print "I checked ", $IHaveChecked, " work elements\n";
if ($MyNode == 0)  {
   foreach $ZI (@Z)  {
      print $ZI, "\n";
   }
}

$Dummy = $BARR;
DSMClnt::DSMExit();

sub GetWork  {
   while (1)  {
      $Dummy = $LOCK[0];  
      if ($NWork > 0)  {
         my $WE = $Work[$NWork-1];
         $NWork--;
         $LOCK[0] = 0;
         return $WE;
      }
      $LOCK[0] = 0;
      $Dummy = $COND[0];
   }
}

sub ProcessSmallChunk  {
   my $I = shift;  # beginning index of chunk
   my $NChunk = scalar(@_);  # number of elements in this chunk
   # check one-element case first
   if ($NChunk == 1)  {
      my $ZI = shift;
      PlaceInZ($I,$ZI);
   }
   elsif ($NChunk > 1)  {
      my $WE;  # work element to be created
      $WE = join("B",$I,$I+$NChunk-1,@_); 
      $Dummy = $LOCK[0];  
      $Work[$NWork] = $WE;
      $NWork++;
      $COND[0] = 1;
      $LOCK[0] = 0;
   }
}

sub PlaceInZ  {
   my $I = shift;
   my $ZI = shift;
   $Z[$I] = $ZI;
   $Dummy = $LOCK[1];  
   $NZ++;
   if ($NZ == $N)  {
      $Dummy = $LOCK[0];
      foreach $K (1..$NumNodes)  {
         $Work[$NWork] = "done!";
         $NWork++;
         $COND[0] = 1;
      }
      $LOCK[0] = 0;
   }
   $LOCK[1] = 0;
}

# tie shared variables
sub DoTying  {
   foreach $I (0..$N-1)  {
      tie $Work[$I],'DSMClnt',1,'$Work',$I;
      tie $Z[$I],'DSMClnt',1,'$Z',$I;
   }
   tie $NWork,'DSMClnt',0,'$NWork',-1;
   tie $NZ,'DSMClnt',0,'$NZ',-1;
   tie $LOCK[0],'DSMClnt',1,'$LOCK',0;
   tie $LOCK[1],'DSMClnt',1,'$LOCK',1;
   tie $COND[0],'DSMClnt',1,'$COND',0;
   tie $BARR,'DSMClnt',0,'$BARR',-1;
}

