

// JSim sample program:  M/M/1 queue; paired with Job.java

// test case:  
//
// % java MM1 1000.0 0 99999 1.0 0.5
// mean wait = 1.0552989

public class MM1 // required

{  static int TotJobs = 0;  // number of jobs done so far
   static float TotWait = (float) 0.0;  // total wait for those jobs
   static float MeanArrive,  // mean time between arrivals
                MeanServe;  // mean service time

   public static JSFacil Machine;  

   public static void main(String[] Argv) 

   {  float Tmp;

      JSSim.JSInit(Argv);  // required

      // get application-specific command-line arguments
      MeanArrive = Float.parseFloat(Argv[3]);
      MeanServe = Float.parseFloat(Argv[4]);

      Machine = new JSFacil();
      Machine.JSName = "machine";

      // "prime" the system:  set up first arrival
      Tmp = JSSim.JSExpon(MeanArrive);
      Job TmpEltPtr = new Job();
      // JSEvntTime and ArrivalTime will be set to the current time,
      // but JSEvntTime changes later while ArrivalTime stays the same
      TmpEltPtr.JSEvntTime = Tmp;
      TmpEltPtr.ArrivalTime = Tmp;
      TmpEltPtr.JSInsertInEvntList();  

      // now start the simulation; required call
      JSSim.JSMainLoop(Argv);
   
      // simulation done; print out result
      System.out.println("mean wait = "+TotWait/TotJobs); 
   }

}


