

// JSim sample program:  Stop-and-Wait protocol; paired with
// Frame.java, representing one transmitted frame

// test case:
//
// % java StopAndWait 1000 0 99999 0.2 2.5 0.0 0.2
// total frames sent = 618
// mean wait = 1.6171371
// mean number of xmits per frame = 1.0064725

// Network node A is sending to Network node B.  It takes 1.0 time to
// get the frame onto the network, and alpha time for the leading edge
// of the frame to reach B.  (The trailing edge arrives 1.0 time later.)
// When B receives the frame, there will be a delay before B can check
// it.  Then B will check for errors, and send back to A either an
// acknowledgement, if the frame is OK, or an error report, if not OK.
// B's response is so short, it takes negligible time to get onto the
// link, but still takes 1.0 time to get back to A.  As soon as A starts
// sending the frame, it starts a timer.  If the timeout is exceeded, or
// if A receives a report from B that the frame was in error, A will
// send the frame again.

// usage:  java StopAndWait timelimit debugflag alpha timeout p meandelay
//
// where
//
//    alpha = (one-way) propagation delay (frame transmit time = 1.0)
//    timeout = time station A waits before giving up and retransmitting
//    p = probability that Station B finds frame erroneous
//    meandelay = mean of delay before B can start sending back to A

public class StopAndWait // required

{

   public static int NextFrameToBeCreated = 0;  
   public static int TotFrames = 0;  // number of jobs done so far
   public static int TotTries = 0;  // number of tries among all jobs so far

   public static float TotWait = (float) 0.0;  // total wait for those jobs

   public static float Alpha,TimeoutTime,P,MeanDelay;

   public static Frame Frm;  // a frame
   public static JSElt TmOt;  // a timeout event

   public static void main(String[] Argv) 

   {  float Tmp;

      JSSim.JSInit(Argv);  // required init

      // get command-line arguments
      Alpha = Float.parseFloat(Argv[3]);
      TimeoutTime = Float.parseFloat(Argv[4]);
      P = Float.parseFloat(Argv[5]);
      MeanDelay = Float.parseFloat(Argv[6]);

      // set up first xmit, to initialize event list  
      // need to create objects first
      Frm = new Frame();
      TmOt = new Timeout();
      Frm.SendFrame(true);
   
      JSSim.JSMainLoop(Argv);  // required; here is where the work is done
   
      // simulation done, so print out results
      System.out.println("total frames sent = "+TotFrames); 
      System.out.println("mean wait = "+TotWait/TotFrames); 
      System.out.println("mean number of xmits per frame = "
         +(float) TotTries/TotFrames); 
   }

}

