

// one simulation facility, e.g. a machine

// NOTE CAREFULLY:  usage of this class assumes that the application
// uses the JSServiceTime variable in JSElt

public class JSFacil  {

   String JSName;  // name of facility, e.g. "machine"
   boolean JSBusy;  // server currently busy
   int JSNQ;  // number of jobs in queue
   JSElt JSFclQHd,JSFclQTl;  // ptrs to queue head and tail 
   JSElt JSCurrJob;  // ptr to job currently being served

   // appends current event to the queue at this facility; use this only
   // if the facility is currently in use, i.e. the facility cannot
   // immediately start this job
   void JSAppendToFclQ() 

   {  if (JSFclQHd == null)  {
         JSFclQHd = JSFclQTl = JSSim.JSCurrEvnt;
         JSSim.JSCurrEvnt.JSNext = null;  
      }
      else  {
         JSFclQTl.JSNext = JSSim.JSCurrEvnt; 
         JSSim.JSCurrEvnt.JSNext = null;
         JSFclQTl = JSSim.JSCurrEvnt; 
      }
      JSNQ++;
      if (JSSim.JSDebug)
         System.out.println("job appended to queue for "+this.JSName+
         ", JSNQ now "+this.JSNQ);
   }

   // if the facility is not busy (must not be called otherwise),
   // this takes the JSElt pointed to by Ptr and starts its service
   void JSStartServe(JSElt Ptr)

   {  JSBusy = true;
      Ptr.JSEvntTime = JSSim.JSSimTime + Ptr.JSServiceTime;
      Ptr.JSNext = null;
      JSCurrJob = Ptr;
      if (JSSim.JSDebug)
         System.out.println("start serve, JSEltNumber "+Ptr.JSEltNumber+
            ", leaving "+JSNQ+" still in queue");
      Ptr.JSInsertInEvntList();
   }

   // does bookkeeping associated with finishing a job, and starting the
   // next job, if any; returns true or false, depending on whether a
   // new job was started
   boolean JSDoneServe()  

   {  JSElt OldFclQHd;   

      JSBusy = false;
      JSCurrJob = null;
      if (JSNQ == 0) return false;
   
      OldFclQHd = JSFclQHd;
      if (JSFclQHd == JSFclQTl) JSFclQHd = JSFclQTl = null;
      else JSFclQHd = JSFclQHd.JSNext;
      JSNQ--;
      JSStartServe(OldFclQHd);
      return true;
   }


   // called during debugging
   void JSPrintFclInfo()

   {  JSElt TmpPtr;
   
      if (JSBusy)  {
         System.out.println(JSName+" has "+" job in service, ");
         if (JSNQ == 0)  System.out.println("and none ");
         else  {
            System.out.println("and ID(s) ");
            TmpPtr = JSFclQHd;
            while (TmpPtr != null)  {
               System.out.println(TmpPtr.JSEltNumber+" ");
               TmpPtr = TmpPtr.JSNext;
            }
         }
         System.out.println("queued");
      }
      else System.out.println(JSName+" is idle");
   }    


}

