
import java.util.Random;

// this class contains data and methods related to the general operation
// of JSim

public class JSSim  

{  
   static float JSSimTime;  // current simulated time
   static float JSMaxSimTime;  // amount of simulated time to be run 
   static boolean JSDebug;  // true for debugging
   public static JSElt JSEvntListHd;  // schedule list
   static JSElt JSCurrEvnt;  // event currently being processed
   static int JSNextNew;  // ID number to be assigned to the next 
                          // JSElt created

   static Random RndCls;  // for generating random numbers

   // does the JSim system (i.e. non-application specific) initializations
   static void JSInit(String[] Argv)

   {  JSEvntListHd = null;
      JSCurrEvnt = null;
      JSSimTime = (float) 0.0;
      JSNextNew = 0;
      JSMaxSimTime = Float.parseFloat(Argv[0]);
      if (Integer.parseInt(Argv[1]) == 1) JSDebug = true;
      else JSDebug = false;
      int JSSeed = Integer.parseInt(Argv[2]);
      RndCls = new Random((long) JSSeed);
   }

   // forms the main loop of the entire simulation
   static void JSMainLoop(String[] Argv)

   {  
      // while current simulated time is less than the max specified by
      // the user, do:
      while (JSSimTime <= JSMaxSimTime)  {
         JSElt.JSGetNext();  // get next event
         JSSimTime = JSCurrEvnt.JSEvntTime;  // advance the simulation clock
         if (JSDebug)  {
            System.out.println();
            System.out.println();
            System.out.println("***************************************");
            System.out.println();
            System.out.println("time "+JSSimTime);
            System.out.println("current event:");
            JSCurrEvnt.JSPrintElt();
            System.out.println("event list before handling current event:");
            JSPrintEvntList(); 
            System.out.println();
         }
         // wipe out old stuff, to avoid debugging confusion later
         JSCurrEvnt.JSEvntTime = (float) -1.0;   
         JSCurrEvnt.JSEvntHandler();  // process the current event
         if (JSDebug)  {
            System.out.println("event list after handling current event:");
            JSPrintEvntList(); 
            System.out.println();
         }
      }
   }

   // prints out the entire event list, for debugging
   public static void JSPrintEvntList()

   {  JSElt TmpEltPtr = JSEvntListHd;

      while (TmpEltPtr != null)  {
         TmpEltPtr.JSPrintElt();
         TmpEltPtr = TmpEltPtr.JSNext;   
      }
   
   }

   // U(0,1) random variable generator
   static float JSRnd()

   {  return RndCls.nextFloat();  }

   // exponential random variable generator
   static float JSExpon(float Mu)

   {  return -Mu * (float) Math.log((double) JSRnd());  }

}


