

// JSim sample program:  M/M/1 queue; paired with Machine.java and 
// MachineJob.java

public class Main // required

{  static int TotJobs = 0;  // number of jobs done so far
   static float TotWait = (float) 0.0;  // total wait for those jobs
   static float MeanArrive,  // mean time between arrivals
                MeanServe;  // mean service time

   public static JSFacil Machine;  

   public static void main(String[] Argv) 

   {  float Tmp;

      JSSim.JSInit(Argv);  // required

      // get application-specific command-line arguments
      MeanArrive = Float.parseFloat(Argv[2]);
      MeanServe = Float.parseFloat(Argv[3]);

      Machine = new JSFacil();
      Machine.JSName = "machine";

      // "prime" the system:  set up first arrival
      Tmp = JSSim.JSExpon(MeanArrive);
      MachineJob TmpEltPtr = new MachineJob();
      TmpEltPtr.JSEvntTime = Tmp;
      TmpEltPtr.ArrivalTime = Tmp;
      TmpEltPtr.JSInsertInSchedList();  

      // now start the simulation; required call
      JSSim.JSMainLoop(Argv);
   
      // simulation done; print out result
      System.out.println("mean wait = "+TotWait/TotJobs); 
   }

   // required; called from JSSim but is application-specific
   public static void EvntHandler() 

   {  if (JSSim.JSCurrEvnt.JSEvntMatch("arrive")) 
         DoArrival();
      else 
         DoDone();
   }

   // event handler:  case "arrive"
   public static void DoArrival()

   {  float Tmp;

      JSSim.JSCurrEvnt.JSName = "done with service";
      JSSim.JSCurrEvnt.JSServiceTime = JSSim.JSExpon(MeanServe);
      // try to serve, else add to machine queue
      if (!Machine.JSBusy)  {
         Machine.JSStartServe(JSSim.JSCurrEvnt);
      }
      else Machine.JSAppendToFclQ();

      // schedule the next arrival
      Tmp = JSSim.JSExpon(MeanArrive); 
      Tmp += JSSim.JSSimTime;
      MachineJob TmpEltPtr = new MachineJob();
      TmpEltPtr.JSEvntTime = Tmp;
      TmpEltPtr.ArrivalTime = Tmp;
      TmpEltPtr.JSInsertInSchedList();
   }

   // event handler:  case "done with service"
   public static void DoDone() 

   {  // process the job which just finished 
      TotJobs++;
      MachineJob TmpAE = (MachineJob) JSSim.JSCurrEvnt;
      TotWait += JSSim.JSSimTime - TmpAE.ArrivalTime;
      // bookkeeping, plus a check of machine's queue
      float TmpF = JSSim.JSExpon(MeanServe);  
      Machine.JSDoneServe();
      return;
   }

}


