


// this class contains data and methods related to the general operation
// of JSim; note that it MUST be extended, and JSEvntHandler() MUST be
// overridden

public class JSSim  

{  
   static float JSSimTime;  // current simulated time
   static float JSMaxSimTime;  // amount of simulated time to be run 
   static int JSDebug;  // 1 for debugging, else 0
   static int JSNextNew;  // ID number to be assigned to the next 
                          // JSElt created

   // does the JSim system (i.e. non-application specific) initializations
   static void JSInit(String[] Argv)

   {  JSElt.JSSchedListHd = null;
      JSElt.JSCurrEvnt = null;
      JSSimTime = (float) 0.0;
      JSNextNew = 0;
      JSMaxSimTime = Float.parseFloat(Argv[0]);
      JSDebug = Integer.parseInt(Argv[1]);
   }

   // JSEvntHandler() is user-written, with the version here being only
   // a dummy; the actual function will be like a "switch" statement
   // that takes different actions depending on the event type in 
   // JSElt.JSCurrEvnt

   void JSEvntHandler()

   { ; }

   // forms the main loop in main() in application program
   void JSMainLoop(String[] Argv)

   {  while (JSSimTime <= JSMaxSimTime)  {
         JSElt.JSGetNext();
         JSSimTime = JSElt.JSCurrEvnt.JSEvntTime;
         if (JSDebug == 1)  {
            System.out.println();
            System.out.println();
            System.out.println("***************************************");
            System.out.println();
            System.out.println("time "+JSSimTime);
            System.out.println("current event:");
            JSElt.JSCurrEvnt.JSPrintElt();
            System.out.println("event list before handling current event:");
            JSElt.JSPrintSchedList(); 
            System.out.println();
         }
         // wipe out old stuff, to avoid debugging confusion later
         JSElt.JSCurrEvnt.JSEvntTime = (float) -1.0;   
         JSElt.JSCurrEvnt.JSNext = null;   
         this.JSEvntHandler();  
         if (JSDebug == 1)  {
            System.out.println("event list after handling current event:");
            JSElt.JSPrintSchedList(); 
            System.out.println();
         }
      }
   }

   // U(0,1) random variable generator
   static float JSRnd()

   {  return (float) Math.random(); }

   // exponential random variable generator
   static float JSExpon(float Mu)

   {  return (-Mu*(float) Math.log((double) JSRnd())); }

}


