

// JSim sample program:  Stop-and-Wait protocol

// usage:  java StopAndWait timelimit debugflag alpha timeout p meandelay
// where
//
//    alpha = (one-way) propagation delay (frame transmit time = 1.0)
//    timeout = time station A waits before giving up and retransmitting
//    p = probability that Station B finds frame erroneous
//    meandelay = mean of delay before B can start sending back to A

public class StopAndWait

{

   public static int NextFrameToBeCreated = 0;  
   public static int TotFrames = 0;  // number of jobs done so far
   public static int TotTries = 0;  // number of tries among all jobs so far

   public static float TotWait = (float) 0.0;  // total wait for those jobs

   public static float Alpha,Timeout,P,MeanDelay;

   public static FrameElt Frame;
   public static TimeoutElt TmOt;

   public static void main(String[] Argv) 

   {  float Tmp;

      StopAndWaitSim Sim = new StopAndWaitSim();  // required JSSim
      Sim.JSInit(Argv);  // required init

      // get command-line arguments
      Alpha = Float.parseFloat(Argv[2]);
      Timeout = Float.parseFloat(Argv[3]);
      P = Float.parseFloat(Argv[4]);
      MeanDelay = Float.parseFloat(Argv[5]);

      Frame = new FrameElt();
      TmOt = new TimeoutElt();

      // set up first xmit, to initialize event list 
      Sim.SendFrame(true);
   
      Sim.JSMainLoop(Argv);  // required; here is where the work is done
   
      // simulation done, so print out results
      System.out.println("total frames sent = "+TotFrames); 
      System.out.println("mean wait = "+TotWait/TotFrames); 
      System.out.println("mean number of xmits per frame = "
         +(float) TotTries/TotFrames); 
   }

}

