

// JSim sample program:  Stop-and-Wait protocol

class StopAndWaitSim extends JSSim  // required

{

   // send the frame and set the timer; if this is the first xmit of the
   // frame, set New = true

   static void SendFrame(boolean New)

   {  StopAndWait.Frame.JSName = "arrive at B";
      StopAndWait.Frame.JSEvntTime = JSSimTime + 1 + StopAndWait.Alpha;
      if (New)  {
         StopAndWait.Frame.FrameNumber = StopAndWait.NextFrameToBeCreated++;
         StopAndWait.Frame.StartTime = StopAndWait.Frame.JSEvntTime;
         StopAndWait.Frame.NTries = 1;
      }
      else StopAndWait.Frame.NTries++;
      StopAndWait.Frame.Trashed = false;
      StopAndWait.Frame.JSInsertInSchedList();
      // set up the paired timeout
      StopAndWait.TmOt.JSEvntTime = JSSimTime + StopAndWait.Timeout;
      StopAndWait.TmOt.JSName = "timeout";
      StopAndWait.TmOt.JSInsertInSchedList(); 
      // pair them together to enable one to cancel the other
      StopAndWait.Frame.TimeoutEltNumber = StopAndWait.TmOt.JSEltNumber;
      StopAndWait.TmOt.FrameEltNumber = StopAndWait.Frame.JSEltNumber;
   }

   void DoArrivalAtB()

   {  StopAndWait.Frame.JSCurrEvnt.JSName = "done with delay";
      StopAndWait.Frame.JSEvntTime = JSSimTime + JSExpon(StopAndWait.MeanDelay);
      StopAndWait.Frame.JSInsertInSchedList();
   }

   void DoDelayDone()

   {  StopAndWait.Frame.Trashed = (JSRnd() < StopAndWait.P);
      StopAndWait.Frame.JSCurrEvnt.JSName = "arrive back at A";
      StopAndWait.Frame.JSEvntTime = JSSimTime + StopAndWait.Alpha;
      StopAndWait.Frame.JSInsertInSchedList();
   }

   void DoArrivalBackToA()

   {  // we beat the timeout, so cancel it
      StopAndWait.Frame.JSCancel(StopAndWait.Frame.TimeoutEltNumber);
      if (StopAndWait.Frame.Trashed)  {
         StopAndWait.TotFrames++;
         StopAndWait.TotWait += JSSimTime - StopAndWait.Frame.StartTime;
         StopAndWait.TotTries += StopAndWait.Frame.NTries;
         SendFrame(false);  // failed, try sending again
      }
      else SendFrame(true);  // done, so send a new frame

   }
 
   void DoTimeout()

   {  // timed out, so cancel the scheduled arrival of this frame
      StopAndWait.Frame.JSCancel(StopAndWait.TmOt.FrameEltNumber);
      SendFrame(false);  // try sending it again
   }

   public void JSEvntHandler()  // overrides JSSim's dummy method; required

   {  

      if (StopAndWait.Frame.JSCurrEvnt.JSEvntMatch("arrive at B")) 
         {DoArrivalAtB(); return;}
      if (StopAndWait.Frame.JSCurrEvnt.JSEvntMatch("done with delay")) 
         {DoDelayDone(); return;}
      if (StopAndWait.Frame.JSCurrEvnt.JSEvntMatch("arrive back at A")) 
         {DoArrivalBackToA(); return;}
      if (StopAndWait.Frame.JSCurrEvnt.JSEvntMatch("timeout")) 
         {DoTimeout(); return;}
      System.out.println("shouldn't reach this point");
      System.exit(1);
   }

}

