

// JSim sample program:  Stop-and-Wait protocol

// usage:  java StopAndWait timelimit debugflag alpha timeout p meandelay
// where
//
//    alpha = (one-way) propagation delay (frame transmit time = 1.0)
//    timeout = time station A waits before giving up and retransmitting
//    p = probability that Station B finds frame erroneous
//    meandelay = mean of delay before B can start sending back to A

public class StopAndWait extends JSSim  // required

{

   public static int NextFrameToBeCreated = 0;  
   public static int TotFrames = 0;  // number of jobs done so far
   public static int TotTries = 0;  // number of tries among all jobs so far

   public static float TotWait = (float) 0.0;  // total wait for those jobs

   public static float Alpha,Timeout,P,MeanDelay;

   public static FrameElt Frame;
   public static TimeoutElt TmOt;

   public static void main(String[] Argv) 

   {  float Tmp;

      // as presently configured, the following is required (to be
      // changed in the future)
      StopAndWait Sim = new StopAndWait(); 
 
      Sim.JSInit(Argv);  // required init

      // get command-line arguments
      Alpha = Float.parseFloat(Argv[2]);
      Timeout = Float.parseFloat(Argv[3]);
      P = Float.parseFloat(Argv[4]);
      MeanDelay = Float.parseFloat(Argv[5]);

      Frame = new FrameElt();
      TmOt = new TimeoutElt();

      // set up first xmit, to initialize event list 
      Sim.SendFrame(true);
   
      Sim.JSMainLoop(Argv);  // required; here is where the work is done
   
      // simulation done, so print out results
      System.out.println("total frames sent = "+TotFrames); 
      System.out.println("mean wait = "+TotWait/TotFrames); 
      System.out.println("mean number of xmits per frame = "
         +(float) TotTries/TotFrames); 
   }

   // send the frame and set the timer; if this is the first xmit of the
   // frame, set New = true

   static void SendFrame(boolean New)

   {  Frame.JSName = "arrive at B";
      Frame.JSEvntTime = JSSimTime + 1 + Alpha;
      if (New)  {
         Frame.FrameNumber = NextFrameToBeCreated++;
         Frame.StartTime = JSSimTime;
         Frame.NTries = 1;
      }
      else Frame.NTries++;
      Frame.Trashed = false;
      Frame.JSInsertInSchedList();
      // set up the paired timeout
      TmOt.JSEvntTime = JSSimTime + Timeout;
      TmOt.JSName = "timeout";
      TmOt.JSInsertInSchedList(); 
      // pair them together to enable one to cancel the other
      Frame.TimeoutEltNumber = TmOt.JSEltNumber;
      TmOt.FrameEltNumber = Frame.JSEltNumber;
   }

   void DoArrivalAtB()

   {  Frame.JSCurrEvnt.JSName = "done with delay";
      Frame.JSEvntTime = JSSimTime + JSExpon(MeanDelay);
      Frame.JSInsertInSchedList();
   }

   void DoDelayDone()

   {  Frame.Trashed = (JSRnd() < P);
      Frame.JSCurrEvnt.JSName = "arrive back at A";
      Frame.JSEvntTime = JSSimTime + Alpha;
      Frame.JSInsertInSchedList();
   }

   void DoArrivalBackToA()

   {  // we beat the timeout, so cancel it
      Frame.JSCancel(Frame.TimeoutEltNumber);
      if (Frame.Trashed)  
         SendFrame(false);  // failed, try sending again
      else  {
         // succeeded
         // need to do some bookkeeping 
         TotFrames++;
         TotWait += JSSimTime - Frame.StartTime;
         TotTries += Frame.NTries;
         // done, so send the next frame
         SendFrame(true);  
      }
   }
 
   void DoTimeout()

   {  // timed out, so cancel the scheduled arrival of this frame
      Frame.JSCancel(TmOt.FrameEltNumber);
      SendFrame(false);  // try sending it again
   }

   public void JSEvntHandler()  // overrides JSSim's dummy method; required

   {  

      if (Frame.JSCurrEvnt.JSEvntMatch("arrive at B")) 
         {DoArrivalAtB(); return;}
      if (Frame.JSCurrEvnt.JSEvntMatch("done with delay")) 
         {DoDelayDone(); return;}
      if (Frame.JSCurrEvnt.JSEvntMatch("arrive back at A")) 
         {DoArrivalBackToA(); return;}
      if (Frame.JSCurrEvnt.JSEvntMatch("timeout")) 
         {DoTimeout(); return;}
      System.out.println("shouldn't reach this point");
      System.exit(1);
   }

}

