/* UCTuplets sample program

   does matrix multiplication, A*X = Y, where A is nxn, and X
   and Y are nx1

   A and X will be generated within the program; the rows form a
   task farm, and are sent out to the nodes by node 1, using the 
   "row" tuples

   the "next" tuple states which row to multiply next; a row index 
   value >= N means we are all done

*/

#include <UCTInclude.h> 

#define MAX_N 500

int N, // dimension of matrix 
    A[MAX_N*MAX_N], // the matrix (stored in one dimension)
    X[MAX_N], // the X vector
    Me,  // id of this node
    Row,  // index of current row to multiply 
    Debug;

InitAX()  /* serves as a simple example; in some applications,
             A and X might come from elsewhere, including disk and 
             the tuple space */ 

{  int I,J;

   if (Me == 1)  {
      for (I = 0; I < N; I++)  {
         for (J = 0; J < N; J++)
            A[I*N+J] = I - J;
      }
   }
   for (I = 0; I < N; I++) X[I] = I;
}

int Mult(int *Z)

{  int J,DP = 0;

   for (J = 0; J < N; J++) DP += Z[J] * X[J];
   return DP;
}

DoWork()

{  int DotProduct,Lng,Next;
   int ARow[MAX_N];

   while (1)  {
      // which row should we multiply next?
      in("sp","next",&Next);
      // set up for the next node which requests work
      out("si","next",Next+1);
      // check for signal indicating done
      if (Next >= N) return;
      // now do the work
      in("sppI","row",&Row,&Lng,ARow);
      DotProduct = Mult(ARow);
      out("sii","y",Row,DotProduct);  
   }
}

Worker()

{  int Value,Node,I;

   N = atoi(UCTArgv[1]);
   Debug = atoi(UCTArgv[2]);

   while(Debug) ;

   Me = UCTNodeNum;

   // set A and X 
   InitAX();
   
   // set up the "row" and "next" tuples 
   if (Me == 1)  {
      for (I = 0; I < N; I++)
         // I-th row starts at A+I*N
         out("siiI","row",I,N,A+I*N);
      out("si","next",0);
   }

   // here is where the main work is done 
   DoWork();

   if (Me == 1)  {
      // don't need a barrier, since in() will block if tuple not ready yet
      for (I = 0; I < N; I++)  {
         in("sip","y",I,&Value);
	 printf("%d\n",Value);
      }
   }
}

int main(int argc, char **argv)

{  UCTInit(argc,argv);  }

