//UCTInclude.h
//Writen by Michael Foster
//for ECS 158 - Programming on Parallel Architectures
//May 16, 1999

//This header file describes the user interface to theis package.  All of the functions that
//are availabe to the user and need to be defined by the user are prototyped here.  
//Any variables meant for the user are also defined in this header file
#include <stdarg.h>

#define MAX_TM_LENGTH      50          // Maximum Length of Tuple manager name
#define MAX_TUPLES         100         // Maximum Number of Tuples in Tuple Space
#define BUFF_SIZE          1000000     // Size of Message buffer. Any array or string must fit in this. 
#define REQ_BUFF_SIZE      64          // Number of Requests allowed to manager(max number of nodes)
#define COMP_SIZE          sizeof(int) // Size of each component (typically a word)

int UCTInit(int argc, char * argv[]);  //Must be called in main()
int Worker(void);                      //The user supplied function that does the work

// See the manual for how to use these functions
int rd(char *type, ...);  // Retrieve a copy a tuple, but do not remove from tuple space
int in(char *type, ...);  // Remove and returna tuple from tuple space
int out(char *type, ...); // Insert a tuple into tuple space


// USER ACCESSABLE GLOBAL DATA/////////
char UCTTMName[MAX_TM_LENGTH];// tuple manager node name */
int UCTPortNum,               // port number for tuple manager 
    UCTNodeNum,               // number of this node 
    UCTNWorkNodes;            // Total number of nodes
int UCTArgc;                  // Replacement for argc 
char **UCTArgv;               // Replacement for argv[]
