//UCTuple.c
//Writen by Michael Foster
//for ECS 158 - Programming on Parallel Architectures
//May 16, 1999

#include <UCTInclude.h>

//This is the definition of a Tuple. The tuple is defined by its typestring and the 
//data it contains.  If there are no arrays or strings, there will be nothing contained
//in the data array, all the information will be contained in the component array.  All
//The strings and arrays are stored int he data buffer.  When a string is stored.  THe
//component array will hold the index to the start of the string.  All strings MUST be 
//null terminated, otherwise results are undefined.  Arrays of words are also stored in
//the data array.  The index to the start of the array in the data buffer is held in the 
//component array, and the length is contained in the previous word of the component array.
typedef struct UCT{
   //The number of elements in the tuple
   int size;
   
   //This is the type string.  Each character corresponds to 
   //a component.  The letter describes the type of the component.
   char *type;    
   
   //These are the actuall components held in the tupil.
   //If the component is a string type or an array type the actuall
   //value in this array is the character number in which the data starts 
   //in the data buffer.  Strings MUST be null('\0') terminated for this 
   //structure to function properly.  Arrays MUST have their length stored 
   //in the previous component
   int *component;
   
   //This array will hold all of the arrays and strings contained in 
   //the tuple.  If more data is needed that the constant MAX_DATA should
   //be changed to accomodate you needs.
   char *data;
   
   //amount of memory allocated for data buffer
   int datasize;
} UCTuple;


//////////////////Functions for use on Tuples////////////////////////////////
//This constructor is how most Tuples will be created.  This takes 
//a type sring, component array, and if need be a cahracter array with the 
//strings and arrays copied into it.  See above for details on buffer and component 
//array formats.
int creteTuple(UCTuple *tuple, char *t, int *c, char* d);         

//deallocate the memory in the tuple
void destroyTuple(UCTuple *t);

//returns 1 if the tuple matches given information, 0 otherwise.  If the match 
//string contains a letter other than a,w, or s, that component will not be
//used in the matching process.
int UCTmatch(UCTuple t, char *match, int *c, char *d);  

//Copy components into type comp and data
int getComps(UCTuple t,char **type, int **comp, char **data);

//Does a member wise copy of the tuple src into dest
void copyTuple(UCTuple *dest, UCTuple src);
