//UCTFront.c
//Writen by Michael Foster
//for ECS 158 - Programming on Parallel Architectures
//May 16, 1999

#include <UCTFunc.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

extern int SD;

//////////////////////////////////////
/////////// UCTInit //////////////////
//////////////////////////////////////
int UCTInit(int argc, char **argv){

   if (argc< 4) {
      printf("ERROR: not enough arguments\n");
      return(-1);
   }
   strcpy(UCTTMName, argv[1]); 
   UCTPortNum = atoi(argv[2]);
   UCTNodeNum = atoi(argv[3]);
   UCTNWorkNodes = atoi(argv[4]) - 1;
   UCTArgc = argc-4;      
   UCTArgv= &argv[4];

   if (UCTNodeNum == 0) return(UCTupleManager());  
   return(ConnectToMgr());
   
}

//////////////////////////////////////
////////////// rd ////////////////////
//////////////////////////////////////
int rd(char *type, ...){
   va_list args;
   int *comp=NULL, *retcomp=NULL;
   char buffer[MSG_SIZE], *rettype=NULL;
   char *data=NULL, *retdata=NULL;
   int size=0;
   int i;   

   size = strlen(type);
   comp = malloc(size*COMP_SIZE);

   va_start(args,type);
   get_args(args,type,&comp,&data);
   
   if (send_msg(SD, READ, type, comp, data) == -1){
      printf("ERROR: sending read\n");
      return (-1);
   }

   readAll(SD,buffer,MSG_SIZE); //read header
   if (recv_msg(&rettype, &retcomp, &retdata,buffer, SD) == -1){ //read tuple info
      printf("ERROR: retrieving tuple from read\n");
      return (-1);
   }

   //put infomatin where it needs to be
   for (i=0;i<size;i++){
      switch(type[i]){
      case ('p'):
         memcpy((char*)comp[i], &retcomp[i], COMP_SIZE);
         break;
      case('I'):
      case('F'):
         if (type[i-1] == 'p'){
            memcpy((char*)(comp[i]), (retdata+(retcomp[i])), retcomp[i-1]*COMP_SIZE);
         }
         break;
      }
   }
   return(0);
}


//////////////////////////////////////
////////////// in ////////////////////
//////////////////////////////////////
int in(char *type, ...){
   va_list args;
   int *comp=NULL, *retcomp=NULL;
   char buffer[MSG_SIZE], *rettype=NULL;
   char *data=NULL, *retdata=NULL;
   int size=0;
   int i;   

   size = strlen(type);
   comp = malloc(size*COMP_SIZE);

   va_start(args,type);
   get_args(args,type,&comp,&data);
   
   if (send_msg(SD, IN, type, comp, data) == -1){
      printf("ERROR: sending read\n");
      return (-1);
   }

   readAll(SD,buffer,MSG_SIZE); //read header
   if (recv_msg(&rettype, &retcomp, &retdata,buffer, SD) == -1){ //read tuple info
      printf("ERROR: retrieving tuple from read\n");
      return (-1);
   }

   //put infomatin where it needs to be
   for (i=0;i<size;i++){
      switch(type[i]){
      case ('p'):
         memcpy((char*)comp[i], &retcomp[i], COMP_SIZE);
         break;
      case('I'):
      case('F'):
         if (type[i-1] == 'p'){
            memcpy((char*)comp[i], retdata+retcomp[i], retcomp[i-1]*COMP_SIZE);
         }
         break;
      }
   }
   return(0);
}

//////////////////////////////////////
////////////// out ///////////////////
//////////////////////////////////////
int out(char *type, ...){
   va_list args;
   int *comp=NULL;
   char *data=NULL, buffer[MSG_SIZE];
   int size=0;
   

   size = strlen(type);
   comp = malloc(size*COMP_SIZE);

   va_start(args,type);
   get_args(args, type, &comp, &data);
   
   if (send_msg(SD, OUT, type, comp, data) == -1){
      printf("ERROR: sending read\n");
      return (-1);
   }

   readAll(SD,buffer,MSG_SIZE); //read header

}
