//UCTuple.c
//Writen by Michael Foster
//for ECS 158 - Programming on Parallel Architectures
//May 16, 1999

#include <UCTuple.h>
#include <stdlib.h>
#include <string.h>
/////////////////////////////////////
/////////// createTuple //////////////
//////////////////////////////////////
//This will allocated the memeory for a tuple and copy the 
//data into the tuple variables.
int createTuple(UCTuple *tuple, char *t, int *c, char *d){
   int i, d_ptr=0, b_ptr=0;
   
   tuple->type = NULL;
   tuple->component = NULL;
   tuple->data = NULL;

   tuple->datasize = 0;
   tuple->size = strlen(t);

   tuple->type = malloc(tuple->size+1);
   tuple->component = malloc(tuple->size*COMP_SIZE);
   
   strcpy(tuple->type, t);
   memcpy(tuple->component, c, tuple->size*COMP_SIZE);

   for (i=0; i<tuple->size; i++){
      switch(tuple->type[i]){
      case('I'):
      case('F'):
         if (tuple->type[i-1] != 'p'){
            tuple->datasize += tuple->component[i-1]*COMP_SIZE;
            tuple->data = realloc(tuple->data, tuple ->datasize);
            memcpy(tuple->data+tuple->component[i], d+c[i], tuple->component[i-1]*COMP_SIZE);
         }
         break;
      case('s'):
         tuple->datasize += strlen(d+c[i])+1; //strlen doesn't account for null terminating character
         tuple->data = realloc(tuple->data, tuple->datasize);
         strcpy(tuple->data+tuple->component[i], d+c[i]);
         break;
      }
   }
   return(0);
}

//////////////////////////////////////
/////////// destroyTuple  ////////////
//////////////////////////////////////
//Deallocate any allocated memory in the tuple
void destroyTuple(UCTuple *t){
   if (t->size >0){
      free (t->type);
      free (t->component);
      if (t->datasize > 0) {
         free(t->data);
         t->datasize =0;
      }
      t->size=0;
   }

}


//////////////////////////////////////
/////////// UCTmatch /////////////////
//////////////////////////////////////
//Checks to see if the tple matches the components
//given.  any components of type p or an array preceded by
//a pointer will be ignored in the match
int UCTmatch(UCTuple t, char *match, int *c, char *d){
   int i,j;

   if ((signed)strlen(match) != t.size) return(0);
   for (i=0; i<t.size; i++){
      switch (match[i]){
      case('i'):
      case('f'):
         if (t.type[i] != match[i]) return(0);
         if (c[i] != t.component[i]) return(0);
         break;
      case ('s'):
         if (t.type[i] != match[i]) return(0);
         if (strcmp((d+c[i]), (t.data+t.component[i])) != 0) return(0);
         break;
      case('I'):
      case('F'):
         if (match[i-1] != 'p'){ //check to see if we are returning into the array
            if (t.type[i] != match[i]) return(0);
            for (j=0; j<(signed)(t.component[i-1]*sizeof(int)); j++){
               if ((t.data+t.component[i])[j] != (d+c[i])[j]) return(0);
            }
         }
      }
   } 
   return(1);
}

//////////////////////////////////////
/////////// getComps /////////////////
//////////////////////////////////////
//place the data in the tuple into the variables type, comp, and data
int getComps(UCTuple t, char **type, int **comp, char **data){
   strcpy(*type, t.type);
   memcpy(*comp, t.component, t.size*COMP_SIZE);
   if (t.datasize > 0){//check to see if there is any extra data
      *data = realloc(*data, t.datasize);
      memcpy(*data, t.data, t.datasize);
   }
   return(0);
}

//////////////////////////////////////
/////////// copyTuple ////////////////
//////////////////////////////////////
//This will allocate the memory in the dest tuple and then
//do a memberwise copy.
void copyTuple(UCTuple *dest, UCTuple src){
   dest->size = src.size;
   dest->type = malloc(dest->size+1);
   strcpy(dest->type, src.type);
   dest->component = malloc(dest->size*COMP_SIZE);
   memcpy(dest->component, src.component, dest->size*COMP_SIZE);
   dest->datasize = src.datasize;
   if (src.datasize > 0){
      dest->data = malloc(dest->datasize);
      memcpy(dest->data, src.data, dest->datasize);
   }
}
