// This code extends the example from Shiffman mentioned below, but applies several filters to a full an image. MN
// NOTE: here I am changing the filter size, but you could also apply the filter iteratively.
//
/*Controls
o  : original
1 - 4 : blur levels
s  : sharpen
*/

//This code is a modified version of the following:
// Learning Processing
// Daniel Shiffman
// http://www.learningprocessing.com

// Example 15-13: Sharpen with convolution


PImage img; //we load this image and never modify it

PImage workingImage; //This is the input to the convolution.  In this example,
                      //it is simply the same as img, but this would not be the
                      //case if we want to repeatedly apply a filter...
                      
PImage outputImage;  //this is the final image we display

// The convolution matrix for a "sharpen" effect stored as a 3 x 3 two-dimensional array.
float[][] sharpen = { { -1, -1, -1 } , 
                     { -1, 9, -1 } ,
                     { -1, -1, -1 } } ;

float[][] blurSmall = { { 1/9.0, 1/9.0, 1/9.0 } , 
                     { 1/9.0, 1/9.0, 1/9.0 } ,
                     { 1/9.0, 1/9.0, 1/9.0 } } ;

float [][] blurMedium = { {1/25.0, 1/25.0, 1/25.0, 1/25.0, 1/25.0} ,
                        {1/25.0, 1/25.0, 1/25.0, 1/25.0, 1/25.0} ,
                        {1/25.0, 1/25.0, 1/25.0, 1/25.0, 1/25.0} ,
                        {1/25.0, 1/25.0, 1/25.0, 1/25.0, 1/25.0} ,
                        {1/25.0, 1/25.0, 1/25.0, 1/25.0, 1/25.0} };

float [][] blurLarge = { {1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0 } ,
                        {1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0 } ,
                        {1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0 } ,
                        {1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0 } ,
                        {1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0 } ,
                        {1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0 } ,
                        {1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0 } };

float [][] blurHuge = { {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} };

float [][] gFilter = blurLarge;

boolean bShowFiltered = false;

void setup() {
  size(940, 700);
  img = loadImage( "coastCropped.jpg" );
  //start out having the output be the unprocessed image
  outputImage = loadImage( "coastCropped.jpg" );
  workingImage = createImage(img.width, img.height, RGB);
}


void draw() {
  

  //copy image to the working image
  img.loadPixels();
  workingImage.loadPixels();
  for (int x = 0; x < img.width; x++ ) {
    for (int y = 0; y < img.height; y++ ) {
      int loc = x + y * img.width;
      workingImage.pixels[loc] = img.pixels[loc];
      
    }
  }
  workingImage.updatePixels();

  //modify the output image
  if(bShowFiltered)
  {
      int matrixsize = gFilter.length;
      

      outputImage.loadPixels();
      workingImage.loadPixels();
      
      // Begin our loop for every pixel
      for (int x = 0; x < outputImage.width; x++ ) {
        for (int y = 0; y < outputImage.height; y++ ) {
          // Each pixel location (x,y) gets passed into a function called convolution()
          // The convolution() function returns a new color to be displayed.
          color c = convolution(x,y,gFilter,matrixsize,workingImage); 
          int loc = x + y*img.width;
          
          //Good point to understand:
          //why should I not use workingImage here?? (hint:  look at the convolution function)
          outputImage.pixels[loc] = c;

        }
      }
    
      outputImage.updatePixels();
  }
  image(outputImage, 0, 0);
  
}

void keyPressed()
{
  if(key == 'o')
  {
    //display original 
    bShowFiltered = false;
    outputImage = loadImage( "coastCropped.jpg" );
  }
  else if(key == 's')
  {
    //sharpen
    bShowFiltered = true;
    gFilter = sharpen;
  }
  else if(key == '1')
  {
    //blur
    bShowFiltered = true;
    gFilter = blurSmall;
  }
  else if(key == '2')
  {
    //blur
    bShowFiltered = true;
    gFilter = blurMedium;
  }
  else if(key == '3')
  {
    //blur
    bShowFiltered = true;
    gFilter = blurLarge;
  }
  else if(key == '4')
  {
    //blur
    bShowFiltered = true;
    gFilter = blurHuge;
  }
}

//Copy and use Shiffman's convolution function in your own code!
//Read through it and make sure you understand what it is doing.
//Modified to fix error in numerical drift and switch indices.
color convolution(int x, int y, float[][] matrix, int matrixsize, PImage img) 
{
  float rtotal = 0.0;
  float gtotal = 0.0;
  float btotal = 0.0;
  int offset = matrixsize / 2;
  
  // Loop through convolution matrix
  for (int col = 0; col < matrixsize; col++ ) {
    for (int row = 0; row < matrixsize; row++ ) {
      
      // What pixel are we testing
      int xloc = x + col-offset;
      int yloc = y + row-offset;
      int loc = xloc + img.width*yloc;
      
      // Make sure we haven't walked off the edge of the pixel array
      // It is often good when looking at neighboring pixels to make sure we have not gone off the edge of the pixel array by accident.
      loc = constrain(loc,0,img.pixels.length-1);
      
      // Calculate the convolution
      // We sum all the neighboring pixels multiplied by the values in the convolution matrix.
      //Note:  I flipped the indices to make things more intuitive when doing
      //the 1D blur. MN
      rtotal += (red(img.pixels[loc]) * matrix[row][col]);
      gtotal += (green(img.pixels[loc]) * matrix[row][col]);
      btotal += (blue(img.pixels[loc]) * matrix[row][col]);
    }
  }
 
 
  
  //This necessary to help correct for numerical drift.  MN 
  rtotal += 0.5;
  gtotal += 0.5;
  btotal += 0.5;
  
  // Make sure RGB is within range
  rtotal = constrain(rtotal,0,255);
  gtotal = constrain(gtotal,0,255);
  btotal = constrain(btotal,0,255);
  
  // Return the resulting color
  return color(rtotal,gtotal,btotal); 
}
