//a simple particle class
class NParticle
{
  //Particle position
  float m_xPos = 0;//I could use a vector for this, but keeping it simple. 
  float m_yPos = 0;

  //particle velocity
  float m_xVel, m_yVel;

  //particle acceleration.  Default to gravity
  float m_xAccel = 0, m_yAccel = 9.8;

  //size of particle
  float m_diameter = 10;

  //scale allows you to adjust the overall speed (basically
  //changing the metre to pixel mapping)
  float m_scale = 80;


  color m_color = color(0, 0, 200, 100);
  
  //empty constructor
  NParticle(float xPos, float yPos, float xVel, float yVel)
  {
    m_xPos = xPos;
    m_yPos = yPos;
    m_xVel = xVel;
    m_yVel = yVel;
  }

  //draw the star
  void drawMe()
  {
  
    stroke(m_color);
    fill(m_color);  
    ellipseMode(CENTER);
    ellipse(m_xPos, m_yPos, m_diameter, m_diameter);
  }

  //change the star's position
  void setPos(float x, float y)
  {
    m_xPos = x;
    m_yPos = y;
  }

  //Update the velocity and position of particle
  //timeStep is the amount of time that has passed since
  //the last update
  void update(float timeStep)
  {
    //Euler integration of system state one time step
    m_xVel += m_xAccel * timeStep;
    m_yVel += m_yAccel * timeStep;
    m_xPos += m_xVel * timeStep * m_scale;
    m_yPos += m_yVel * timeStep * m_scale;
  }
}

//For example using single object
NParticle [] particle = new NParticle[0];



int gNumParticles = 1;

float gGroundPlane = 550;
float gRestitution = .7;

void setup()
{
  frameRate(60);
  size(1000, 600);
  background(255);
  smooth();
  
  //NOTE: this must be done within a method
//  particle[0] = new NParticle(500, 30, -1.0, 0);
}

int gParticlesPerFrame = 1;
int gParticleFrequency = 1; //how many frames to skip between emission
int gMaxParticles = 200;

void draw()
{

  background(255);
  line(0, gGroundPlane, width, gGroundPlane);

  //emit new particles.  There are three different alternatives
  //below.  You can uncomment one and see how it works.
  
  //uncomment this one for raining balls
  
  if(gNumParticles+gParticlesPerFrame <= gMaxParticles  && frameCount%gParticleFrequency == 0) 
  {
    for(int i=0; i<gParticlesPerFrame; i++)
    {
      NParticle newParticle = new NParticle(random(width), 0, 0, 0);
      particle = (NParticle [])append(particle, newParticle);
    }
    gNumParticles += gParticlesPerFrame;
  }
  

/*
  //uncomment this one for a waterfall
  if(gNumParticles+gParticlesPerFrame <= gMaxParticles  && frameCount%gParticleFrequency == 0) 
  {
    //globals should reall be set above, but I want everything to be grouped for the example
    gParticlesPerFrame = 2;
    gRestitution = 0.2;//less bounce for water
    
    for(int i=0; i<gParticlesPerFrame; i++)
    {
      NParticle newParticle = new NParticle(700, -20, -random(2.0,2.5), 0);
      particle = (NParticle [])append(particle, newParticle);
    }
    gNumParticles += gParticlesPerFrame;
  }
*/
  //uncomment this one for a fountain
 /*
  if(gNumParticles+gParticlesPerFrame <= gMaxParticles  && frameCount%gParticleFrequency == 0) 
  {
    //These globals should be set up above, but I wanted everything
    //to be in one place
    gRestitution = 0.2;//less bounce for water
    gParticlesPerFrame = 3;
    gMaxParticles = 500;

    for(int i=0; i<gParticlesPerFrame; i++)
    {
      //do random sampling in polar coordinates
      float theta = random(230, 300);
      float r = random(4,5);
      //convert to Cartesian coordinates
      float xVel = r*cos(radians(theta));
      float yVel = r*sin(radians(theta));
      NParticle newParticle = new NParticle(500, 200, xVel, yVel);
      particle = (NParticle [])append(particle, newParticle);
    }
    gNumParticles += gParticlesPerFrame;
  }
*/

  //update and draw particles
  for (int i = 0; i<particle.length; i++)
  {
    
    //update the particle's position
    particle[i].update(1.0/frameRate);


    //check for collisions with the ground
    float edgePos = particle[i].m_yPos + particle[i].m_diameter/2.0;
    if (edgePos > gGroundPlane)
    {
      //reverse the velocity, reducing it to reflect
      //energy lost during collision
      particle[i].m_yPos += gGroundPlane-edgePos;
      particle[i].m_yVel *= -gRestitution;
      
    }
    
    //draw the particle
    particle[i].drawMe();

  }
  //  println(particle[i].m_xPos + " " + particle[i].m_yPos);
}

