//a simple particle class
class NParticle
{
  //Particle position
  float m_xPos = 0;//I could use a vector for this, but keeping it simple. 
  float m_yPos = 0;

  //particle velocity
  float m_xVel, m_yVel;

  //particle acceleration.  Default to gravity
  float m_xAccel = 0, m_yAccel = 9.8;

  //size of particle
  float m_diameter = 10;

  //scale allows you to adjust the overall speed (basically
  //changing the metre to pixel mapping)
  float m_scale = 60;
  
  
  //empty constructor
  NParticle(float xPos, float yPos, float xVel, float yVel)
  {
    m_xPos = xPos;
    m_yPos = yPos;
    m_xVel = xVel;
    m_yVel = yVel;
  }

  //draw the star
  void drawMe()
  {
    ellipseMode(CENTER);
    ellipse(m_xPos, m_yPos, m_diameter, m_diameter);
  }

  //change the star's position
  void setPos(float x, float y)
  {
    m_xPos = x;
    m_yPos = y;
  }

  //Update the velocity and position of particle
  //timeStep is the amount of time that has passed since
  //the last update
  void update(float timeStep)
  {
    //Euler integration of system state one time step
    m_xVel += m_xAccel * timeStep;
    m_yVel += m_yAccel * timeStep;
    m_xPos += m_xVel * timeStep * m_scale;
    m_yPos += m_yVel * timeStep * m_scale;
  }
  
}

//For example using single object
NParticle testParticle = new NParticle(500, 30, -1.0, 0);

float gGroundPlane = 550;
float gRestitution = .7;

void setup()
{
  frameRate(60);
  size(600, 600);
  background(255);
  smooth();

    

}

void draw()
{

  background(255);
  line(0, gGroundPlane, width, gGroundPlane);
  
  testParticle.update(1.0/frameRate);
  testParticle.drawMe();
  
  float edgePos = testParticle.m_yPos + testParticle.m_diameter/2.0;
  if(edgePos > gGroundPlane)
  {
    
    testParticle.m_yPos += gGroundPlane-edgePos;
    testParticle.m_yVel *= -gRestitution;
  } 
 // println(testParticle.m_xPos + " " + testParticle.m_yPos);
}
