// This code extends the example from Shiffman mentioned below, but applies several filters to a full an image. MN
// NOTE: here I am changing the filter size, but you could also apply the filter iteratively.
//
// Learning Processing
// Daniel Shiffman
// http://www.learningprocessing.com

// Example 15-13: Sharpen with convolution


PImage img;

// The convolution matrix for a "sharpen" effect stored as a 3 x 3 two-dimensional array.
float[][] sharpen = { { -1, -1, -1 } , 
                     { -1, 9, -1 } ,
                     { -1, -1, -1 } } ;

float[][] blurSmall = { { 1/9.0, 1/9.0, 1/9.0 } , 
                     { 1/9.0, 1/9.0, 1/9.0 } ,
                     { 1/9.0, 1/9.0, 1/9.0 } } ;

float [][] blurMedium = { {1/25.0, 1/25.0, 1/25.0, 1/25.0, 1/25.0} ,
                        {1/25.0, 1/25.0, 1/25.0, 1/25.0, 1/25.0} ,
                        {1/25.0, 1/25.0, 1/25.0, 1/25.0, 1/25.0} ,
                        {1/25.0, 1/25.0, 1/25.0, 1/25.0, 1/25.0} ,
                        {1/25.0, 1/25.0, 1/25.0, 1/25.0, 1/25.0} };

float [][] blurLarge = { {1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0 } ,
                        {1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0 } ,
                        {1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0 } ,
                        {1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0 } ,
                        {1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0 } ,
                        {1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0 } ,
                        {1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0, 1/49.0 } };

float [][] blurHuge = { {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} ,
                      {1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0, 1/400.0} };

float [][] gFilter = blurLarge;

boolean bShowFiltered = false;

void setup() {
  size(940, 700);
  img = loadImage( "coastCropped.jpg" );
}


void draw() {
  
  // We're only going to process a portion of the image
  // so let's set the whole image as the background first
  image(img,0,0);

  if(bShowFiltered)
  {
    int matrixsize = gFilter.length;
    
    
    loadPixels();
    // Begin our loop for every pixel
    for (int x = 0; x < img.width; x++ ) {
      for (int y = 0; y < img.height; y++ ) {
        // Each pixel location (x,y) gets passed into a function called convolution()
        // The convolution() function returns a new color to be displayed.
        color c = convolution(x,y,gFilter,matrixsize,img); 
        int loc = x + y*img.width;
        pixels[loc] = c;
      }
    }
    updatePixels();
  }
}

void keyPressed()
{
  if(key == 'o')
  {
    //display original 
    bShowFiltered = false;
  }
  else if(key == 's')
  {
    //sharpen
    bShowFiltered = true;
    gFilter = sharpen;
  }
  else if(key == '1')
  {
    //blur
    bShowFiltered = true;
    gFilter = blurSmall;
  }
  else if(key == '2')
  {
    //blur
    bShowFiltered = true;
    gFilter = blurMedium;
  }
  else if(key == '3')
  {
    //blur
    bShowFiltered = true;
    gFilter = blurLarge;
  }
  else if(key == '4')
  {
    //blur
    bShowFiltered = true;
    gFilter = blurHuge;
  }
}

//Copy and use Shiffman's convolution function in your own code!
//Read through it and make sure you understand what it is doing.
color convolution(int x, int y, float[][] matrix, int matrixsize, PImage img) 
{
  float rtotal = 0.0;
  float gtotal = 0.0;
  float btotal = 0.0;
  int offset = matrixsize / 2;
  
  // Loop through convolution matrix
  for (int i = 0; i < matrixsize; i++ ) {
    for (int j = 0; j < matrixsize; j++ ) {
      
      // What pixel are we testing
      int xloc = x + i-offset;
      int yloc = y + j-offset;
      int loc = xloc + img.width*yloc;
      
      // Make sure we haven't walked off the edge of the pixel array
      // It is often good when looking at neighboring pixels to make sure we have not gone off the edge of the pixel array by accident.
      loc = constrain(loc,0,img.pixels.length-1);
      
      // Calculate the convolution
      // We sum all the neighboring pixels multiplied by the values in the convolution matrix.
      rtotal += (red(img.pixels[loc]) * matrix[i][j]);
      gtotal += (green(img.pixels[loc]) * matrix[i][j]);
      btotal += (blue(img.pixels[loc]) * matrix[i][j]);
    }
  }
  
  // Make sure RGB is within range
  rtotal = constrain(rtotal,0,255);
  gtotal = constrain(gtotal,0,255);
  btotal = constrain(btotal,0,255);
  
  // Return the resulting color
  return color(rtotal,gtotal,btotal); 
}
