PImage srcImg1;
PImage srcImg2;
PImage destImg;

int gCenter = 200;

void setup()
{
  size(940, 700);
  background(255);

  //Two keep things simple, I'm going to assume that all images are the same size
  srcImg1 = loadImage("coastCropped.jpg");
  srcImg2 = loadImage("TimsCupCropped.jpg");
  destImg = createImage(srcImg1.width, srcImg1.height, color(0, 0, 200));
  destImg.updatePixels();

  //load the src pixel arrays
  srcImg1.loadPixels();
  srcImg2.loadPixels();
}


void draw()
{
  background(255);

  int numRows = destImg.height;
  int numCols = destImg.width;

  for (int cols = 0; cols < numCols; cols++)
  {
    float weight;
    float halfWidth = 100;
    if (cols < gCenter - halfWidth)
    {
      weight = 1.0;
    }
    else if (cols > gCenter + halfWidth)
    {
      weight = 0;
    }
    else 
    {
      weight = (gCenter + halfWidth-cols)/(2.0*halfWidth);
    } 

    for (int rows = 0; rows < numRows; rows++)
    {
      int pixelNum = rows * destImg.width + cols;
      float red, green, blue;
      red = weight * red(srcImg1.pixels[pixelNum]) + (1-weight) * red(srcImg2.pixels[pixelNum]);
      green = weight * green(srcImg1.pixels[pixelNum]) + (1-weight) * green(srcImg2.pixels[pixelNum]);
      blue = weight * blue(srcImg1.pixels[pixelNum]) + (1-weight) * blue(srcImg2.pixels[pixelNum]);
      
      destImg.pixels[pixelNum] = color(red, green, blue);
    }
  }


  //copy result to image
  destImg.updatePixels();

  //display the image
  image(destImg, 0, 0);
}

void keyPressed()
{
  if (key == 'l')
  {
  }
}

void mouseClicked()
{
  save("likeThis.jpg");
}

void mouseDragged()
{
  gCenter = mouseX;
}

