//Show the effects of the various built-in filters

PImage img;

int curFilter = THRESHOLD;
int secondParam = 4;

boolean bShowFiltered = false;

void setup() {
  size(940, 700);
  img = loadImage( "coastCropped.jpg" );
}


void draw() {

  // We're only going to process a portion of the image
  // so let's set the whole image as the background first
  image(img, 0, 0);

  if (bShowFiltered)
  {
    if (curFilter == POSTERIZE || curFilter == BLUR)
    { 
      filter(curFilter, secondParam);
    }
    else
    {
      filter(curFilter);
    }
  }

}

void keyPressed()
{
  if (key == 'o')
  {
    //display original 
    bShowFiltered = false;
  }
  else if (key == 't')
  {
    bShowFiltered = true;
    curFilter = THRESHOLD;
  }
  else if (key == 'g')
  {
    bShowFiltered = true;
    curFilter = GRAY;
  }
  else if (key == 'q')
  {
    bShowFiltered = true;
    curFilter = OPAQUE;
  }
  else if (key == 'i')
  {
    bShowFiltered = true;
    curFilter = INVERT;
  }
  else if (key == 'p')
  {
    bShowFiltered = true;
    curFilter = POSTERIZE;
    secondParam = 4;
  }
  else if (key == 'b')
  {
    bShowFiltered = true;
    curFilter = BLUR;
    secondParam = 5;
  }
  else if (key == 'e')
  {
    bShowFiltered = true;
    curFilter = ERODE;
  }
  else if (key == 'd')
  {
    bShowFiltered = true;
    curFilter = DILATE;
  }
}

//Copy and use Shiffman's convolution function in your own code!
//Read through it and make sure you understand what it is doing.
color convolution(int x, int y, float[][] matrix, int matrixsize, PImage img) 
{
  float rtotal = 0.0;
  float gtotal = 0.0;
  float btotal = 0.0;
  int offset = matrixsize / 2;

  // Loop through convolution matrix
  for (int i = 0; i < matrixsize; i++ ) {
    for (int j = 0; j < matrixsize; j++ ) {

      // What pixel are we testing
      int xloc = x + i-offset;
      int yloc = y + j-offset;
      int loc = xloc + img.width*yloc;

      // Make sure we haven't walked off the edge of the pixel array
      // It is often good when looking at neighboring pixels to make sure we have not gone off the edge of the pixel array by accident.
      loc = constrain(loc, 0, img.pixels.length-1);

      // Calculate the convolution
      // We sum all the neighboring pixels multiplied by the values in the convolution matrix.
      rtotal += (red(img.pixels[loc]) * matrix[i][j]);
      gtotal += (green(img.pixels[loc]) * matrix[i][j]);
      btotal += (blue(img.pixels[loc]) * matrix[i][j]);
    }
  }

  // Make sure RGB is within range
  rtotal = constrain(rtotal, 0, 255);
  gtotal = constrain(gtotal, 0, 255);
  btotal = constrain(btotal, 0, 255);

  // Return the resulting color
  return color(rtotal, gtotal, btotal);
}

