// The basic brightness mirror code is from Shiffman.  I extended it to allow more
// flexible control of the resolutions of both the camera and output window. MN
//
// Learning Processing
// Daniel Shiffman
// http://www.learningprocessing.com

// Example 16-8: Brightness mirror

// Each pixel from the video source is drawn as a
// rectangle with size based on brightness.

import processing.video.*;

// Size of each cell in the grid
int blockSize = 10;

//do we use every input pixel (1), every second (2), etc.
int samplingRate = 5;

// Number of columns and rows in our system
int cols, rows;
//int vidCols=160, vidRows=120;
int vidCols=320, vidRows=240;
// Variable for capture device
Capture video;


void setup() {
  cols = vidCols*blockSize/samplingRate;
  rows = vidRows*blockSize/samplingRate;
  
  size(cols, rows);

  smooth();

  video = new Capture(this,vidCols,vidRows,30);
  video.start();
  
  

}

void draw() {
  if (video.available()) {
    video.read();
  }
  background(0);

  video.loadPixels();

  // Begin loop for columns
  for (int i = 0; i < vidCols; i+=samplingRate) {
    // Begin loop for rows
    for (int j = 0; j < vidRows; j+=samplingRate) {

      // Where are we, pixel-wise?
      int x = i*blockSize/samplingRate;
      int y = j*blockSize/samplingRate;

      // Reversing x to mirror the image
      // In order to mirror the image, the column is reversed with the following formula:
      // mirrored column = width - column - 1
      int loc = (video.width - i - 1) + j*video.width;

      // Each rect is colored white with a size determined by brightness
      color c = video.pixels[loc];

      // A rectangle size is calculated as a function of the pixel's brightness. 
      // A bright pixel is a large rectangle, and a dark pixel is a small one.
      float sz = (brightness(c)/255.0)*blockSize; 
      rectMode(CENTER);
      fill(255);
      noStroke();
      rect(x + blockSize/2,y + blockSize/2,sz,sz);

    }
  }

  
 
}
