//Simple example of playing back a video

//Must import the library in order to use the Movie class
import processing.video.*;

//Declare movie object that will hold the movie
Movie movie;

boolean bPlaying;

void setup() {
  size(332,297);
  
  //Load the movie
  //NOTE:  movie must be in a subfolder named "data"
  movie = new Movie(this,"WipeGesture.mov");
  
  //start the play immediately and have it loop
  movie.loop();
  bPlaying = true;
}

void draw() {
  
  // Check to see if a new frame is available
  if (movie.available()) {
    //Read the frame
    movie.read();
  }
  
 //Display the frame
 image(movie,0,0);
}

void mouseClicked()
{
  if(bPlaying)
  {
    movie.pause();
    bPlaying = false;
  }
  else
  {
    movie.loop();
    bPlaying = true;
  }
}
    
