
//Class to store a 3D point
class Point
{
  float x;
  float y;
  float z;
}

class Ints3
{
  int x;
  int y;
  int z;
}

//Three Golden Rectangles, aligned with each plane in the standard set of axes, can be inscribed
//in an icosahedron.  The icosahedron is drawn by connecting their corners.  
//We first setup the three rects.

Point [] rectXY;
Point [] rectXZ;
Point [] rectYZ;

Ints3 [] triangles;

float GoldenRatio = 1.61803398875;
float scaleFac = 100.0;
float rotDegrees = 0;
float rotDegreesX = 0;

void setup()
{
  size(600, 600, OPENGL);
  background(255);


  rectXY = new Point[4]; //vertical plane
  rectXZ = new Point[4]; //horizontal plane
  rectYZ = new Point[4]; //sagittal plane

  for (int i=0; i<4; i++)
  {
    rectXY[i] = new Point();
    rectXZ[i] = new Point();
    rectYZ[i] = new Point();
    
    rectXY[i].z = 0.0;
    rectXZ[i].y = 0.0;
    rectYZ[i].x = 0.0;

    if(i == 1 || i == 2)
    {
      rectXY[i].x = scaleFac;
      rectXZ[i].z = scaleFac;
      rectYZ[i].y = scaleFac;
    }
    else
    {
      rectXY[i].x = -scaleFac;
      rectXZ[i].z = -scaleFac;
      rectYZ[i].y = -scaleFac;
    }
    
    if (i<2)
    {
      rectXY[i].y = GoldenRatio * scaleFac;
      rectXZ[i].x = GoldenRatio * scaleFac;
      rectYZ[i].z = GoldenRatio * scaleFac;
    }
    else
    {
      rectXY[i].y = -GoldenRatio * scaleFac;
      rectXZ[i].x = -GoldenRatio * scaleFac;
      rectYZ[i].z = -GoldenRatio * scaleFac;
    }
  }

/*  
  for(int i =0; i<4; i++)
  {
    println("XY" + i + " " + rectXY[i].x + " " + rectXY[i].y + " " + rectXY[i].z);
//    println("XZ" + i + " " + rectXZ[i].x + " " + rectXZ[i].y + " " + rectXZ[i].z);
//    println("YZ" + i + " " + rectYZ[i].x + " " + rectYZ[i].y + " " + rectYZ[i].z);
  }
  */
  
    //initialize a list of which corners must be connected to form the icosahedron
  triangles = new Ints3[8];
  for(int i =0; i< 8; i++) triangles[i] = new Ints3();
  triangles[0].x = 0;
  triangles[0].y = 2;
  triangles[0].z = 1;
  triangles[1].x = 0;
  triangles[1].y = 3;
  triangles[1].z = 2;
  triangles[2].x = 1;
  triangles[2].y = 1;
  triangles[2].z = 1;
  triangles[3].x = 1;
  triangles[3].y = 0;
  triangles[3].z = 2;
  triangles[4].x = 2;
  triangles[4].y = 1;
  triangles[4].z = 0;
  triangles[5].x = 2;
  triangles[5].y = 0;
  triangles[5].z = 3;
  triangles[6].x = 3;
  triangles[6].y = 2;
  triangles[6].z = 0;
  triangles[7].x = 3;
  triangles[7].y = 3;
  triangles[7].z = 3;
  
  
  noFill();

}

void draw()
{
  background(255);

  //Draw a Triangle
/*  beginShape(TRIANGLES);
  vertex(50, 50);
  vertex(150, 50);
  vertex(150, 150);
  endShape(CLOSE);
*/

  //center it
  translate(300,300);
  
  //rotate it with mouse input
  rotateY(radians(rotDegrees));
  rotateX(radians(-rotDegreesX));
  
  int corner = 0;
  //draw a more complex shape, an Icosahedron

  //Draw the golden rectangles  
  fill(195,0,0,100);
  beginShape();
  for(int i = 0; i<4; i++)
  {
    vertex(rectXY[i].x, rectXY[i].y, rectXY[i].z);
  }
  endShape(CLOSE);

  fill(0, 195,0,100);
  beginShape();
  for(int i = 0; i<4; i++)
  {
    vertex(rectXZ[i].x, rectXZ[i].y, rectXZ[i].z);
  }
  endShape(CLOSE);
 
  fill(0, 0, 195, 100);
  beginShape();
  for(int i = 0; i<4; i++)
  {
    vertex(rectYZ[i].x, rectYZ[i].y, rectYZ[i].z);
  }
  endShape(CLOSE);

  noFill();
  //draw the triangles that form the Icos
  for(int i =0; i<8; i++)
  {
  beginShape(TRIANGLES);
    corner = triangles[i].x;
    vertex(rectXY[corner].x, rectXY[corner].y, rectXY[corner].z);
    corner = triangles[i].y;
    vertex(rectXZ[corner].x, rectXZ[corner].y, rectXZ[corner].z);
    corner = triangles[i].z;
    vertex(rectYZ[corner].x, rectYZ[corner].y, rectYZ[corner].z);
  endShape(CLOSE);    
  }

  //Draw the lines that run along the short edge of each golden triangle
  beginShape(LINES);
    corner = 0;
    vertex(rectXY[corner].x, rectXY[corner].y, rectXY[corner].z);
    corner = 1;
    vertex(rectXY[corner].x, rectXY[corner].y, rectXY[corner].z);

    corner = 2;
    vertex(rectXY[corner].x, rectXY[corner].y, rectXY[corner].z);
    corner = 3;
    vertex(rectXY[corner].x, rectXY[corner].y, rectXY[corner].z);

    corner = 0;
    vertex(rectXZ[corner].x, rectXZ[corner].y, rectXZ[corner].z);
    corner = 1;
    vertex(rectXZ[corner].x, rectXZ[corner].y, rectXZ[corner].z);

    corner = 2;
    vertex(rectXZ[corner].x, rectXZ[corner].y, rectXZ[corner].z);
    corner = 3;
    vertex(rectXZ[corner].x, rectXZ[corner].y, rectXZ[corner].z);


    corner = 0;
    vertex(rectYZ[corner].x, rectYZ[corner].y, rectYZ[corner].z);
    corner = 1;
    vertex(rectYZ[corner].x, rectYZ[corner].y, rectYZ[corner].z);

    corner = 2;
    vertex(rectYZ[corner].x, rectYZ[corner].y, rectYZ[corner].z);
    corner = 3;
    vertex(rectYZ[corner].x, rectYZ[corner].y, rectYZ[corner].z);
    
  endShape();    
  
  

  
}

void mouseDragged()
{
  rotDegrees = mouseX-300;
  rotDegreesX = mouseY-300;
}
