
float count = 0;
float speed = 5.0;

float [][] speedFactor;
float [][] transFactor1;
float [][] transFactor2;

int numRows = 10;
int numCols = 10;

boolean runSim = false;

void setup()
{
  size(600, 600, OPENGL);
  background(255);
  rectMode(CENTER);
  fill(140, 40, 10);
  strokeWeight(0);
  
  speedFactor = new float[numRows][numCols];
  transFactor1 = new float[numRows][numCols];
  transFactor2 = new float[numRows][numCols];

  for(int i =0; i< numRows; i++)
  {
    for(int j = 0; j<numCols; j++)
    {
      speedFactor[i][j] = random(.6, 1.8);
      transFactor1[i][j] = random(.9, 1.1);
      transFactor2[i][j] = random(.9, 1.1);
    }
  }  
}

void draw()
{
  background(255);

  if(runSim)
  {
    count = count + speed;
  }
  
  
  float offsetX = 250;
  float offsetY = 250;
  float sWidth = 10;
  
  translate(0, 0, count);
  for(int i =0; i< numRows; i++)
  {
    for(int j = 0; j<numCols; j++)
    {
      pushMatrix();
      
      //for each of x and y, specify the object offset, the offset of the
      //small object within the block and a random offset that grows
      //over time
      
      translate(offsetX + (1-transFactor1[i][j])*count + i*sWidth, offsetY + j*sWidth + (1-transFactor2[i][j])*count);
      rotateY(radians(speedFactor[i][j]*count));
      rotateX(radians(speedFactor[i][j]*count));
      rotateZ(radians(speedFactor[i][j]*count));
      
      rect(0, 0, sWidth, sWidth);
      popMatrix();
    }
  }
  
  
}

void mouseClicked()
{
  runSim = !runSim;
}

