float x, y;
float r = 4;//size of step.  I used 4 with noise() and 40 with random()
float time = 0;
float increment = .1;//vary this with noise to vary the curve roughness

boolean gStopped = false;

void setup()
{
  size(600, 600);
  background(255);
  noiseSeed(100);
  randomSeed(100);

  x = width/2.0;
  y = height/2.0;
}

void draw()
{

  if (!gStopped)
  {
    float prevX, prevY;
    prevX = x;
    prevY = y;

    //uncomment 1 of the 2 blocks below

    //uncomment this for random version
    //  float theta = random(360);

    //uncommon two lines below for noise version
    float theta = 360*noise(time);
    time += increment;

    float tmpX = x;
    float tmpY = y;

    tmpX += r * cos(radians(theta)); 
    tmpY += r * sin(radians(theta)); 

    //only update if you are not taking a step off the screen
    if (!(tmpX<0 || tmpY<0 || tmpX>width || tmpY > height))
    {
      x = tmpX;
      y = tmpY;
    }

    //draw the sketch
    line(prevX, prevY, x, y);
  }
}

//use the 's' key to start and stop drawing
void keyPressed()
{
  if (key == 's')
  {
    gStopped = !gStopped;
  }
}

